/**\mainpage Herwig++ Reference Manual

This is the reference manual for Herwig++.

\section HwIntroduction Introduction

Herwig++ is a C++ Monte Carlo event generator.

*/

/** \defgroup Hadronization Hadronization Classes
These classes are used for the Hadronization.
*/

/** \defgroup Helicity Helicity classes
These classes are used to include spin correlation effects.
*/

/** \defgroup Interfaces Interfaces classes
These classes are used to interface to external tools, like
matrix element generators, jet finder algorithms, etc.
*/

/** \defgroup MatrixElement MatrixElement classes
These classes are used for the hard process generation.
*/

/** \defgroup Matchbox Matchbox classes
Hard process generation at NLO using Catani-Seymour
subtraction and NLO matching.
*/

/** \defgroup Models Models classes
These classes are used for specific models, like the 
Standard Model.
*/

/** \defgroup PDF PDF classes
These classes are used for particle density functions.
*/

/** \defgroup Shower Shower classes
These classes are used for the Showering.
*/

/** \defgroup DipoleShower DipoleShower classes
Classes implementing the coherent dipole shower algorithm.
*/

/** \defgroup Analysis Analysis classes
These classes are used to perform analysis of the events generated by Herwig++
*/

/** \defgroup UnderlyingEvent UnderlyingEvent classes
These classes are used for the underlying event.
*/

/** \defgroup Utilities Utilities classes
These classes provide general utilities.
*/

/** \defgroup Decay Decay classes
These classes perform the decays
*/
/** \defgroup PDT Particle Data class
Particle properties classses.
*/
