#define op(id, name, ...) case id: return instruction##name(__VA_ARGS__);
#define fp(name) &SPC700::algorithm##name

auto SPC700::instruction() -> void {
  switch(fetch()) {
  op(0x00, NOP)
  op(0x01, JST, 0)
  op(0x02, SET, 0)
  op(0x03, BBS, 0)
  op(0x04, DirectPageRead, fp(OR), A)
  op(0x05, AbsoluteRead, fp(OR), A)
  op(0x06, IndirectXRead, fp(OR))
  op(0x07, IndirectPageXRead, fp(OR))
  op(0x08, ImmediateRead, fp(OR), A)
  op(0x09, DirectPageWriteDirectPage, fp(OR))
  op(0x0a, AbsoluteModifyBit, 0)
  op(0x0b, DirectPageModify, fp(ASL))
  op(0x0c, AbsoluteModify, fp(ASL))
  op(0x0d, Push, P)
  op(0x0e, TSBAbsolute)
  op(0x0f, BRK)
  op(0x10, Branch, NF == 0)
  op(0x11, JST, 1)
  op(0x12, CLR, 0)
  op(0x13, BBC, 0)
  op(0x14, DirectPageIndexedRead, fp(OR), A, X)
  op(0x15, AbsoluteIndexedRead, fp(OR), X)
  op(0x16, AbsoluteIndexedRead, fp(OR), Y)
  op(0x17, IndirectPageYRead, fp(OR))
  op(0x18, DirectPageWriteImmediate, fp(OR))
  op(0x19, IndirectXWriteIndirectY, fp(OR))
  op(0x1a, DirectPageModifyWord, -1)
  op(0x1b, DirectPageXModify, fp(ASL))
  op(0x1c, ImpliedModify, fp(ASL), A)
  op(0x1d, ImpliedModify, fp(DEC), X)
  op(0x1e, AbsoluteRead, fp(CMP), X)
  op(0x1f, JMPIndirectAbsoluteX)
  op(0x20, FlagClear, PF)
  op(0x21, JST, 2)
  op(0x22, SET, 1)
  op(0x23, BBS, 1)
  op(0x24, DirectPageRead, fp(AND), A)
  op(0x25, AbsoluteRead, fp(AND), A)
  op(0x26, IndirectXRead, fp(AND))
  op(0x27, IndirectPageXRead, fp(AND))
  op(0x28, ImmediateRead, fp(AND), A)
  op(0x29, DirectPageWriteDirectPage, fp(AND))
  op(0x2a, AbsoluteModifyBit, 1)
  op(0x2b, DirectPageModify, fp(ROL))
  op(0x2c, AbsoluteModify, fp(ROL))
  op(0x2d, Push, A)
  op(0x2e, BNEDirectPage)
  op(0x2f, Branch, true)
  op(0x30, Branch, NF == 1)
  op(0x31, JST, 3)
  op(0x32, CLR, 1)
  op(0x33, BBC, 1)
  op(0x34, DirectPageIndexedRead, fp(AND), A, X)
  op(0x35, AbsoluteIndexedRead, fp(AND), X)
  op(0x36, AbsoluteIndexedRead, fp(AND), Y)
  op(0x37, IndirectPageYRead, fp(AND))
  op(0x38, DirectPageWriteImmediate, fp(AND))
  op(0x39, IndirectXWriteIndirectY, fp(AND))
  op(0x3a, DirectPageModifyWord, +1)
  op(0x3b, DirectPageXModify, fp(ROL))
  op(0x3c, ImpliedModify, fp(ROL), A)
  op(0x3d, ImpliedModify, fp(INC), X)
  op(0x3e, DirectPageRead, fp(CMP), X)
  op(0x3f, JSRAbsolute)
  op(0x40, FlagSet, PF)
  op(0x41, JST, 4)
  op(0x42, SET, 2)
  op(0x43, BBS, 2)
  op(0x44, DirectPageRead, fp(EOR), A)
  op(0x45, AbsoluteRead, fp(EOR), A)
  op(0x46, IndirectXRead, fp(EOR))
  op(0x47, IndirectPageXRead, fp(EOR))
  op(0x48, ImmediateRead, fp(EOR), A)
  op(0x49, DirectPageWriteDirectPage, fp(EOR))
  op(0x4a, AbsoluteModifyBit, 2)
  op(0x4b, DirectPageModify, fp(LSR))
  op(0x4c, AbsoluteModify, fp(LSR))
  op(0x4d, Push, X)
  op(0x4e, TRBAbsolute)
  op(0x4f, JSPDirectPage)
  op(0x50, Branch, VF == 0)
  op(0x51, JST, 5)
  op(0x52, CLR, 2)
  op(0x53, BBC, 2)
  op(0x54, DirectPageIndexedRead, fp(EOR), A, X)
  op(0x55, AbsoluteIndexedRead, fp(EOR), X)
  op(0x56, AbsoluteIndexedRead, fp(EOR), Y)
  op(0x57, IndirectPageYRead, fp(EOR))
  op(0x58, DirectPageWriteImmediate, fp(EOR))
  op(0x59, IndirectXWriteIndirectY, fp(EOR))
  op(0x5a, DirectPageReadWord, fp(CPW))
  op(0x5b, DirectPageXModify, fp(LSR))
  op(0x5c, ImpliedModify, fp(LSR), A)
  op(0x5d, Transfer, A, X)
  op(0x5e, AbsoluteRead, fp(CMP), Y)
  op(0x5f, JMPAbsolute)
  op(0x60, FlagClear, CF)
  op(0x61, JST, 6)
  op(0x62, SET, 3)
  op(0x63, BBS, 3)
  op(0x64, DirectPageRead, fp(CMP), A)
  op(0x65, AbsoluteRead, fp(CMP), A)
  op(0x66, IndirectXRead, fp(CMP))
  op(0x67, IndirectPageXRead, fp(CMP))
  op(0x68, ImmediateRead, fp(CMP), A)
  op(0x69, DirectPageWriteDirectPage, fp(CMP))
  op(0x6a, AbsoluteModifyBit, 3)
  op(0x6b, DirectPageModify, fp(ROR))
  op(0x6c, AbsoluteModify, fp(ROR))
  op(0x6d, Push, Y)
  op(0x6e, BNEDirectPageDecrement)
  op(0x6f, RTS)
  op(0x70, Branch, VF == 1)
  op(0x71, JST, 7)
  op(0x72, CLR, 3)
  op(0x73, BBC, 3)
  op(0x74, DirectPageIndexedRead, fp(CMP), A, X)
  op(0x75, AbsoluteIndexedRead, fp(CMP), X)
  op(0x76, AbsoluteIndexedRead, fp(CMP), Y)
  op(0x77, IndirectPageYRead, fp(CMP))
  op(0x78, DirectPageWriteImmediate, fp(CMP))
  op(0x79, IndirectXWriteIndirectY, fp(CMP))
  op(0x7a, DirectPageReadWord, fp(ADW))
  op(0x7b, DirectPageXModify, fp(ROR))
  op(0x7c, ImpliedModify, fp(ROR), A)
  op(0x7d, Transfer, X, A)
  op(0x7e, DirectPageRead, fp(CMP), Y)
  op(0x7f, RTI)
  op(0x80, FlagSet, CF)
  op(0x81, JST, 8)
  op(0x82, SET, 4)
  op(0x83, BBS, 4)
  op(0x84, DirectPageRead, fp(ADC), A)
  op(0x85, AbsoluteRead, fp(ADC), A)
  op(0x86, IndirectXRead, fp(ADC))
  op(0x87, IndirectPageXRead, fp(ADC))
  op(0x88, ImmediateRead, fp(ADC), A)
  op(0x89, DirectPageWriteDirectPage, fp(ADC))
  op(0x8a, AbsoluteModifyBit, 4)
  op(0x8b, DirectPageModify, fp(DEC))
  op(0x8c, AbsoluteModify, fp(DEC))
  op(0x8d, ImmediateRead, fp(LD), Y)
  op(0x8e, PLP)
  op(0x8f, DirectPageWriteImmediate, fp(ST))
  op(0x90, Branch, CF == 0)
  op(0x91, JST, 9)
  op(0x92, CLR, 4)
  op(0x93, BBC, 4)
  op(0x94, DirectPageIndexedRead, fp(ADC), A, X)
  op(0x95, AbsoluteIndexedRead, fp(ADC), X)
  op(0x96, AbsoluteIndexedRead, fp(ADC), Y)
  op(0x97, IndirectPageYRead, fp(ADC))
  op(0x98, DirectPageWriteImmediate, fp(ADC))
  op(0x99, IndirectXWriteIndirectY, fp(ADC))
  op(0x9a, DirectPageReadWord, fp(SBW))
  op(0x9b, DirectPageXModify, fp(DEC))
  op(0x9c, ImpliedModify, fp(DEC), A)
  op(0x9d, Transfer, S, X)
  op(0x9e, DIV)
  op(0x9f, XCN)
  op(0xa0, FlagSet, IF)
  op(0xa1, JST, 10)
  op(0xa2, SET, 5)
  op(0xa3, BBS, 5)
  op(0xa4, DirectPageRead, fp(SBC), A)
  op(0xa5, AbsoluteRead, fp(SBC), A)
  op(0xa6, IndirectXRead, fp(SBC))
  op(0xa7, IndirectPageXRead, fp(SBC))
  op(0xa8, ImmediateRead, fp(SBC), A)
  op(0xa9, DirectPageWriteDirectPage, fp(SBC))
  op(0xaa, AbsoluteModifyBit, 5)
  op(0xab, DirectPageModify, fp(INC))
  op(0xac, AbsoluteModify, fp(INC))
  op(0xad, ImmediateRead, fp(CMP), Y)
  op(0xae, Pull, A)
  op(0xaf, STAIndirectXIncrement)
  op(0xb0, Branch, CF == 1)
  op(0xb1, JST, 11)
  op(0xb2, CLR, 5)
  op(0xb3, BBC, 5)
  op(0xb4, DirectPageIndexedRead, fp(SBC), A, X)
  op(0xb5, AbsoluteIndexedRead, fp(SBC), X)
  op(0xb6, AbsoluteIndexedRead, fp(SBC), Y)
  op(0xb7, IndirectPageYRead, fp(SBC))
  op(0xb8, DirectPageWriteImmediate, fp(SBC))
  op(0xb9, IndirectXWriteIndirectY, fp(SBC))
  op(0xba, DirectPageReadWord, fp(LDW))
  op(0xbb, DirectPageXModify, fp(INC))
  op(0xbc, ImpliedModify, fp(INC), A)
  op(0xbd, Transfer, X, S)
  op(0xbe, DAS)
  op(0xbf, LDAIndirectXIncrement)
  op(0xc0, FlagClear, IF)
  op(0xc1, JST, 12)
  op(0xc2, SET, 6)
  op(0xc3, BBS, 6)
  op(0xc4, DirectPageWrite, A)
  op(0xc5, AbsoluteWrite, A)
  op(0xc6, STAIndirectX)
  op(0xc7, STAIndirectPageX)
  op(0xc8, ImmediateRead, fp(CMP), X)
  op(0xc9, AbsoluteWrite, X)
  op(0xca, AbsoluteModifyBit, 6)
  op(0xcb, DirectPageWrite, Y)
  op(0xcc, AbsoluteWrite, Y)
  op(0xcd, ImmediateRead, fp(LD), X)
  op(0xce, Pull, X)
  op(0xcf, MUL)
  op(0xd0, Branch, ZF == 0)
  op(0xd1, JST, 13)
  op(0xd2, CLR, 6)
  op(0xd3, BBC, 6)
  op(0xd4, DirectPageIndexedWrite, A, X)
  op(0xd5, AbsoluteIndexedWrite, X)
  op(0xd6, AbsoluteIndexedWrite, Y)
  op(0xd7, STAIndirectPageY)
  op(0xd8, DirectPageWrite, X)
  op(0xd9, DirectPageIndexedWrite, X, Y)
  op(0xda, STWDirectPage)
  op(0xdb, DirectPageIndexedWrite, Y, X)
  op(0xdc, ImpliedModify, fp(DEC), Y)
  op(0xdd, Transfer, Y, A)
  op(0xde, BNEDirectPageX)
  op(0xdf, DAA)
  op(0xe0, CLV)
  op(0xe1, JST, 14)
  op(0xe2, SET, 7)
  op(0xe3, BBS, 7)
  op(0xe4, DirectPageRead, fp(LD), A)
  op(0xe5, AbsoluteRead, fp(LD), A)
  op(0xe6, IndirectXRead, fp(LD))
  op(0xe7, IndirectPageXRead, fp(LD))
  op(0xe8, ImmediateRead, fp(LD), A)
  op(0xe9, AbsoluteRead, fp(LD), X)
  op(0xea, AbsoluteModifyBit, 7)
  op(0xeb, DirectPageRead, fp(LD), Y)
  op(0xec, AbsoluteRead, fp(LD), Y)
  op(0xed, CMC)
  op(0xee, Pull, Y)
  op(0xef, WAI)
  op(0xf0, Branch, ZF == 1)
  op(0xf1, JST, 15)
  op(0xf2, CLR, 7)
  op(0xf3, BBC, 7)
  op(0xf4, DirectPageIndexedRead, fp(LD), A, X)
  op(0xf5, AbsoluteIndexedRead, fp(LD), X)
  op(0xf6, AbsoluteIndexedRead, fp(LD), Y)
  op(0xf7, IndirectPageYRead, fp(LD))
  op(0xf8, DirectPageRead, fp(LD), X)
  op(0xf9, DirectPageIndexedRead, fp(LD), X, Y)
  op(0xfa, DirectPageWriteDirectPage, fp(ST))
  op(0xfb, DirectPageIndexedRead, fp(LD), Y, X)
  op(0xfc, ImpliedModify, fp(INC), Y)
  op(0xfd, Transfer, A, Y)
  op(0xfe, BNEYDecrement)
  op(0xff, STP)
  }
}

#undef op
#undef fp
