%define prefix  /usr

Summary: A universal source code to formatted text converter.
Name: highlight
Version: 2.0
Release: 22 
Group: Development/Tools 
License: GPL
Vendor: Andre Simon <andre.simon1@gmx.de>

Source0:	%{name}-%{version}-%{release}.tar.gz
Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root
Prefix:		%{prefix}

%description
A utility that converts sourcecode to (X)HTML, RTF, LaTeX, TeX or XSL-FO with syntax highlighting (HTML formatted by Cascading Style Sheets). 
The output may be reformatted in five different styles.
It supports several programming or markup languages like 
ADA 95, Agda, AMPL, Aspect, Assembler, Amtrix, Avenue, (G)AWK, Bash, BlitzBasic, BibTex, 
BMS, C, C++, C Sharp, ClearBasic, Clipper, Cobol, CSS, DOS-Batch, Eiffel, Erlang, Euphoria,
Express, Felix, Fortran, Frink, Haskell, HTML, httpd.conf, Icon, IDL, INI, IO, Jasmin,
Java, JavaScript, JSP, LaTeX, LDIF, Lisp, Lotos, Lotus Script, Lua, Make, Maya, Matlab, Maple, Modelica,
Modula, Nasal, OCaml, (Object) Pascal, Objective C, Paradox, PATROL, Perl, PHP, Pike, PL/1,
PL/SQL, PostScript, POV Ray, Progress, Prolog, Python, Relax NG Compact, Rexx, RPM Spec,  Ruby, Small, SML, Spin,
Squirrel, SuperX++, Sybase, VHDL, Visual Basic, XML.

It is easy to create new language definitions and colour themes.

%prep
%setup -q -n highlight-%{version}-%{release}  

%build
#CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
make

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
mkdir -p $RPM_BUILD_ROOT%{prefix}
make prefix=$RPM_BUILD_ROOT%{prefix} install-strip
install -d $RPM_BUILD_ROOT%{prefix}/share/highlight/themes $RPM_BUILD_ROOT%{prefix}/share/highlight/langDefs $RPM_BUILD_ROOT%{prefix}/share/highlight/helpmsg $RPM_BUILD_ROOT%{prefix}/share/highlight/utils/cgi/php $RPM_BUILD_ROOT%{prefix}/share/highlight/utils/cgi/perl 

mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p  $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/

install -m644 ./man/highlight.1.gz $RPM_BUILD_ROOT%{_mandir}/man1/
install -m644 ./langDefs/*.lang  $RPM_BUILD_ROOT%{prefix}/share/highlight/langDefs/
install -m644 ./langDefs/extensions.conf $RPM_BUILD_ROOT%{prefix}/share/highlight/
install -m644 ./themes/*.style $RPM_BUILD_ROOT%{prefix}/share/highlight/themes/
install -m644 ./helpmsg/*.help $RPM_BUILD_ROOT%{prefix}/share/highlight/helpmsg/
install -m644 ./utils/cgi/php/* $RPM_BUILD_ROOT%{prefix}/share/highlight/utils/cgi/php
install -m644 ./utils/cgi/perl/* $RPM_BUILD_ROOT%{prefix}/share/highlight/utils/cgi/perl
#install -m644 ./utils/frontend/* $RPM_BUILD_ROOT%{prefix}/share/highlight/utils/frontend
install -m644 ./ChangeLog ./AUTHORS ./COPYING ./TODO ./README ./README_DE ./INSTALL  $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/
mkdir -p $RPM_BUILD_ROOT%{prefix}/local/bin/
install -m755 ./highlight/highlight  $RPM_BUILD_ROOT%{prefix}/local/bin/

%clean
#make clean

%postun
rmdir %{prefix}/share/highlight/themes %{prefix}/share/highlight/langDefs %{prefix}/share/highlight/helpmsg
rmdir %{prefix}/share/highlight/utils/cgi/perl %{prefix}/share/highlight/utils/cgi/php %{prefix}/share/highlight/utils/cgi %{prefix}/share/highlight/utils/
rmdir %{prefix}/share/highlight

%files
%defattr(-,root,root)
#%doc ../ChangeLog ../AUTHORS ../COPYING ../TODO ../README ../INSTALL
%{prefix}/share/highlight/langDefs/pas.lang
%{prefix}/share/highlight/langDefs/c.lang
%{prefix}/share/highlight/langDefs/php.lang
%{prefix}/share/highlight/langDefs/asm.lang
%{prefix}/share/highlight/langDefs/sql.lang
%{prefix}/share/highlight/langDefs/js.lang
%{prefix}/share/highlight/langDefs/java.lang
%{prefix}/share/highlight/langDefs/py.lang
%{prefix}/share/highlight/langDefs/sh.lang
%{prefix}/share/highlight/langDefs/pl.lang
%{prefix}/share/highlight/langDefs/vb.lang
%{prefix}/share/highlight/langDefs/lua.lang
%{prefix}/share/highlight/langDefs/ada.lang
%{prefix}/share/highlight/langDefs/rb.lang
%{prefix}/share/highlight/langDefs/cob.lang
%{prefix}/share/highlight/langDefs/cs.lang
%{prefix}/share/highlight/langDefs/f77.lang
%{prefix}/share/highlight/langDefs/f90.lang
%{prefix}/share/highlight/langDefs/tcl.lang
%{prefix}/share/highlight/langDefs/pov.lang
%{prefix}/share/highlight/langDefs/haskell.lang
%{prefix}/share/highlight/langDefs/agda.lang
%{prefix}/share/highlight/langDefs/e.lang
%{prefix}/share/highlight/langDefs/rexx.lang
%{prefix}/share/highlight/langDefs/mod3.lang
%{prefix}/share/highlight/langDefs/awk.lang
%{prefix}/share/highlight/langDefs/euphoria.lang
%{prefix}/share/highlight/langDefs/bms.lang
%{prefix}/share/highlight/langDefs/psl.lang
%{prefix}/share/highlight/langDefs/idl.lang
%{prefix}/share/highlight/langDefs/amtrix.lang
%{prefix}/share/highlight/langDefs/bat.lang
%{prefix}/share/highlight/langDefs/make.lang
%{prefix}/share/highlight/langDefs/progress.lang
%{prefix}/share/highlight/langDefs/pl1.lang
%{prefix}/share/highlight/langDefs/sc.lang
%{prefix}/share/highlight/langDefs/mo.lang
%{prefix}/share/highlight/langDefs/mel.lang
%{prefix}/share/highlight/langDefs/m.lang
%{prefix}/share/highlight/langDefs/j.lang
%{prefix}/share/highlight/langDefs/exp.lang
%{prefix}/share/highlight/langDefs/css.lang
%{prefix}/share/highlight/langDefs/clp.lang
%{prefix}/share/highlight/langDefs/clipper.lang
%{prefix}/share/highlight/langDefs/cb.lang
%{prefix}/share/highlight/langDefs/bb.lang
%{prefix}/share/highlight/langDefs/avenue.lang
%{prefix}/share/highlight/langDefs/aspect.lang
%{prefix}/share/highlight/langDefs/tex.lang
%{prefix}/share/highlight/langDefs/xml.lang
%{prefix}/share/highlight/langDefs/pike.lang
%{prefix}/share/highlight/langDefs/4th.lang
%{prefix}/share/highlight/langDefs/sybase.lang
%{prefix}/share/highlight/langDefs/ampl.lang
%{prefix}/share/highlight/langDefs/httpd.lang
%{prefix}/share/highlight/langDefs/ini.lang
%{prefix}/share/highlight/langDefs/ldif.lang
%{prefix}/share/highlight/langDefs/ls.lang
%{prefix}/share/highlight/langDefs/sma.lang
%{prefix}/share/highlight/langDefs/spn.lang
%{prefix}/share/highlight/langDefs/txt.lang
%{prefix}/share/highlight/langDefs/vhd.lang
%{prefix}/share/highlight/langDefs/nut.lang
%{prefix}/share/highlight/langDefs/jsp.lang
%{prefix}/share/highlight/langDefs/nice.lang
%{prefix}/share/highlight/langDefs/rnc.lang
%{prefix}/share/highlight/langDefs/xpp.lang
%{prefix}/share/highlight/langDefs/nas.lang
%{prefix}/share/highlight/langDefs/sml.lang
%{prefix}/share/highlight/langDefs/ml.lang
%{prefix}/share/highlight/langDefs/flx.lang
%{prefix}/share/highlight/langDefs/frink.lang
%{prefix}/share/highlight/langDefs/io.lang
%{prefix}/share/highlight/langDefs/oberon.lang
%{prefix}/share/highlight/langDefs/as.lang
%{prefix}/share/highlight/langDefs/asp.lang
%{prefix}/share/highlight/langDefs/ms.lang
%{prefix}/share/highlight/langDefs/os.lang
%{prefix}/share/highlight/langDefs/bib.lang
%{prefix}/share/highlight/langDefs/erl.lang
%{prefix}/share/highlight/langDefs/icn.lang
%{prefix}/share/highlight/langDefs/lisp.lang
%{prefix}/share/highlight/langDefs/lotos.lang
%{prefix}/share/highlight/langDefs/mpl.lang
%{prefix}/share/highlight/langDefs/objc.lang
%{prefix}/share/highlight/langDefs/pro.lang
%{prefix}/share/highlight/langDefs/ps.lang
%{prefix}/share/highlight/langDefs/spec.lang
%{prefix}/share/highlight/langDefs/4gl.lang
%{prefix}/share/highlight/langDefs/abp.lang
%{prefix}/share/highlight/langDefs/dylan.lang
%{prefix}/share/highlight/langDefs/octave.lang
%{prefix}/share/highlight/langDefs/r.lang
%{prefix}/share/highlight/langDefs/scala.lang
%{prefix}/share/highlight/langDefs/snobol.lang
%{prefix}/share/highlight/langDefs/verilog.lang
%{prefix}/share/highlight/langDefs/y.lang
%{prefix}/share/highlight/langDefs/arm.lang
%{prefix}/share/highlight/langDefs/inp.lang

%{prefix}/share/highlight/extensions.conf

%{prefix}/share/doc/highlight/ChangeLog
%{prefix}/share/doc/highlight/AUTHORS
%{prefix}/share/doc/highlight/README
%{prefix}/share/doc/highlight/README_DE
%{prefix}/share/doc/highlight/COPYING
%{prefix}/share/doc/highlight/TODO
%{prefix}/share/doc/highlight/INSTALL

%{prefix}/share/highlight/themes/aqua.style
%{prefix}/share/highlight/themes/berries-dark.style
%{prefix}/share/highlight/themes/berries-light.style
%{prefix}/share/highlight/themes/bipolar.style
%{prefix}/share/highlight/themes/blacknblue.style
%{prefix}/share/highlight/themes/blue.style
%{prefix}/share/highlight/themes/bright.style
%{prefix}/share/highlight/themes/bright2.style
%{prefix}/share/highlight/themes/bruised.style
%{prefix}/share/highlight/themes/bubblegum.style
%{prefix}/share/highlight/themes/contrast.style
%{prefix}/share/highlight/themes/darkness.style
%{prefix}/share/highlight/themes/desert.style
%{prefix}/share/highlight/themes/dream.style
%{prefix}/share/highlight/themes/dull.style
%{prefix}/share/highlight/themes/easter.style
%{prefix}/share/highlight/themes/fluke.style
%{prefix}/share/highlight/themes/golden.style
%{prefix}/share/highlight/themes/greenlcd.style
%{prefix}/share/highlight/themes/greyish.style
%{prefix}/share/highlight/themes/ide-anjuta.style
%{prefix}/share/highlight/themes/ide-devcpp.style
%{prefix}/share/highlight/themes/ide-jbuilder4.style
%{prefix}/share/highlight/themes/ide-jcreator2.style
%{prefix}/share/highlight/themes/ide-kdev.style
%{prefix}/share/highlight/themes/ide-msvcpp.style
%{prefix}/share/highlight/themes/ide-synedit.style
%{prefix}/share/highlight/themes/imperial.style
%{prefix}/share/highlight/themes/navy.style
%{prefix}/share/highlight/themes/neon.style
%{prefix}/share/highlight/themes/neon2.style
%{prefix}/share/highlight/themes/night.style
%{prefix}/share/highlight/themes/nightvision.style
%{prefix}/share/highlight/themes/peachy.style
%{prefix}/share/highlight/themes/rand01.style
%{prefix}/share/highlight/themes/rand02.style
%{prefix}/share/highlight/themes/slime.style
%{prefix}/share/highlight/themes/smoke.style
%{prefix}/share/highlight/themes/typical.style
%{prefix}/share/highlight/themes/untitled.style
%{prefix}/share/highlight/themes/untypical.style
%{prefix}/share/highlight/themes/usable.style
%{prefix}/share/highlight/themes/vampire.style
%{prefix}/share/highlight/themes/website.style
%{prefix}/share/highlight/themes/website2-blue.style
%{prefix}/share/highlight/themes/website2.style
%{prefix}/share/highlight/themes/website3-blue.style
%{prefix}/share/highlight/themes/website3.style
%{prefix}/share/highlight/themes/whatis.style
%{prefix}/share/highlight/themes/whitenblue.style
%{prefix}/share/highlight/themes/whitengrey.style
%{prefix}/share/highlight/themes/emacs.style
%{prefix}/share/highlight/themes/kwrite.style
%{prefix}/share/highlight/themes/matlab.style
%{prefix}/share/highlight/themes/print.style
%{prefix}/share/highlight/themes/the.style
%{prefix}/share/highlight/themes/vim.style
%{prefix}/share/highlight/themes/vim-dark.style
%{prefix}/share/highlight/themes/ide-codewarrior.style
%{prefix}/share/highlight/themes/darkblue.style
%{prefix}/share/highlight/themes/zellner.style
%{prefix}/share/highlight/themes/ron.style
%{prefix}/share/highlight/themes/peachpuff.style
%{prefix}/share/highlight/themes/pablo.style
%{prefix}/share/highlight/themes/nedit.style

%{prefix}/share/man/man1/highlight.1.gz

%{prefix}/share/highlight/helpmsg/de.help
%{prefix}/share/highlight/helpmsg/en.help
%{prefix}/share/highlight/helpmsg/fr.help

%{prefix}/share/highlight/utils/cgi/perl/highlight.cgi
%{prefix}/share/highlight/utils/cgi/perl/README_CGI
%{prefix}/share/highlight/utils/cgi/php/CodeHighLight.php
%{prefix}/share/highlight/utils/cgi/php/SyntaxHighlighter.php
#%{prefix}/share/highlight/utils/frontend/highlight-pyqt-GUI-0.1-5.tar.gz

#%{_mandir}/man1/highlight.1.gz
%{prefix}/local/bin/highlight

%changelog
* Tue Feb 26 2002 Andre Simon <andre.simon1@gmx.de>
- Initial build

