/***************************************************************************
                          cmdlineoptions.h  -  description
                             -------------------
    begin                : Sun Nov 25 2001
    copyright            : (C) 2001 by André �Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMDLINEOPTIONS_H
#define CMDLINEOPTIONS_H

#include <string>
#include <map>
#include <cstdlib>
#include <iostream>
#include <fstream>

#include "stringtools.h"
#include "configurationreader.h"
#include "datadir.h"

#include "directoryreader.h"
#include "enums.h"

// If your system does not know getopt_long, define USE_PORTABLE_CMDLINE_PARSER
#if defined(_WIN32) || defined(__SVR4) || defined(__sun__) 
  #define USE_PORTABLE_CMDLINE_PARSER
#endif  

#ifndef USE_PORTABLE_CMDLINE_PARSER
#include <getopt.h>
#else
#include "win32cmdline.h"
#endif


#define OPT_VERBOSE  "verbose"
#define OPT_INCLUDECSS  "includecss"
#define OPT_HELP  "help"
#define OPT_LINENO  "linenumbers"
#define OPT_XHTML  "xhtml"
#define OPT_RTF  "rtf"      
#define OPT_TEX  "tex"      
#define OPT_LATEX  "latex"      
#define OPT_XSLFO  "xsl-fo"
#define OPT_FRAGMENT  "fragment" 
#define OPT_ANCHORS  "anchors"      
#define OPT_LISTTHEMES  "listthemes"
#define OPT_LISTLANGS  "listlangs"      
#define OPT_VERSION  "version"      
#define OPT_IN  "input"
#define OPT_OUT  "output"
#define OPT_SYNTAX  "syntax"
#define OPT_STYLE "style"
#define OPT_CSSOUT  "css-outfile"
#define OPT_CSSIN  "css-infile"
#define OPT_DELTABS  "deletetabs"
#define OPT_BATCH  "batch"
#define OPT_BATCHREC  "batch-recursive"
#define OPT_OUTDIR  "outdir"
#define OPT_FORMATSTYLE  "format-style"
#define OPT_DATADIR  "data-dir"
#define OPT_ADDDATADIR  "add-data-dir"
#define OPT_INDEXFILE  "printindex"
#define OPT_HELPINT  "help-int"
#define OPT_WRAP  "wrap"
#define OPT_WRAPSIMPLE  "wrap-simple"
#define OPT_QUIET  "quiet"
#define OPT_REPLACE_QUOTES  "replace-quotes"
#define OPT_FOP "fop-compatible"
#define OPT_PROGRESSBAR "progress"


#define S_OPT_OUT 'o'
#define S_OPT_IN 'i'
#define S_OPT_SYNTAX 'S'
#define S_OPT_VERBOSE 'v'
#define S_OPT_INCLUDECSS 'I'
#define S_OPT_HELP 'h'
#define S_OPT_HELPINT  'H'
#define S_OPT_LINENO 'l'
#define S_OPT_STYLE 's'
#define S_OPT_CSSOUT 'c'
#define S_OPT_CSSIN 'e'
#define S_OPT_DELTABS 't'
#define S_OPT_XHTML 'X'
#define S_OPT_RTF 'R'
#define S_OPT_TEX 'T'
#define S_OPT_LATEX 'L'
#define S_OPT_XSLFO 'Y'
#define S_OPT_BATCH 'b'
#define S_OPT_BATCHREC 'B'     
#define S_OPT_FRAGMENT 'f'
#define S_OPT_ANCHORS 'a' 
#define S_OPT_LISTTHEMES 'w' 
#define S_OPT_LISTLANGS 'p' 
#define S_OPT_OUTDIR 'O'

#define S_OPT_FORMATSTYLE 'F'
#define S_OPT_DATADIR 'D'
#define S_OPT_ADDDATADIR 'E'
#define S_OPT_INDEXFILE 'C'
#define S_OPT_WRAP 'W'
#define S_OPT_WRAPSIMPLE 'V'
#define S_OPT_QUIET 'q'
#define S_OPT_FOP 'A'
#define S_OPT_REPLACE_QUOTES 'r'
#define S_OPT_VERSION 'Q'
#define S_OPT_PROGRESSBAR 'P'

using namespace std;

/**Command line options*/
 
class CmdLineOptions
  {
  public:

    /**Constructor 
     \param argc Argument count
     \param argv Argument strings
    */
    CmdLineOptions(int argc, char *argv[]);
    ~CmdLineOptions();
    
    /** \return Single output file name*/
    const string &getSingleOutFilename();

    /** \return Single input file name*/
    const string getSingleInFilename() const;

    /** \return Output directory*/
    const string& getOutDirectory() const;
    
    /** \return CSS output file name*/
    const string&getCssOutFilename() const;

    /** \return CSS input file name*/
    const string&getCssInFilename() const;
    
    /** \return Number of spaces to replace a tab*/
    int getNumberSpaces() const;

    /** \return True if version information should be printed*/
    bool printVersion() const;

   /** \return True if help information should be printed*/
    bool printHelp() const;

    /** \return True if debug information should be printed*/
    bool printDebugInfo()const;

    /** \return True if CSS should be included in output*/
    bool includeCssDefinition() const;

    /** \return True if line numbers should be printed*/
    bool printLineNumbers() const;

        /** \return colur theme name */
    string getStyleName()const ;

    /** \return True if output format is XHTML*/
    bool xhtmlFormat() const;

    /** \return True if output format is RTF*/
    bool rtfFormat() const;

    /** \return True if output format is TEX*/
    bool texFormat() const;

    /** \return True if output format is LATEX*/
    bool latexFormat() const;     

    /** \return True if output format is HTML*/
    bool htmlFormat() const;

    /** \return True if output format is XSL-FO*/
    bool xslfoFormat() const;

    /** gibt true zurck, falls deutsche Hilfe ausgegeben werden soll */
    int helpLanguage() const;
    
    /** \return True if batch mode is active*/
    bool enableBatchMode() const;

    /** \return True if output shluld be fragmented*/
    bool fragmentOutput() const;

    /** \return output file suffix */
    string getOutFileSuffix() const;

    /** \return True if anchors should be attached to line numbers*/
    bool attachLineAnchors() const;

    /** \return True if list of installed themes should be printed*/
    bool showThemes() const;
    /** \return True if list of installed language definitions should be printed*/
    bool showLangdefs() const;

    /** \return True if loutput directory is given*/
    bool outDirGiven() const;

    /** \return True if refomatting is enabled*/
    bool formattingEnabled();

    /** \return True if a new data directory is given*/
    bool dataDirGiven()const;
   
   /** \return True if an additional data directory is given*/
   bool additionalDataDirGiven()const;

    /** \return True if index file should be printed*/
    bool printIndexFile() const;

    /** \return True if quotes should be replaced by /dq in LaTeX*/
    bool replaceQuotes() const;
      
      /** \return Data directory*/
  string  getDataDir()const;

      /** \return Additional data directory*/
  string  getAdditionalDataDir()const;

    /** \return True if file search is recursive*/
  bool batchRecursive() const;
  
    /** \return True if language syntax is given*/
  bool syntaxGiven() const;

    /** \return True if quiet mode is active*/
  bool quietMode() const;

    /** \return True if XSL-FO output should be FOP compatible*/
  bool fopCompatible() const;
  
  /** \return True if progress bar should be printed in batch mode */
  bool printProgress() const;
  
    /** \return Formatstyle*/
  highlight::FormatStyle getFormatStyle();

  const string  getHelpLang() const;

  string getLanguage() ;
  
  /** \return Wrapping style*/
  highlight::WrapMode getWrappingStyle() const;
 
  /** \return List of input file names*/
  const vector <string> & getInputFileNames() const;

  private:

    int numberSpaces;   //anzahl Spaces, die einen Tabulator ersetzen sollen
    highlight::WrapMode wrappingStyle;
    
    highlight::FormatStyle formatStyle;

    //Name der Ausgabedatei (falls kein Batch-Modus aktiviert ist)
    string outFilename, 
    outDirectory,   //Zielverzeichnis fuer Ausgabedateien
    language,       //Programmiersprache, die geparst wird
    styleName,      //Stil der formatierung (zB kwrite oder emacs)
    cssOutFilename, //Name der CSS-Ausgabedatei
    cssInFilename,  //Name der CSS-Eingabedatei
    dataDir, additionalDataDir;  //Datenverzeichnis

    //Flags zur Bestimmung der gesetzten Parameter:
    
    bool opt_language;
    bool opt_include_css;
    bool opt_help;
    bool opt_version ;
    bool opt_verbose;
    bool opt_linenumbers;
    bool opt_css_style;    
    bool opt_xhtml_output;
    bool opt_batch_mode;
    bool opt_batch_recursive;
    bool opt_rtf_output;
    bool opt_tex_output;
    bool opt_latex_output;
    bool opt_xslfo_output;
    bool opt_fragment;
    bool opt_attach_line_anchors;
    bool opt_show_themes;
    bool opt_show_langdefs;    
    bool opt_asformat_output;
    bool opt_printindex,
         opt_quiet,
         opt_xslfo_fop,
         opt_replacequotes,
         opt_print_progress;
         
    bool configFileRead;     

    string helpLang;   
    
    #ifdef _WIN32
    string appPath;
    #endif
      
    vector <string> inputFileNames;

    /** l�t Voreinstellungen aus Configdatei .highlight.conf im HOME Verzeichnis
        Kommandozeilenparameter berschreiben diese, falls angegeben */
    void loadConfigurationFile();        

    /** gibt Dateiendung zurck, wenn kein "." gefunden wird, wird
        "" zurckgegeben */    
    string getFileSuffix( const string & fileName) const;
        
    void setFormatStyle(const char * );
    
    void readDirectory(const string & wildcard, bool recursive);

    bool getFlag(const string& paramVal);

    string validateDirPath(const string & path);

  };

#endif
