/***************************************************************************
                          directoryreader.cpp  -  description
                             -------------------
    begin                : Son Nov 10 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirstream.h"
#include "directoryreader.h"


DirectoryReader::DirectoryReader()
{}
DirectoryReader::~DirectoryReader()
{}

// kopiert alle Dateinamen im aktuellen Verzeichnis, die mit dem wildcard
// enden, in fileList.
// gibt true zurck, falls Verzeichnis ausgelesen werden konnte

bool DirectoryReader::getEntries(vector<string> &fileList,
                                 string wildcard,
                                 bool recursiveSearch)
{
  if (!wildcard.empty())
    {      
     string Dir;
     string::size_type Pos = wildcard.find_last_of(DIRSTREAM::DIR_DELIMITER);
     if (Pos == string::npos)
       {
         Dir = ".";
       }
      else
       {
         Dir = wildcard.substr(0, Pos + 1);
         wildcard = wildcard.substr(Pos + 1);
        }

      DIRSTREAM::FileSelector Sel(wildcard.c_str());
      DIRSTREAM::DirStream_t<DIRSTREAM::FileSelector>
      Stream(Dir.c_str(),recursiveSearch, Sel);
      string infile, outfile;
      while (Stream >> infile)
       {
         string::size_type Pos2 = infile.find_last_of(DIRSTREAM::DIR_DELIMITER);
   	 outfile = (Pos2 != string::npos)?
                    infile.substr(Pos2 + 1, infile.length()-Pos2): infile;
         if (outfile=="." || outfile =="..")
          {
            continue;
          }   	    
         if (Dir != "."){
           infile.insert(0, Dir);
          }
         fileList.push_back(infile);
         }         
   }
  return !(fileList.empty());
}



