/***************************************************************************
                          documentstyle.h  -  description
                             -------------------
    begin                : Son Nov 10 2002
    copyright            : (C) 2002 by André Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOCUMENTSTYLE_H
#define DOCUMENTSTYLE_H

#include <string>
#include <iostream>
#include "configurationreader.h"
#include "elementstyle.h"
#include "stylecolour.h"

using namespace std;

namespace highlight {

/** Contains information about document formatting properties
  * @author Andre Simon
  */

class DocumentStyle
  {
  private:
    ElementStyle comment, keyword, str, dstr,
                 escapeChar, number, directive, type, line, symbol;
    ElementStyle defaultElem;    
    StyleColour  bgColour;
    
    string fontsize;
    bool fileFound;

  public:
    /** Constructor
        \param styleDefinitionPath Style definition path */
    DocumentStyle(const string & styleDefinitionPath);
    DocumentStyle();
    ~DocumentStyle();
    
  /** load sytle definition
        \param styleDefinitionFile Style definition path 
        \return True if successfull */
    bool load(const string & styleDefinitionFile); 
    
    /** \return Font size */   
    string &getFontSize() ;

    /** \return Background colour*/   
    StyleColour& getBgColour();

    /** \return Style of default (unrecognized) strings */   
    ElementStyle & getDefaultStyle() ;

    /** \return Comment style*/   
    ElementStyle & getCommentStyle() ;

    /** \return Keyword style*/   
    ElementStyle & getKeywordStyle() ;

    /** \return String style*/   
    ElementStyle & getStringStyle() ;

    /** \return Directive line string style*/   
    ElementStyle & getDirectiveStringStyle() ;

    /** \return Escape character style*/   
    ElementStyle & getEscapeCharStyle() ;

    /** \return Number style*/   
    ElementStyle & getNumberStyle() ;

    /** \return Directive style*/   
    ElementStyle & getDirectiveStyle() ;

    /** \return Type style*/   
    ElementStyle & getTypeStyle() ;

    /** \return Line number style*/   
    ElementStyle & getLineStyle() ;

    /** \return Bracket style*/   
    ElementStyle & getSymbolStyle() ;

    /** \return True if language definition was found */   
    bool found() const ;
  };

}

#endif
