//
// C++ Interface: enums
//
// Description: 
//
//
// Author: Andre Simon <andre.simon1@gmx.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef ENUMS_H
#define ENUMS_H

namespace highlight {

enum State {
  STANDARD=0,
  KEYWORD,
  TYPE,
  STRING,
  NUMBER,
  SINGLE_LINE_COMMENT,
  MULTI_LINE_COMMENT_BEGIN,
  ESC_CHAR,
  DIRECTIVE_LINE,
  DIRECTIVE_STRING,
  LINENUMBER,
  SYMBOL, 

  // Konstanten ab hier duefen nicht mehr als Array-Indizes benutzt werden!!
  MULTI_LINE_COMMENT_END,
  STRING_END,
  DIRECTIVE_LINE_END,
  TAG_BEGIN,
  TAG_END,
  MEMBER_ATTRIBUTE_BEGIN,
  MEMBER_ATTRIBUTE_END,
  KEYWORD_BEGIN,
  KEYWORD_END,
  TYPE_BEGIN,
  TYPE_END,

  _UNKNOWN=100,
  _EOL,
  _EOF,
  _WS
} ;

enum ParseError{
   PARSE_OK,
   BAD_INPUT,
   BAD_OUTPUT,
   BAD_STYLE
};

enum FormatStyle {
  FORMAT_DISABLED = 0,
  FORMAT_ANSI,
  FORMAT_GNU,
  FORMAT_JAVA,
  FORMAT_KR,
  FORMAT_LINUX 
};

enum WrapMode {
  WRAP_DISABLED,
  WRAP_SIMPLE,
  WRAP_DEFAULT
};

enum LoadResult{    
  LOAD_FAILED,
  LOAD_NEW,
  LOAD_NONE
};


}

#endif
