//
// C++ Interface: main
//
// Description: 
//
//
// Author: Andre Simon <andre.simon1@gmx.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef HIGHLIGHT_APP
#define  HIGHLIGHT_APP

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include <iomanip>

#include "cmdlineoptions.h"
#include "configurationreader.h"
#include "htmlcode.h"
#include "rtfcode.h"
#include "latexcode.h"
#include "texcode.h"
#include "xslfocode.h"
#include "help.h"
#include "datadir.h"
#include "codeparser.h"
#include "directoryreader.h"
#include "version.h"

typedef map<string, string> ExtensionsMap;

class HighlightApp {

public:
   HighlightApp(){};
   ~HighlightApp(){};

   int run(int argc, char **argv);

private:

  DataDir dataDir;
  ExtensionsMap extensions;

  //Gibt Versionsinformationen nach cout aus
  void printVersionInfo();

  void printBadInstallationInfo();

  bool listInstalledFiles(bool themes);

  void printParseError(highlight::ParseError err,const string & inFile, 
                     const string & outFile);
 
  void printDebugInfo(highlight::LanguageDefinition &lang, 
                      const string & language);

  string getFileSuffix(const string &fileName) ;

  /** l�t Liste der bekannten Dateiendungen */
  bool loadFileExtensions();

  
  /** gibt bei mehreren gebraeuchlichen Dateiendungen den passenden Namen der
  Sprachdefinitionsdatei zurueck */
  string getFileType(const string &suffix);

  bool initializeParser(highlight::CodeParser* parser,
                  CmdLineOptions &options, const string & suffix);
                  
  int getNumDigits(int i);
  
  void printProgressBar(int count, int index);
  void printCurrentAction(const string&outfilePath, 
                          int count, int index, int countWidth);

};

#endif
