/***************************************************************************
                          rtfcode.h  -  description
                             -------------------
    begin                : Die Jul 9 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RTFCODE_H
#define RTFCODE_H

#include <iostream>
#include <fstream>
#include <string>
#include <sstream>

#include "codeparser.h"
#include "charcodes.h"
#include "version.h"

namespace highlight {

/**Class for outputting RTF
  *@author Andre Simon
  */

class RtfCode : public highlight::CodeParser
  {
  public:
  
   /** Constructor     
     \param langDef LanguageDefinition which contains parsing information    
     \param colourTheme Name of Colour theme to use 
     \param printLineNumbers Test if line numbers should be printed
     \param fragment Test if header and footer of document should be omitted          
     \param numSpaces Number of spaces which replace a tab
     \param wrapStyle Line wrapping mode (0=none, 1=simple, 2=normal)
    */
    RtfCode( const string &colourTheme,
             bool printLineNumbers=false, bool fragment=false, int numSpaces=0,  
             highlight::WrapMode wrapStyle=highlight::WRAP_DISABLED);
    RtfCode();
    ~RtfCode();

   /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string & title);

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();

  private:
    string styleDefinition;
    /** Gibt RTF-Code der Sonderzeichen zurueck */
    virtual string maskCharacter(unsigned char );
    string  formatStyleAttributes( const ElementStyle & col);

    /** gibt RTF-"Tags" zurueck (Farbindex+bold+kursiv)*/
    string getOpenTag(int styleNumber,const ElementStyle &);
    string getCloseTag(const ElementStyle &);
  };

}
#endif
