/***************************************************************************
                          stringtools.h  -  description
                             -------------------
    begin                : Mon Dec 10 2001
    copyright            : (C) 2001 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STRINGTOOLS_H
#define STRINGTOOLS_H

#include <string>
#include <sstream>
#include <iostream>
#include <cctype>

#ifdef _WIN32
  #define PATH_SEPARATOR_CHAR '\\'
  #define PATH_SEPARATOR_STR "\\"
#else
  #define PATH_SEPARATOR_CHAR '/'
  #define PATH_SEPARATOR_STR "/"
#endif

using namespace std;

/**Methoden zur Stringbearbeitung
  *@author Andre Simon
  */

namespace StringTools
  {

  /** \param s String
      \returns lowercase string  */
  string lowerCase(const string &s);

  /** \param String
      \returns Integer value */
  int str2int(string s);
  
  /** gibt True zurueck, falls c ein Buchstabe ist */
  bool isAlpha(unsigned char c);
  
  /* entfernt whitespace von stringende*/
  string trimRight(const string &);

  /** gibt naechsten Character der Zeile zurck, der kein Whitespace ist*/
  unsigned char getNextNonWs(const string &line, int index=0);

//  unsigned int getNextNonWsPos(const string &line, int index=0);
  
}

#endif


