/***************************************************************************
                          stylecolour.h  -  description
                             -------------------
    begin                : Die Nov 5 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STYLECOLOUR_H
#define STYLECOLOUR_H

#include <string>
#include <sstream>
#include <fstream>
#include <cmath>
#include <sstream>

using namespace std;

namespace highlight {

/**Saves colours and returns red, green and blue values in different formats
  *@author Andre Simon
  */

class StyleColour
  {
  public:
    /** Constructor
        \param r_hex Red value in hex notation
        \param g_hex Blue value in hex notation
        \param b_hex Green value in hex notation
    */
    StyleColour(const string & r_hex, const string & g_hex, const string & b_hex);
    
    /** Constructor
        \param styleColourString String with rgb values
    */
    StyleColour(const string & styleColourString);

    StyleColour();
    ~StyleColour(){};

   void setRGBValues(const string & styleColourString);

    /** Sets red value
        \param r_hex New red value */
    void setRedValue(const string & r_hex);

    /** Sets green value
        \param g_hex New green value */
    void setGreenValue(const string & g_hex);

    /** Sets blue value
        \param b_hex New blue value */
    void setBlueValue(const string & b_hex);

    /** \return Red value in hex format */
    string& getHexRedValue();
    /** \return Green value in hex format */
    string& getHexGreenValue();
    /** \return Blue value in hex format */
    string& getHexBlueValue();

    /** \return Red value in latex format */
    string getLatexRedValue();
    /** \return Green value in latex format */
    string getLatexGreenValue();
    /** \return Blue value in latex format */
    string getLatexBlueValue();

    /** \return Red value in tex format */
    string getTexRedValue();
    /** \return Green value in tex format */
    string getTexGreenValue();
    /** \return Blue value in tex format */
    string getTexBlueValue();

    /** \return Red value in RTF format */
    string getRTFRedValue();
    /** \return Green value in RTF format */
    string getRTFGreenValue();
    /** \return Blue value in RTF format */
    string getRTFBlueValue();

  private:
    string r, g, b;
    string int2str(int);
    string float2str(double);
    int hex2dec(const string &hexVal);
  };

}

#endif
