/***************************************************************************
                          TexCode.cpp  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "texcode.h"

namespace highlight {

TexCode::TexCode(const string &colourTheme,
                 bool printLineNumbers, bool fragment, 
                 int numSpaces, WrapMode wrapStyle): 
  CodeParser(printLineNumbers, colourTheme, numSpaces, 
             wrapStyle, fragment) 
{ 
  styleTagOpen[STANDARD] = "{\\hlstd ";
  styleTagOpen[KEYWORD] = "{\\hlkey ";
  styleTagOpen[TYPE] = "{\\hltyp ";
  styleTagOpen[STRING] = "{\\hlstr ";
  styleTagOpen[NUMBER] = "{\\hlnum ";
  styleTagOpen[SINGLE_LINE_COMMENT] = "{\\hlcom ";
  styleTagOpen[MULTI_LINE_COMMENT_BEGIN] = "{\\hlcom ";
  styleTagOpen[ESC_CHAR] = "{\\hlesc ";
  styleTagOpen[DIRECTIVE_LINE] = "{\\hldir ";
  styleTagOpen[DIRECTIVE_STRING] = "{\\hldstr ";
  styleTagOpen[LINENUMBER] = "{\\hlline ";
  styleTagOpen[SYMBOL] = "{\\hlsym ";
  for (int i=0;i<NUMBER_OF_STYLES; i++)    {      
    styleTagClose[i] = "}";
  }
  
  /*This makex TeX to use every par it encounters (the \\leavevmode has
  no effect when TeX is in horizontal mode and when TeX is in vertical
  mode, it switches it to horizontal mode).*/
  newLineTag="\\leavevmode\\par\n";

  spacer = "\\ ";
  maskWs=true;
  excludeWs=true;        
  maskWsBegin = "{\\hlstd";
  maskWsEnd = "}";  
}

TexCode::TexCode()
{}
TexCode::~TexCode()
{}

string TexCode::formatStyleAttributes(const string & elemName,const ElementStyle & elem)
{
  ostringstream s;
  s << "\\def\\hl"
    << elemName 
    << "{";
  if (elem.isBold())
    s << "\\bf";
  if (elem.isItalic())
    s << "\\it";  
  s  <<  "\\textColor{"
     << (elem.getColour().getTexRedValue())<<" "
     << (elem.getColour().getTexGreenValue())<<" "
     << (elem.getColour().getTexBlueValue())<<" 0.0}}\n";
  return  s.str();
}

string TexCode::getHeader(const string & title)
{ 
  if (headerCache.empty()){
    ostringstream os; 
    os << formatStyleAttributes("std", docStyle.getDefaultStyle());
    os << formatStyleAttributes("key", docStyle.getKeywordStyle());
    os << formatStyleAttributes("num", docStyle.getNumberStyle());
    os << formatStyleAttributes("typ", docStyle.getTypeStyle());
    os << formatStyleAttributes("esc", docStyle.getEscapeCharStyle());
    os << formatStyleAttributes("str", docStyle.getStringStyle());
    os << formatStyleAttributes("dstr", docStyle.getDirectiveStringStyle());
    os << formatStyleAttributes("com", docStyle.getCommentStyle());
    os << formatStyleAttributes("dir", docStyle.getDirectiveStyle());
    os << formatStyleAttributes("line", docStyle.getLineStyle());
    os << formatStyleAttributes("sym", docStyle.getSymbolStyle());
    os << "\\nopagenumbers\n"
       << "\\input colordvi\n";
    headerCache=os.str();
  }
  return headerCache;
}

void TexCode::printBody()
{
  *out << "{\n\\tt\n" 
       <<  "% The special option is not supported by all dvi drivers\n"
       << "\\special{background rgb ";
  *out << docStyle.getBgColour().getLatexRedValue() << " "
       << docStyle.getBgColour().getLatexGreenValue() << " "
       << docStyle.getBgColour().getLatexBlueValue() << "}"  
       << endl;
  processStandardState();  
  *out << "}\n";
}

string TexCode::getFooter()
{ 
  if (footerCache.empty()){
    ostringstream os;
    os << "\\bye\n"
       << "% TeX generated by Highlight "
       << HIGHLIGHT_VERSION
       << ", "
       << HIGHLIGHT_URL
       << endl;
    footerCache=os.str();
  }
  return footerCache;
}

string TexCode:: maskCharacter(unsigned char c)
{
  string m;
  switch (c)
    {
    case '{':
    case '}':
      m += "$\\";
      m += c;
      m += "$";
      return m;
      break;
    case '^':
      return "{\\bf\\^{}}";
      break;
    case '_':
      return "\\_{}";      
      break;
    case '&':
    case '$':
    case '#':
    case '%':
      m+="\\";
      m += c;
      return m;
      break;
    case '\\':
      return "$\\backslash$";
      break;
    case ' ':
      return spacer;
      break;
    case '+':
    case '-':
    case '<':
    case '>':
    case '=':
      m += "$\\mathord{";
      m += c;
      m += "}$";
      return m;
      break;
    case AUML_LC:
      return "\\\"a";
      break;
    case OUML_LC:
      return "\\\"o";
      break;
    case UUML_LC:
      return "\\\"u";
      break;
    case AUML_UC:
      return "\\\"A";
      break;
    case OUML_UC:
      return "\\\"O";
      break;
    case UUML_UC:
      return "\\\"U";
      break;
    case AACUTE_LC:
      return "\\'a";
      break;
    case EACUTE_LC:
      return "\\'e";
      break;    
    case OACUTE_LC:
      return "\\'o";
      break;
    case UACUTE_LC:
      return "\\'u";
      break;
    case AGRAVE_LC:
      return "\\`a";
      break;
    case EGRAVE_LC:
      return "\\`e";
      break;    
    case OGRAVE_LC:
      return "\\`o";
      break;
    case UGRAVE_LC:
      return "\\`u";
      break;
    case AACUTE_UC:
      return "\\'A";
      break;
    case EACUTE_UC:
      return "\\'E";
      break;    
    case OACUTE_UC:
      return "\\'O";
      break;
    case UACUTE_UC:
      return "\\'U";
      break;
    case AGRAVE_UC:
      return "\\`A";
      break;
    case EGRAVE_UC:
      return "\\`E";
      break;    
    case UGRAVE_UC:
      return "\\`O";
      break;
    case OGRAVE_UC:
      return "\\`U";
      break;
    case SZLIG:
      return "\\ss ";
      break;
     #ifndef _WIN32
 // skip  first byte of multibyte chracters
    case 195:
      return string("");
      break;    
     #endif   
  
    default :
      string m;
      m += c;
      return m;
    }
}

}
