/***************************************************************************
                          texcode.h  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXCODE_H
#define TEXCODE_H

#include <string>
#include <iostream>
#include <sstream>

#include "charcodes.h"
#include "version.h"
#include "codeparser.h"


namespace highlight {

/**Class for outputting TeX
  *@author Andre Simon
  */

class TexCode : public highlight::CodeParser
  {
  public:

   /** Constructor     
     \param langDef LanguageDefinition which contains parsing information    
     \param colourTheme Name of Colour theme to use 
     \param printLineNumbers Test if line numbers should be printed
     \param fragment Test if header and footer of document should be omitted          
     \param numSpaces Number of spaces which replace a tab
     \param wrapStyle Line wrapping mode (0=none, 1=simple, 2=normal)
    */
    TexCode(const string &colourTheme,
            bool printLineNumbers=false,   bool fragment=false,
            int numSpaces=0, 
            highlight::WrapMode wrapStyle=highlight::WRAP_DISABLED);
    TexCode();
    ~TexCode();

   /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string & title);

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();

  private: 
    /** Gibt Tex-Code der Sonderzeichen zurueck */
    virtual string maskCharacter(unsigned char );

    string formatStyleAttributes(const string & elemName, const ElementStyle & elem);
  };

}

#endif
