/***************************************************************************
                          xslfocode.h  -  description
                             -------------------
    begin                : Do 11.12.2003
    copyright            : (C) 2003 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XSLFO_H
#define XSLFO_H


#include <string>
#include <sstream>
#include <iostream>
#include <fstream>

#include "codeparser.h"
#include "version.h"

namespace highlight {

/** Class for outputting XSL-FO
  *@author Andre Simon
  */

class XslFoCode : public highlight::CodeParser
  {
  public:

   /** Constructor     
     \param langDef LanguageDefinition which contains parsing information    
     \param colourTheme Name of Colour theme to use 
     \param printLineNumbers Test if line numbers should be printed
     \param fragment Test if header and footer of document should be omitted       
     \param numSpaces Number of spaces which replace a tab
     \param wrapStyle Line wrapping mode (0=none, 1=simple, 2=normal)
     \param fopCompatible Test if output should be compatible with Apache FOP 0.20.5      
    */
    XslFoCode( const string &colourTheme,
               bool printLineNumbers=false,   bool fragment=false, 
               int numSpaces=0, 
               highlight::WrapMode wrapStyle=highlight::WRAP_DISABLED,
               bool fopCompatible=false);
    XslFoCode();
    ~XslFoCode();

   /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string & title);

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();

  private:
    bool fopOutput;
    ostringstream snl;
    string styleDefinition;    
    virtual string maskCharacter(unsigned char );    
    string getOpenTag(const ElementStyle &);    
    string getNewLine();    
  };

}

#endif
