<?php // -*-php-*-
rcs_id('$Id: CodeHighLight.php,v 1.11 2002/12/30 23:49:35 carstenklapp Exp $');
/**
*
* A wrapper plugin for the highlight- application
*     Highlight: http://www.andre-simon.de
*
* AUTHOR of this Plugin: Philip Van Hoof (http://www.freax.eu.org)
*
* Usage:
* <?plugin CodeHighLight language='lang'
* code to highlight
* ?>
*
* Example :
*
* <?plugin CodeHighLight language='c'
* int main (int argc, char **argv)
* {
*     printf ("Hello World\n");
* }
* ?>
*
*/


/*
Add these to your stylesheet

.key {
  font-weight: bold;
  color:blue;
}
                                                                                                                                                                 
.typ {
  color:blue;
}
                                                                                                                                                                 
.com {
  color:brown;
}
                                                                                                                                                                 
.str {
  color:green;
}
                                                                                                                                                                 
.num {
  color:purple;
}

.code {
    margin-top: 8pt;
    margin-bottom: 8pt;
    background-color: #FFFFEE;
    white-space: pre;
    border-style: solid;
    border-width: 1pt;
    border-color: #999999;
    color:#111111;
    padding-left: 0.4%;
    padding-top: 2pt;
    padding-bottom: 2pt;
    width: 99.6%;
}

*/

// Constants are defined before the class.
if (!defined('THE_END'))
    define('THE_END', "!");

class WikiPlugin_CodeHighLight
extends WikiPlugin
{

    /* php 4.3.0
    function filterThroughCmd($input, $commandLine) {
        $descriptorspec = array(
               0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
               1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
              2 => array("file", "/tmp/error-output.txt", "a") // stderr is a file to write to
        );

        $process = proc_open("$commandLine", $descriptorspec, $pipes);
        if (is_resource($process)) {
                // $pipes now looks like this:
                // 0 => writeable handle connected to child stdin
                // 1 => readable handle connected to child stdout
                // Any error output will be appended to /tmp/error-output.txt

            fwrite($pipes[0], $input);
            fclose($pipes[0]);
            $buf = "";
            while(!feof($pipes[1])) {
                $buf .= fgets($pipes[1], 1024);
            }
            fclose($pipes[1]);
            // It is important that you close any pipes before calling
            // proc_close in order to avoid a deadlock
            $return_value = proc_close($process);
            return $buf;
        }

    }
    */

    /* Older PHP versions */
    function filterThroughCmd($input, $commandLine) {

         $input = str_replace ("\\", "\\\\", $input);
         $input = str_replace ("\"", "\\\"", $input);
         $input = str_replace ("\$", "\\\$", $input);
         $input = str_replace ("`", "\`", $input);

         $pipe = popen("echo \"$input\"|$commandLine" , 'r');
         if (!$pipe) {
            print "pipe failed.";
            return "";
         }

         $output = '';

         while(!feof($pipe)) {
            $output .= fread($pipe, 1024);
         }

         pclose($pipe);
         return $output;
    }


    // Five required functions in a WikiPlugin.

    function getName () {
        return _("CodeHighLight");
    }

    function getDescription () {
        return _("Highlight wrapper plugin");

    }

    function getVersion() {
        return preg_replace("/[Revision: $]/", '',
                            "\$Revision: 0.1 $");
    }

    // Establish default values for each of this plugin's arguments.
    function getDefaultArguments() {
    return "";
    }

    function run($dbi, $argstr, $request) {

    // In case the plugin stopped workin
    // on a certain page, uncomment this one and
    // remove the plugin-tag :-)

    // return "";


    if (preg_match ("/^language='([A-Za-z]*)'\s(.*)/s", $argstr, $matches))
    {
        if ($matches[1]=="")
            $language="c";
        else
            $language = $matches[1];

        $code = $matches[2];
        $ret =  $this->filterThroughCmd ($code, "/usr/bin/highlight -f -S $language");
        return HTML::raw("<pre class=\"code\">".$ret."</pre>");
    } else {
        return HTML::raw("<pre class=\"code\">Invalid arguments</pre>");
    }


    }

};

// For emacs users
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:
?>
