//
// C++ Interface: enums
//
// Description:
//
//
// Author: Andre Simon <andre.simon1@gmx.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef ENUMS_H
#define ENUMS_H

namespace highlight {

/** states which may occour during input file parsing*/
enum State {
  STANDARD=0,
  STRING,
  NUMBER,
  SL_COMMENT,
  ML_COMMENT_BEGIN,
  ESC_CHAR,
  DIRECTIVE_LINE,
  DIRECTIVE_STRING,
  LINENUMBER,
  SYMBOL,

  // Konstanten ab hier duefen nicht mehr als Array-Indizes benutzt werden!!
  KEYWORD,
  ML_COMMENT_END,
  DIRECTIVE_LINE_END,
  TAG_BEGIN,
  TAG_END,
  KEYWORD_BEGIN,
  KEYWORD_END,
  ESC_CHAR_EXT,  // escape character outside of strings

  _UNKNOWN=100,
  _EOL,
  _EOF,
  _WS
} ;

/** Parser return values*/
enum ParseError{
   PARSE_OK,
   BAD_INPUT=1,
   BAD_OUTPUT=2,
   BAD_STYLE=4
};

/** line wrapping modes*/
enum WrapMode {
  WRAP_DISABLED,
  WRAP_SIMPLE,
  WRAP_DEFAULT
};

/** language definition loading results*/
enum LoadResult{
  LOAD_FAILED,
  LOAD_NEW,
  LOAD_NONE
};

/** output formats */
enum OutputType {
  HTML,
  XHTML,
  TEX,
  LATEX,
  RTF,
  XSLFO,
  ANSI
};


}

#endif
