/***************************************************************************
                          htmlgenerator.h  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef HTMLGENERATOR_H
#define HTMLGENERATOR_H

#include <fstream>
#include <iostream>
#include <string>
#include <sstream>

#include "codegenerator.h"
#include "version.h"
#include "charcodes.h"
#include "stylecolour.h"
#include "elementstyle.h"
//#include "stringtools.h"
#include "platform_fs.h"

namespace highlight {

/**
   \brief This class generates HTML.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/

class HtmlGenerator  : public highlight::CodeGenerator
  {
  public:

    /** Constructor
     \param colourTheme Name of Colour theme to use
     \param cssInFilename Path of file to be included in cssOutFilename
     \param cssOutFilename Path of external CSS stylesheet
     \param includeCssDef Test if CSS should be included in outfile
     \param withAnchors Test if HTML anchors should be attached to line numbers
    */
    HtmlGenerator(const string &colourTheme,
                  const string &cssInFilename="",
                  const string &cssOutFilename="",
                  bool includeCssDef=false,
                  bool withAnchors = false);

    HtmlGenerator();

    /** Destructor*/
    virtual ~HtmlGenerator() {};

    /** insert line number in the beginning of the new line
    */
    virtual void insertLineNumber(bool insertNewLine=true);

    /** Print document header
       \param  title Title of the document
    */
    string getHeader(const string &title);

    /** Print document body*/
    void printBody();

    /** Print document footer*/
    string getFooter();

    /** Print style definitions to external file
     \param outFile Path of external style definition
     */
     bool printExternalStyle(const string &outFile);

    /** Print index file with all input file names
      \param fileList List of output file names
      \param outPath Output path
    */
     bool printIndexFile(const vector<string> & fileList, const string &outPath);

  protected:

    /** some strings which are similar in HTML and XHTML*/
    string brTag, hrTag, idAttr, fileSuffix;

    /** first part of HTML header */
    string HTML_HEADER1;

    /** second part of HTML header */
    string HTML_HEADER2;

    /** HTML footer */
    string HTML_FOOTER;

    /** path and filename of CSS outfile */
    string cssInFile, cssOutFile,  cssOutDir;

    /** caches style definition */
    string styleDefinitionCache;

    /** test if CSS should be included in outfile */
    bool includeCss;

    /** \return CSS definition */
    string  getStyleDefinition();

     /**
      \return Content of user defined input style
    */
    string readUserStyleDef();

  private:

    /**  \param styleName Style name
         \return Opening tag of the given style
    */
    string getOpenTag(const string& styleName);

    /** \return escaped character*/
    virtual string maskCharacter(unsigned char );

    /** test if anchors should be appied to line numbers*/
    bool attachAnchors;

    /**\return text formatting attributes in HTML format */
    string  formatStyleAttributes(const string & elemName, const ElementStyle & elem);

    /**  \param styleID Style ID
         \return Opening tag of the given style
    */
    string getMatchingOpenTag(unsigned int styleID);

    /**  \param styleID Style ID
         \return Closing tag of the given style
    */
    string getMatchingCloseTag(unsigned int styleID);
  };

}

#endif
