/***************************************************************************
                        linewrapper.cpp  -  description
                             -------------------
    begin                : Sa Jan 00 2004
    copyright            : (C) 2004 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LINEWRAPPER_H
#define LINEWRAPPER_H

#define LB_CHARS " \t[](){}-+<>.:,;"
#define WS_CHARS " \n\r\t"

#include <string>
#include <iostream>

#include "stringtools.h"

namespace highlight {

/** \brief Class which provides intelligent line wrapping.
* @author Andre Simon
*/

class LineWrapper{
public:
    /** Constructor
     \param maxlength Max length of line
     \param indentAfterOpenBraces Test if statements and function parameters should be indented
    */
    LineWrapper(unsigned int maxlength=80, bool indentAfterOpenBraces=true);

    LineWrapper();

    ~LineWrapper();

    /**
     \return True if current line can be wrapped again
    */
    bool hasMoreLines();

    /**
     Sets new line to be wrapped
     \param newline New line
    */
    void setLine(const std::string  newline);

    /**
     The method will indent function calls and statements
     \return Next line
    */
    std::string  getNextLine();

    /**
     \return True if lines following open braces should be indented
    */
    bool indentCode();

private:
    const unsigned int MAX_LINE_LENGTH;

    std::string line, wsPrefix;
    unsigned int index;
    size_t wsPrefixLength;
    bool hasMore, indentAfterOpenBraces;
    bool redefineWsPrefix;
};

}

#endif
