/***************************************************************************
                          datadir.h  -  description
                             -------------------
    begin                : Sam M� 1 2003
    copyright            : (C) 2003 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATADIR_H
#define DATADIR_H

#include <string>
#include <fstream>
#include <iostream>
//#include "stringtools.h"
#include "platform_fs.h"

using namespace std;

 /** \brief Manages access to installation directories.

     Apart from the standard installation directory, one can define additional
     search paths.
  **/

class DataDir
  {
     string dataDir;
     string additionalDataDir;
     bool fileExists(const string&f);

  public:

     DataDir();

     /** search for a valid installation directory
         \param  userDefinedDir Directory defined by user
         \return True if directory was found */
     bool searchDataDir(const string &userDefinedDir);

     /** add another installation directory, which is added to search path
         \param  dir Directory defined by user */
     void setAdditionalDataDir(const string& dir);

    /** \return Data installation directory */
     const string & getDir() ;

    /** \return Location of languafe definitions */
     const string getLangDefDir() ;

    /** \return Location of themes */
     const string getThemeDir() ;

    /** \return Location of indentation schemes */
    const string getIndentSchemesDir();

    /** \return User defined location of indentation schemes */
    const string getAdditionalIndentSchemesDir();

     /** \return User defined location of languafe definitions */
     const string getAdditionalLangDefDir() ;

    /** \return User defined location of themes */
     const string getAdditionalThemeDir() ;

    /** \return Location of help files */
     const string getHelpMsgDir() ;

    /** \return Location of configuration files */
     const string getConfDir() ;

     /** \param langDef Name of language definition
         \return Absolute path of definiton found in a data directory */
     const string searchForLangDef(const string & langDef);

     /** \param theme Name of colour theme file
         \return Absolute path of theme found in a data directory */
     const string searchForTheme(const string & theme);

     /** \param scheme Name of indent scheme file
         \return Absolute path of theme found in a data directory */
     const string searchForIndentScheme(const string & scheme);
  };

#endif
