{- This module was generated from data in the Kate syntax highlighting file coldfusion.xml, version 1.04,
   by   -}

module Text.Highlighting.Kate.Syntax.Coldfusion ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "ColdFusion"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.cfm;*.cfc;*.cfml;*.dbm"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "ColdFusion" }
  context <- currentContext <|> (pushContext "Normal Text" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("ColdFusion",["Normal Text"])], synStLanguage = "ColdFusion", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal Text" -> return ()
    "ctxCFSCRIPT Tag" -> return ()
    "ctxSCRIPT Tag" -> return ()
    "ctxSTYLE Tag" -> return ()
    "ctxTag" -> return ()
    "ctxTable Tag" -> return ()
    "ctxAnchor Tag" -> return ()
    "ctxImage Tag" -> return ()
    "ctxCF Tag" -> return ()
    "ctxCustom Tag" -> return ()
    "ctxCFX Tag" -> return ()
    "ctxHTML Comment" -> return ()
    "ctxCF Comment" -> return ()
    "ctxC Style Comment" -> return ()
    "ctxOne Line Comment" -> (popContext >> return ())
    "ctxHTML Entities" -> (popContext >> return ())
    "ctxCFSCRIPT Block" -> return ()
    "ctxSCRIPT Block" -> return ()
    "ctxSTYLE Block" -> return ()
    "ctxStyle Properties" -> return ()
    "ctxStyle Values" -> (popContext >> return ())
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("HTML Comment","co"),("CF Comment","co"),("Script Comment","co"),("Script Functions","fu")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_Script_Keywords = Set.fromList $ words $ "if else for in while do continue break with try catch switch case new var function return this delete true false void throw typeof const default"
list_Script_Objects = Set.fromList $ words $ "anchor applet area array boolean button checkbox date document event fileupload form frame function hidden history image layer linke location math navigator number object option password radio regexp reset screen select string submit text textarea window"
list_Script_Methods = Set.fromList $ words $ "abs acos alert anchor apply asin atan atan2 back blur call captureevents ceil charat charcodeat clearinterval cleartimeout click close compile concat confirm cos disableexternalcapture enableexternalcapture eval exec exp find floor focus forward fromcharcode getdate getday getfullyear gethours getmilliseconds getminutes getmonth getseconds getselection gettime gettimezoneoffset getutcdate getutcday getutcfullyear getutchours getutcmilliseconds getutcminutes getutcmonth getutcseconds go handleevent home indexof javaenabled join lastindexof link load log match max min moveabove movebelow moveby moveto movetoabsolute open parse plugins.refresh pop pow preference print prompt push random releaseevents reload replace reset resizeby resizeto reverse round routeevent scrollby scrollto search select setdate setfullyear sethours setinterval setmilliseconds setminutes setmonth setseconds settime settimeout setutcdate setutcfullyear setutchours setutcmilliseconds setutcminutes setutcmonth setutcseconds shift sin slice sort splice split sqrt stop string formatting submit substr substring taintenabled tan test tolocalestring tolowercase tosource tostring touppercase toutcstring unshift unwatch utc valueof watch write writeln"
list_CFSCRIPT_Keywords = Set.fromList $ words $ "break case catch continue default do else for function if in return switch try var while"
list_CFSCRIPT_Functions = Set.fromList $ words $ "abs acos arrayappend arrayavg arrayclear arraydeleteat arrayinsertat arrayisempty arraylen arraymax arraymin arraynew arrayprepend arrayresize arrayset arraysort arraysum arrayswap arraytolist asc asin atn bitand bitmaskclear bitmaskread bitmaskset bitnot bitor bitshln bitshrn bitxor ceiling chr cjustify compare comparenocase cos createdate createdatetime createobject createodbcdate createodbcdatetime createodbctime createtime createtimespan createuuid dateadd datecompare dateconvert datediff dateformat datepart day dayofweek dayofweekasstring dayofyear daysinmonth daysinyear de decimalformat decrementvalue decrypt deleteclientvariable directoryexists dollarformat duplicate encrypt evaluate exp expandpath fileexists find findnocase findoneof firstdayofmonth fix formatbasen getauthuser getbasetagdata getbasetaglist getbasetemplatepath getclientvariableslist getcurrenttemplatepath getdirectoryfrompath getexception getfilefrompath getfunctionlist gethttprequestdata gethttptimestring getk2serverdoccount getk2serverdoccountlimit getlocale getmetadata getmetricdata getpagecontext getprofilesections getprofilestring getservicesettings gettempdirectory gettempfile gettemplatepath gettickcount gettimezoneinfo gettoken hash hour htmlcodeformat htmleditformat iif incrementvalue inputbasen insert int isarray isbinary isboolean iscustomfunction isdate isdebugmode isdefined isk2serverabroker isk2serverdoccountexceeded isk2serveronline isleapyear isnumeric isnumericdate isobject isquery issimplevalue isstruct isuserinrole iswddx isxmldoc isxmlelement isxmlroot javacast jsstringformat lcase left len listappend listchangedelims listcontains listcontainsnocase listdeleteat listfind listfindnocase listfirst listgetat listinsertat listlast listlen listprepend listqualify listrest listsetat listsort listtoarray listvaluecount listvaluecountnocase ljustify log log10 lscurrencyformat lsdateformat lseurocurrencyformat lsiscurrency lsisdate lsisnumeric lsnumberformat lsparsecurrency lsparsedatetime lsparseeurocurrency lsparsenumber lstimeformat ltrim max mid min minute month monthasstring now numberformat paragraphformat parameterexists parsedatetime pi preservesinglequotes quarter queryaddcolumn queryaddrow querynew querysetcell quotedvaluelist rand randomize randrange refind refindnocase removechars repeatstring replace replacelist replacenocase rereplace rereplacenocase reverse right rjustify round rtrim second setencoding setlocale setprofilestring setvariable sgn sin spanexcluding spanincluding sqr stripcr structappend structclear structcopy structcount structdelete structfind structfindkey structfindvalue structget structinsert structisempty structkeyarray structkeyexists structkeylist structnew structsort structupdate tan timeformat tobase64 tobinary tostring trim ucase urldecode urlencodedformat urlsessionformat val valuelist week writeoutput xmlchildpos xmlelemnew xmlformat xmlnew xmlparse xmlsearch xmltransform year yesnoformat"

regex_'3c'5bcC'5d'5bfF'5d'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d = compileRegex "<[cC][fF][sS][cC][rR][iI][pP][tT]"
regex_'3c'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d = compileRegex "<[sS][cC][rR][iI][pP][tT]"
regex_'3c'5bsS'5d'5btT'5d'5byY'5d'5blL'5d'5beE'5d = compileRegex "<[sS][tT][yY][lL][eE]"
regex_'3c'5c'2f'3f'5bcC'5d'5bfF'5d'5f = compileRegex "<\\/?[cC][fF]_"
regex_'3c'5c'2f'3f'5bcC'5d'5bfF'5d'5bxX'5d'5f = compileRegex "<\\/?[cC][fF][xX]_"
regex_'3c'5c'2f'3f'5bcC'5d'5bfF'5d = compileRegex "<\\/?[cC][fF]"
regex_'3c'5c'2f'3f'28'5btT'5d'5baAhHbBfFrRdD'5d'29'7c'28'5bcC'5d'5baA'5d'5bpP'5d'5btT'5d'29 = compileRegex "<\\/?([tT][aAhHbBfFrRdD])|([cC][aA][pP][tT])"
regex_'3c'5c'2f'3f'5baA'5d_ = compileRegex "<\\/?[aA] "
regex_'3c'5c'2f'3f'5biI'5d'5bmM'5d'5bgG'5d_ = compileRegex "<\\/?[iI][mM][gG] "
regex_'3c'21'3f'5c'2f'3f'5ba'2dzA'2dZ0'2d9'5f'5d'2b = compileRegex "<!?\\/?[a-zA-Z0-9_]+"
regex_'22'5b'5e'22'5d'2a'22 = compileRegex "\"[^\"]*\""
regex_'27'5b'5e'27'5d'2a'27 = compileRegex "'[^']*'"
regex_'3c'2f'5bcC'5d'5bfF'5d'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d'3e = compileRegex "</[cC][fF][sS][cC][rR][iI][pP][tT]>"
regex_'3c'2f'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d'3e = compileRegex "</[sS][cC][rR][iI][pP][tT]>"
regex_'3c'2f'5bsS'5d'5btT'5d'5byY'5d'5blL'5d'5beE'5d'3e = compileRegex "</[sS][tT][yY][lL][eE]>"
regex_'23'28'5b0'2d9a'2dfA'2dF'5d'7b3'7d'29'7c'28'5b0'2d9a'2dfA'2dF'5d'7b6'7d'29 = compileRegex "#([0-9a-fA-F]{3})|([0-9a-fA-F]{6})"

defaultAttributes = [("Normal Text","Normal Text"),("ctxCFSCRIPT Tag","Script Tags"),("ctxSCRIPT Tag","Script Tags"),("ctxSTYLE Tag","Style Tags"),("ctxTag","Tags"),("ctxTable Tag","Table Tags"),("ctxAnchor Tag","Anchor Tags"),("ctxImage Tag","Image Tags"),("ctxCF Tag","CF Tags"),("ctxCustom Tag","Custom Tags"),("ctxCFX Tag","CFX Tags"),("ctxHTML Comment","HTML Comment"),("ctxCF Comment","CF Comment"),("ctxC Style Comment","Script Comment"),("ctxOne Line Comment","Script Comment"),("ctxHTML Entities","HTML Entities"),("ctxCFSCRIPT Block","Normal Text"),("ctxSCRIPT Block","Normal Text"),("ctxSTYLE Block","Style Selectors"),("ctxStyle Properties","Style Properties"),("ctxStyle Values","Style Values")]

parseRules "Normal Text" = 
  do (attr, result) <- (((pString False "<!---" >>= withAttribute "CF Comment") >>~ pushContext "ctxCF Comment")
                        <|>
                        ((pString False "<!--" >>= withAttribute "HTML Comment") >>~ pushContext "ctxHTML Comment")
                        <|>
                        ((pRegExpr regex_'3c'5bcC'5d'5bfF'5d'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d >>= withAttribute "Script Tags") >>~ pushContext "ctxCFSCRIPT Tag")
                        <|>
                        ((pRegExpr regex_'3c'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d >>= withAttribute "Script Tags") >>~ pushContext "ctxSCRIPT Tag")
                        <|>
                        ((pRegExpr regex_'3c'5bsS'5d'5btT'5d'5byY'5d'5blL'5d'5beE'5d >>= withAttribute "Style Tags") >>~ pushContext "ctxSTYLE Tag")
                        <|>
                        ((pDetectChar False '&' >>= withAttribute "HTML Entities") >>~ pushContext "ctxHTML Entities")
                        <|>
                        ((pRegExpr regex_'3c'5c'2f'3f'5bcC'5d'5bfF'5d'5f >>= withAttribute "Custom Tags") >>~ pushContext "ctxCustom Tag")
                        <|>
                        ((pRegExpr regex_'3c'5c'2f'3f'5bcC'5d'5bfF'5d'5bxX'5d'5f >>= withAttribute "CFX Tags") >>~ pushContext "ctxCFX Tag")
                        <|>
                        ((pRegExpr regex_'3c'5c'2f'3f'5bcC'5d'5bfF'5d >>= withAttribute "CF Tags") >>~ pushContext "ctxCF Tag")
                        <|>
                        ((pRegExpr regex_'3c'5c'2f'3f'28'5btT'5d'5baAhHbBfFrRdD'5d'29'7c'28'5bcC'5d'5baA'5d'5bpP'5d'5btT'5d'29 >>= withAttribute "Table Tags") >>~ pushContext "ctxTable Tag")
                        <|>
                        ((pRegExpr regex_'3c'5c'2f'3f'5baA'5d_ >>= withAttribute "Anchor Tags") >>~ pushContext "ctxAnchor Tag")
                        <|>
                        ((pRegExpr regex_'3c'5c'2f'3f'5biI'5d'5bmM'5d'5bgG'5d_ >>= withAttribute "Image Tags") >>~ pushContext "ctxImage Tag")
                        <|>
                        ((pRegExpr regex_'3c'21'3f'5c'2f'3f'5ba'2dzA'2dZ0'2d9'5f'5d'2b >>= withAttribute "Tags") >>~ pushContext "ctxTag"))
     return (attr, result)

parseRules "ctxCFSCRIPT Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Script Tags") >>~ pushContext "ctxCFSCRIPT Block")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxSCRIPT Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Script Tags") >>~ pushContext "ctxSCRIPT Block")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxSTYLE Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Style Tags") >>~ pushContext "ctxSTYLE Block")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxTag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxTable Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Table Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxAnchor Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Anchor Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxImage Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Image Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxCF Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "CF Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxCustom Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Custom Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxCFX Tag" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "CFX Tags") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules "ctxHTML Comment" = 
  do (attr, result) <- (((pString False "<!---" >>= withAttribute "CF Comment") >>~ pushContext "ctxCF Comment")
                        <|>
                        ((pString False "-->" >>= withAttribute "HTML Comment") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "ctxCF Comment" = 
  do (attr, result) <- ((pString False "--->" >>= withAttribute "CF Comment") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "ctxC Style Comment" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Script Comment") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "ctxOne Line Comment" = 
  pzero

parseRules "ctxHTML Entities" = 
  do (attr, result) <- ((pDetectChar False ';' >>= withAttribute "HTML Entities") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "ctxCFSCRIPT Block" = 
  do (attr, result) <- (((pDetect2Chars False '/' '*' >>= withAttribute "Script Comment") >>~ pushContext "ctxC Style Comment")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Script Comment") >>~ pushContext "ctxOne Line Comment")
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Script Strings"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Script Strings"))
                        <|>
                        ((pInt >>= withAttribute "Script Numbers"))
                        <|>
                        ((pFloat >>= withAttribute "Script Numbers"))
                        <|>
                        ((pAnyChar "[()[\\]=+-*/]+" >>= withAttribute "Script Operators"))
                        <|>
                        ((pAnyChar "{}" >>= withAttribute "Brackets"))
                        <|>
                        ((pKeyword " \n\t.():!+,<=>%&*/;?[]^{|}~\\" list_CFSCRIPT_Keywords >>= withAttribute "Script Keywords"))
                        <|>
                        ((pKeyword " \n\t.():!+,<=>%&*/;?[]^{|}~\\" list_CFSCRIPT_Functions >>= withAttribute "Script Functions"))
                        <|>
                        ((pRegExpr regex_'3c'2f'5bcC'5d'5bfF'5d'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d'3e >>= withAttribute "Script Tags") >>~ (popContext >> popContext >> return ())))
     return (attr, result)

parseRules "ctxSCRIPT Block" = 
  do (attr, result) <- (((pDetect2Chars False '/' '*' >>= withAttribute "Script Comment") >>~ pushContext "ctxC Style Comment")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Script Comment") >>~ pushContext "ctxOne Line Comment")
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Script Strings"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Script Strings"))
                        <|>
                        ((pInt >>= withAttribute "Script Numbers"))
                        <|>
                        ((pFloat >>= withAttribute "Script Numbers"))
                        <|>
                        ((pAnyChar "[()[\\]=+-*/]+" >>= withAttribute "Script Operators"))
                        <|>
                        ((pAnyChar "{}" >>= withAttribute "Brackets"))
                        <|>
                        ((pKeyword " \n\t.():!+,<=>%&*/;?[]^{|}~\\" list_Script_Keywords >>= withAttribute "Script Keywords"))
                        <|>
                        ((pKeyword " \n\t.():!+,<=>%&*/;?[]^{|}~\\" list_Script_Objects >>= withAttribute "Script Objects"))
                        <|>
                        ((pKeyword " \n\t.():!+,<=>%&*/;?[]^{|}~\\" list_Script_Methods >>= withAttribute "Script Functions"))
                        <|>
                        ((pRegExpr regex_'3c'2f'5bsS'5d'5bcC'5d'5brR'5d'5biI'5d'5bpP'5d'5btT'5d'3e >>= withAttribute "Script Tags") >>~ (popContext >> popContext >> return ())))
     return (attr, result)

parseRules "ctxSTYLE Block" = 
  do (attr, result) <- (((pDetect2Chars False '/' '*' >>= withAttribute "Script Comment") >>~ pushContext "ctxC Style Comment")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Brackets") >>~ pushContext "ctxStyle Properties")
                        <|>
                        ((pRegExpr regex_'3c'2f'5bsS'5d'5btT'5d'5byY'5d'5blL'5d'5beE'5d'3e >>= withAttribute "Style Tags") >>~ (popContext >> popContext >> return ())))
     return (attr, result)

parseRules "ctxStyle Properties" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Brackets") >>~ (popContext >> return ()))
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Script Comment") >>~ pushContext "ctxC Style Comment")
                        <|>
                        ((pDetectChar False ':' >>= withAttribute "Normal Text") >>~ pushContext "ctxStyle Values"))
     return (attr, result)

parseRules "ctxStyle Values" = 
  do (attr, result) <- (((pDetectChar False ';' >>= withAttribute "Normal Text") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False ',' >>= withAttribute "Normal Text"))
                        <|>
                        ((pInt >>= withAttribute "Numbers"))
                        <|>
                        ((pFloat >>= withAttribute "Numbers"))
                        <|>
                        ((pRegExpr regex_'23'28'5b0'2d9a'2dfA'2dF'5d'7b3'7d'29'7c'28'5b0'2d9a'2dfA'2dF'5d'7b6'7d'29 >>= withAttribute "Numbers"))
                        <|>
                        ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute "Attribute Values"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "Attribute Values")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
