{- This module was generated from data in the Kate syntax highlighting file dtd.xml, version 1.02,
   by  Andriy Lesyuk (s-andy@in.if.ua) -}

module Text.Highlighting.Kate.Syntax.Dtd ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "DTD"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.dtd"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "DTD" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("DTD",["Normal"])], synStLanguage = "DTD", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "Comment" -> return () >> pHandleEndLine
    "PI" -> return () >> pHandleEndLine
    "Declaration" -> return () >> pHandleEndLine
    "String" -> return () >> pHandleEndLine
    "InlineComment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Comment","co"),("Processing Instruction","kw"),("Declaration","dt"),("Name","fu"),("Delimiter","dv"),("Symbol","fl"),("Keyword","kw"),("String","st"),("Entity","dv"),("Local","dv")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_Category = Set.fromList $ words $ "EMPTY ANY CDATA ID IDREF IDREFS NMTOKEN NMTOKENS ENTITY ENTITIES NOTATION PUBLIC SYSTEM NDATA"
list_Keywords = Set.fromList $ words $ "#PCDATA #REQUIRED #IMPLIED #FIXED"

regex_'28'2d'7cO'29'5cs'28'2d'7cO'29 = compileRegex "(-|O)\\s(-|O)"
regex_'28'25'7c'26'29'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5b'5c'2d'5cw'5cd'5c'2e'3a'5f'5d'2b'29'3b = compileRegex "(%|&)(#[0-9]+|#[xX][0-9A-Fa-f]+|[\\-\\w\\d\\.:_]+);"
regex_'25'5cs = compileRegex "%\\s"
regex_'5cb'5b'5c'2d'5cw'5cd'5c'2e'3a'5f'5d'2b'5cb = compileRegex "\\b[\\-\\w\\d\\.:_]+\\b"
regex_'25'5b'5c'2d'5cw'5cd'5c'2e'3a'5f'5d'2b'3b = compileRegex "%[\\-\\w\\d\\.:_]+;"

defaultAttributes = [("Normal","Normal"),("Comment","Comment"),("PI","Other"),("Declaration","Other"),("String","String"),("InlineComment","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal"))
                        <|>
                        ((pString False "<!--" >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pString False "<?xml" >>= withAttribute "Processing Instruction") >>~ pushContext "PI")
                        <|>
                        ((pString False "<!ELEMENT" >>= withAttribute "Declaration") >>~ pushContext "Declaration")
                        <|>
                        ((pString False "<!ATTLIST" >>= withAttribute "Declaration") >>~ pushContext "Declaration")
                        <|>
                        ((pString False "<!NOTATION" >>= withAttribute "Declaration") >>~ pushContext "Declaration")
                        <|>
                        ((pString False "<!ENTITY" >>= withAttribute "Declaration") >>~ pushContext "Declaration")
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal")))
     return (attr, result)

parseRules "Comment" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((pString False "-->" >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "PI" = 
  do (attr, result) <- ((pDetect2Chars False '?' '>' >>= withAttribute "Processing Instruction") >>~ (popContext))
     return (attr, result)

parseRules "Declaration" = 
  do (attr, result) <- (((pString False "<!--" >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pDetect2Chars False '-' '-' >>= withAttribute "Comment") >>~ pushContext "InlineComment")
                        <|>
                        ((pDetectChar False '>' >>= withAttribute "Declaration") >>~ (popContext))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pRegExpr regex_'28'2d'7cO'29'5cs'28'2d'7cO'29 >>= withAttribute "Declaration"))
                        <|>
                        ((pAnyChar "(|)," >>= withAttribute "Delimiter"))
                        <|>
                        ((pRegExpr regex_'28'25'7c'26'29'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5b'5c'2d'5cw'5cd'5c'2e'3a'5f'5d'2b'29'3b >>= withAttribute "Entity"))
                        <|>
                        ((pAnyChar "?*+-&" >>= withAttribute "Symbol"))
                        <|>
                        ((pRegExpr regex_'25'5cs >>= withAttribute "Local"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Category >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'5b'5c'2d'5cw'5cd'5c'2e'3a'5f'5d'2b'5cb >>= withAttribute "Name")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'25'5b'5c'2d'5cw'5cd'5c'2e'3a'5f'5d'2b'3b >>= withAttribute "Entity")))
     return (attr, result)

parseRules "InlineComment" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((pDetect2Chars False '-' '-' >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
