{- This module was generated from data in the Kate syntax highlighting file mandoc.xml, version 0.11,
   by  Matthew Woehlke (mw_triad@users.sourceforge.net) -}

module Text.Highlighting.Kate.Syntax.Mandoc ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Troff Mandoc"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.1;*.2;*.3;*.4;*.5;*.6;*.7;*.8;*.1m;*.3x;*.tmac"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Troff Mandoc" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Troff Mandoc",["Normal"])], synStLanguage = "Troff Mandoc", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "DetectDirective" -> (popContext) >> pEndLine
    "Directive" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Comment","co"),("Macros","fu"),("Headings","kw"),("Paragraphs","dt"),("Formatting","kw"),("Other Macros","fu"),("Identifier","st")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_headings = Set.fromList $ words $ "SH SS TH"
list_paragraph = Set.fromList $ words $ "HP IP LP P PD PP RE RS TP"
list_formatting = Set.fromList $ words $ "B BI BR I IB IR RB RI SM SB"
list_others = Set.fromList $ words $ "DT"


defaultAttributes = [("Normal","Normal Text"),("DetectDirective","Macros"),("Directive","Identifier")]

parseRules "Normal" = 
  do (attr, result) <- (((parseRules "DetectComments##Roff"))
                        <|>
                        ((pColumn 0 >> pDetectChar False '.' >>= withAttribute "Macros") >>~ pushContext "DetectDirective")
                        <|>
                        ((parseRules "DetectOthers##Roff")))
     return (attr, result)

parseRules "DetectDirective" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_headings >>= withAttribute "Headings") >>~ pushContext "Directive")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_paragraph >>= withAttribute "Paragraphs") >>~ pushContext "Directive")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_formatting >>= withAttribute "Formatting") >>~ pushContext "Directive")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_others >>= withAttribute "Other Macros") >>~ pushContext "Directive")
                        <|>
                        ((parseRules "DetectDirective##Roff")))
     return (attr, result)

parseRules "Directive" = 
  do (attr, result) <- ((parseRules "Directive##Roff"))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
