{- This module was generated from data in the Kate syntax highlighting file winehq.xml, version 1.03,
   by   -}

module Text.Highlighting.Kate.Syntax.Winehq ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "WINE Config"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.reg"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "WINE Config" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("WINE Config",["Normal"])], synStLanguage = "WINE Config", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "Value" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Section","kw"),("Key","dt"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_WINE_REGISTRY_Version'2e'2a'24 = compileRegex "WINE REGISTRY Version.*$"
regex_'23'5cs'2a'3c'5cs'2awineconf'5cs'2a'3e = compileRegex "#\\s*<\\s*wineconf\\s*>"
regex_'23'5cs'2a'3c'5cs'2a'5c'2f'5cs'2awineconf'5cs'2a'3e = compileRegex "#\\s*<\\s*\\/\\s*wineconf\\s*>"
regex_'5c'5b'2e'2a'5c'5d'24 = compileRegex "\\[.*\\]$"
regex_'3b'2e'2a'24 = compileRegex ";.*$"
regex_'5cs'2a'22'5cs'2a'5ba'2dzA'2dZ0'2d9'5f'2e'3a'2a'5d'2a'5cs'2a'22 = compileRegex "\\s*\"\\s*[a-zA-Z0-9_.:*]*\\s*\""
regex_'5cs'2a'22'2e'2a'22 = compileRegex "\\s*\".*\""

defaultAttributes = [("Normal","Normal Text"),("Value","Normal Text")]

parseRules "Normal" = 
  do (attr, result) <- (((pRegExpr regex_WINE_REGISTRY_Version'2e'2a'24 >>= withAttribute "RegistryBeginEnd"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'23'5cs'2a'3c'5cs'2awineconf'5cs'2a'3e >>= withAttribute "RegistryBeginEnd"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'23'5cs'2a'3c'5cs'2a'5c'2f'5cs'2awineconf'5cs'2a'3e >>= withAttribute "RegistryBeginEnd"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5c'5b'2e'2a'5c'5d'24 >>= withAttribute "Section"))
                        <|>
                        ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute "Comment"))
                        <|>
                        ((pRegExpr regex_'5cs'2a'22'5cs'2a'5ba'2dzA'2dZ0'2d9'5f'2e'3a'2a'5d'2a'5cs'2a'22 >>= withAttribute "Key"))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text") >>~ pushContext "Value"))
     return (attr, result)

parseRules "Value" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'2a'22'2e'2a'22 >>= withAttribute "Value"))
                        <|>
                        ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute "Comment")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
