{- This module was generated from data in the Kate syntax
   highlighting file bibtex.xml, version 1.17, by Jeroen Wijnhout (Jeroen.Wijnhout@kdemail.net)+Thomas Braun (thomas.braun@virtuell-zuhause.de) -}

module Text.Highlighting.Kate.Syntax.Bibtex
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "BibTeX"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.bib"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "BibTeX" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("BibTeX",["Normal"])], synStLanguage = "BibTeX", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "PreambleCommand" -> return ()
    "StringCommand" -> return ()
    "Entry" -> return ()
    "Field" -> return ()
    "CurlyBracket" -> return ()
    "QuotedText" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_kw'5fentry = Set.fromList $ words $ "@article @book @booklet @conference @collection @electronic @inbook @incollection @inproceedings @manual @mastersthesis @misc @online @patent @periodical @proceedings @report @phdthesis @set @thesis @techreport @unpublished @www @person @company @place"

regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b = compileRegex "[a-zA-Z0-9\\-]+"
regex_'5ba'2dzA'2dZ0'2d9'5f'40'5c'5c'2d'5c'5c'3a'5d'2b = compileRegex "[a-zA-Z0-9_@\\\\-\\\\:]+"
regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5c'2e'5d'2b = compileRegex "[a-zA-Z0-9\\-_\\.]+"
regex_'5b0'2d9'5d'2b = compileRegex "[0-9]+"
regex_'2e = compileRegex "."
regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 = compileRegex "\\\\([a-zA-Z@]+|[^ ])"
regex_'7d'24 = compileRegex "}$"

defaultAttributes = [("Normal",CommentTok),("PreambleCommand",NormalTok),("StringCommand",NormalTok),("Entry",NormalTok),("Field",NormalTok),("CurlyBracket",NormalTok),("QuotedText",StringTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~" list_kw'5fentry >>= withAttribute KeywordTok) >>~ pushContext "Entry")
   <|>
   ((pString False "@string" >>= withAttribute FunctionTok) >>~ pushContext "StringCommand")
   <|>
   ((pString False "@preamble" >>= withAttribute FunctionTok) >>~ pushContext "PreambleCommand")
   <|>
   ((pString False "@comment" >>= withAttribute CommentTok)))

parseRules "PreambleCommand" =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "CurlyBracket")
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "StringCommand" =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "CurlyBracket")
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b >>= withAttribute StringTok) >>~ pushContext "CurlyBracket")
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Entry" =
  (((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5f'40'5c'5c'2d'5c'5c'3a'5d'2b >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok) >>~ pushContext "Field")
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext)))

parseRules "Field" =
  (((pFirstNonSpace >> pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5c'2e'5d'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '=' >>= withAttribute NormalTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "CurlyBracket")
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '"' >>= withAttribute NormalTok) >>~ pushContext "QuotedText")
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b >>= withAttribute StringTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute AlertTok)))

parseRules "CurlyBracket" =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "CurlyBracket")
   <|>
   ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'7d'24 >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext)))

parseRules "QuotedText" =
  (((pDetectChar False '"' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 >>= withAttribute CharTok)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
