{- This module was generated from data in the Kate syntax
   highlighting file go.xml, version 1.00, by Miquel Sabaté (mikisabate@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Go
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Go"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.go"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Go" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Go",["normal"])], synStLanguage = "Go", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "normal" -> return ()
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return ()
    "Package" -> (popContext) >> pEndLine
    "String" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "break case chan const continue default defer else fallthrough for func go goto if import interface map range return select struct switch type var"
list_types = Set.fromList $ words $ "bool byte complex64 complex128 float float32 float64 int int8 int16 int32 int64 string uint uint8 uint16 uint32 uint64"
list_builtin = Set.fromList $ words $ "cap len make new panic recover"
list_special = Set.fromList $ words $ "false nil true"


defaultAttributes = [("normal",NormalTok),("Commentar 1",CommentTok),("Commentar 2",CommentTok),("Package",NormalTok),("String",StringTok)]

parseRules "normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_builtin >>= withAttribute OtherTok))
   <|>
   ((pString False "package" >>= withAttribute NormalTok) >>~ pushContext "Package")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Commentar 1")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Commentar 2")
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String"))

parseRules "Commentar 1" =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "Commentar 2" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "Package" =
  pzero

parseRules "String" =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "" = parseRules "normal"

parseRules x = fail $ "Unknown context" ++ x
