{- This module was generated from data in the Kate syntax
   highlighting file ini.xml, version 1.1, by Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.Ini
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "INI Files"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.ini;*.pls;*.kcfgc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "INI Files" }
  context <- currentContext <|> (pushContext "ini" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("INI Files",["ini"])], synStLanguage = "INI Files", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "ini" -> return ()
    "Value" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "on off default defaults localhost null true false yes no normal e_all e_error e_warning e_parse e_notice e_strict e_core_error e_core_warning e_compile_error e_compile_warning e_user_error e_user_warning e_user_notice"

regex_'3b'2e'2a'24 = compileRegex ";.*$"
regex_'23'2e'2a'24 = compileRegex "#.*$"

defaultAttributes = [("ini",DataTypeTok),("Value",StringTok),("Comment",CommentTok)]

parseRules "ini" =
  (((pRangeDetect '[' ']' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Value")
   <|>
   ((pFirstNonSpace >> pDetectChar False ';' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comment"))

parseRules "Value" =
  (((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Comment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "" = parseRules "ini"

parseRules x = fail $ "Unknown context" ++ x
