{- This module was generated from data in the Kate syntax
   highlighting file tcl.xml, version 1.10, by  -}

module Text.Highlighting.Kate.Syntax.Tcl
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Tcl/Tk"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.tcl;*.tk"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Tcl/Tk" }
  context <- currentContext <|> (pushContext "Base" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Tcl/Tk",["Base"])], synStLanguage = "Tcl/Tk", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Base" -> return ()
    "String" -> return ()
    "Comment" -> (popContext) >> pEndLine
    "New command line" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "after append AppleScript argv argc array auto_execk auto_load auto_mkindex auto_path auto_reset beep bell binary bind bindtags bgerror break button canvas case catch cd checkbutton clipboard clock close concat console continue dde destroy else elseif encoding entry env eof error errorCode errorInfo eval event exec exit expr fblocked fconfigure fcopy file fileevent flush focus font for foreach format frame gets glob global grab grid history if image incr info interp join label lappend lindex linsert list listbox llength load lower lrange lreplace lsearch lsort menu menubutton message namespace open option OptProc pack package parray pid place pkg_mkindex proc puts pwd radiobutton raise read regexp registry regsub rename resource return scale scan scrollbar seek selection send set socket source split string subst switch tclLog tcl_endOfWord tcl_findLibrary tcl_library tcl_patchLevel tcl_platform tcl_precision tcl_rcFileName tcl_rcRsrcName tcl_startOfNextWord tcl_startOfPreviousWord tcl_traceCompile tcl_traceExec tcl_version tcl_wordBreakAfter tcl_wordBreakBefore tell text time tk tkTabToWindow tkwait tk_chooseColor tk_chooseDirectory tk_focusFollowMouse tk_focusNext tk_focusPrev tk_getOpenFile tk_getSaveFile tk_library tk_messageBox tk_optionMenu tk_patchLevel tk_popup tk_strictMotif tk_version toplevel trace unknown unset update uplevel upvar variable vwait while winfo wm"
list_keywords'2dopt = Set.fromList $ words $ "add args atime attributes body bytelength cancel channels clicks cmdcount commands compare complete convertfrom convertto copy default delete dirname equal executable exists extension first forget format functions globals hostname idle ifneeded index info is isdirectory isfile join last length level library link loaded locals lstat map match mkdir mtime nameofexecutable names nativename normalize number owned patchlevel pathtype present procs provide range readable readlink remove rename repeat replace require rootname scan script seconds separator sharedlibextension size split stat system tail tclversion tolower totitle toupper trim trimleft trimright type unknown variable vars vcompare vdelete versions vinfo volumes vsatisfies wordend wordstart writable activate actual addtag append appname aspect atom atomname bbox bind broadcast canvasx canvasy caret cells cget children class clear client clone colormapfull colormapwindows command configure containing coords create current curselection dchars debug deiconify delta depth deselect dlineinfo dtag dump edit entrycget entryconfigure families find flash focus focusmodel fpixels fraction frame generate geometry get gettags grid group handle height hide iconbitmap iconify iconmask iconname iconposition iconwindow icursor id identify image insert interps inuse invoke ismapped itemcget itemconfigure keys lower manager mark maxsize measure metrics minsize move name nearest overrideredirect own panecget paneconfigure panes parent pathname pixels pointerx pointerxy pointery positionfrom post postcascade postscript protocol proxy raise release reqheight reqwidth resizable rgb rootx rooty scale scaling screen screencells screendepth screenheight screenmmheight screenmmwidth screenvisual screenwidth search see select selection server set show sizefrom stackorder state status tag title toplevel transient types unpost useinputmethods validate values viewable visual visualid visualsavailable vrootheight vrootwidth vrootx vrooty width window windowingsystem withdraw x xview y"

regex_'23'5cs'2aBEGIN'2e'2a'24 = compileRegex "#\\s*BEGIN.*$"
regex_'23'5cs'2aEND'2e'2a'24 = compileRegex "#\\s*END.*$"
regex_'5c'5c'2e = compileRegex "\\\\."
regex_'5cs'2d'5cw'2b = compileRegex "\\s-\\w+"
regex_'5c'24'5c'7b'28'5b'5e'5c'7d'5d'7c'5c'5c'5c'7d'29'2b'5c'7d = compileRegex "\\$\\{([^\\}]|\\\\\\})+\\}"
regex_'5c'24'28'3a'3a'7c'5cw'29'2b = compileRegex "\\$(::|\\w)+"
regex_'22'7b2'7d = compileRegex "\"{2}"
regex_'22 = compileRegex "\""
regex_'5cs'2a'23 = compileRegex "\\s*#"
regex_'2e = compileRegex "."

defaultAttributes = [("Base",NormalTok),("String",StringTok),("Comment",CommentTok),("New command line",NormalTok)]

parseRules "Base" =
  (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aBEGIN'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aEND'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords'2dopt >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5cs'2d'5cw'2b >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'28'5b'5e'5c'7d'5d'7c'5c'5c'5c'7d'29'2b'5c'7d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'24'28'3a'3a'7c'5cw'29'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'22'7b2'7d >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'22 >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False ';' >>= withAttribute NormalTok) >>~ pushContext "New command line")
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok)))

parseRules "String" =
  (((pRegExpr regex_'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetectChar False '$' >>= withAttribute DataTypeTok)))

parseRules "Comment" =
  pzero

parseRules "New command line" =
  (((pRegExpr regex_'5cs'2a'23 >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((lookAhead (pRegExpr regex_'2e) >> (popContext) >> currentContext >>= parseRules)))

parseRules "" = parseRules "Base"

parseRules x = fail $ "Unknown context" ++ x
