{- This module was generated from data in the Kate syntax
   highlighting file doxygenlua.xml, version 1.01, by Bruno Massa (brmassa@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Doxygenlua
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "DoxygenLua"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.dox;*.doxygen"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("DoxygenLua","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("DoxygenLua","Normal") -> return ()
      ("DoxygenLua","LineComment") -> (popContext) >> pEndLine
      ("DoxygenLua","BlockComment") -> return ()
      ("DoxygenLua","ML_TagWord") -> (popContext) >> pEndLine
      ("DoxygenLua","ML_TagParam") -> (popContext) >> pEndLine
      ("DoxygenLua","ML_TagWordWord") -> (popContext) >> pEndLine
      ("DoxygenLua","ML_Tag2ndWord") -> (popContext >> popContext) >> pEndLine
      ("DoxygenLua","ML_TagString") -> (popContext) >> pEndLine
      ("DoxygenLua","ML_TagWordString") -> (popContext) >> pEndLine
      ("DoxygenLua","ML_htmltag") -> return ()
      ("DoxygenLua","ML_htmlcomment") -> return ()
      ("DoxygenLua","ML_identifiers") -> return ()
      ("DoxygenLua","ML_types1") -> return ()
      ("DoxygenLua","ML_types2") -> return ()
      ("DoxygenLua","SL_TagWord") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_TagParam") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_TagWordWord") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_Tag2ndWord") -> (popContext >> popContext) >> pEndLine
      ("DoxygenLua","SL_TagString") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_TagWordString") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_htmltag") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_htmlcomment") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_identifiers") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_types1") -> (popContext) >> pEndLine
      ("DoxygenLua","SL_types2") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_TagOnly = Set.fromList $ words $ "\\arg \\attention \\author \\callgraph \\code \\dot \\else \\endcode \\endcond \\enddot \\endhtmlonly \\endif \\endlatexonly \\endlink \\endmanonly \\endverbatim \\endxmlonly \\f[ \\f] \\f$ \\hideinitializer \\htmlonly \\interface \\internal \\invariant \\~ \\@ \\$ \\\\ \\# \\latexonly \\li \\manonly \\n \\nosubgrouping \\note \\only \\post \\pre \\remarks \\return \\returns \\sa \\see \\showinitializer \\since \\test \\todo \\verbatim \\warning \\xmlonly @arg @attention @author @callgraph @code @dot @else @endcode @endcond @enddot @endhtmlonly @endif @endlatexonly @endlink @endmanonly @endverbatim @endxmlonly @f[ @f] @f$ @hideinitializer @htmlonly @interface @internal @invariant @~ @@ @$ @\\ @# @latexonly @li @manonly @n @nosubgrouping @note @only @post @pre @remarks @return @returns @sa @see @showinitializer @since @test @todo @verbatim @warning @xmlonly"
list_TagWord = Set.fromList $ words $ "\\addtogroup \\a \\anchor \\b \\c \\class \\cond \\copydoc \\def \\dontinclude \\dotfile \\e \\elseif \\em \\enum \\example \\exception \\exceptions \\file \\htmlinclude \\if \\ifnot \\include \\link \\namespace \\p \\package \\ref \\relatesalso \\relates \\retval \\throw \\throws \\verbinclude \\version \\xrefitem @addtogroup @a @anchor @b @c @class @cond @copydoc @def @dontinclude @dotfile @e @elseif @em @enum @example @exception @exceptions @file @htmlinclude @if @ifnot @include @link @namespace @p @package @ref @relatesalso @relates @retval @throw @throws @verbinclude @version @xrefitem"
list_TagParam = Set.fromList $ words $ "\\param @param"
list_TagWordWord = Set.fromList $ words $ "\\image @image"
list_TagWordString = Set.fromList $ words $ "\\defgroup \\page \\paragraph \\section \\struct \\subsection \\subsubsection \\union \\weakgroup @defgroup @page @paragraph @section @struct @subsection @subsubsection @union @weakgroup"
list_TagString = Set.fromList $ words $ "\\addindex \\brief \\bug \\date \\deprecated \\fn \\ingroup \\line \\mainpage \\name \\overload \\par \\short \\skip \\skipline \\typedef \\until \\var @addindex @brief @bug @date @deprecated @fn @ingroup @line @mainpage @name @overload @par @short @skip @skipline @typedef @until @var"

regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a = compileRegex "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
regex_'5c'5c'28'3c'7c'3e'29 = compileRegex "\\\\(<|>)"
regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 = compileRegex "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
regex_'5cS = compileRegex "\\S"
regex_'2e = compileRegex "."
regex_'5cs'2a'3d'5cs'2a = compileRegex "\\s*=\\s*"
regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a = compileRegex "\\s*#?[a-zA-Z0-9]*"

parseRules ("DoxygenLua","Normal") =
  (((pRegExprDynamic "--\\[(=*)\\[" >>= withAttribute CommentTok) >>~ pushContext ("DoxygenLua","BlockComment"))
   <|>
   ((pString False "--" >>= withAttribute CommentTok) >>~ pushContext ("DoxygenLua","LineComment"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("DoxygenLua","LineComment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagOnly >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWord >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_TagWord"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagParam >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_TagParam"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordWord >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_TagWordWord"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagString >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_TagString"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordString >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_TagWordString"))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("DoxygenLua","SL_htmlcomment"))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_htmltag"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","LineComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","BlockComment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExprDynamic "\\]%1\\]" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '@' '{' >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetect2Chars False '@' '}' >>= withAttribute RegionMarkerTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagOnly >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWord >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_TagWord"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagParam >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_TagParam"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordWord >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_TagWordWord"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagString >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_TagString"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordString >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_TagWordString"))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'3c'7c'3e'29 >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_htmltag"))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("DoxygenLua","ML_htmlcomment"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","BlockComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_TagWord") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("DoxygenLua","SL_TagWord")))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_TagWord")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_TagParam") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "[in]" >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_Tag2ndWord"))
   <|>
   ((pString False "[out]" >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_Tag2ndWord"))
   <|>
   ((pString False "[in,out]" >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_Tag2ndWord"))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_TagParam")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_TagWordWord") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_Tag2ndWord"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_TagWordWord")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_Tag2ndWord") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("DoxygenLua","SL_Tag2ndWord")))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_Tag2ndWord")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_TagString") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("DoxygenLua","ML_htmlcomment"))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","ML_htmltag"))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_TagString")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_TagWordString") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("DoxygenLua","SL_TagWordString")))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_TagWordString")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_htmltag") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("DoxygenLua","ML_identifiers"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_htmltag")) >> pDefault >>= withAttribute OtherTok))

parseRules ("DoxygenLua","ML_htmlcomment") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_htmlcomment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","ML_identifiers") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ pushContext ("DoxygenLua","ML_types1"))
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext ("DoxygenLua","ML_types2"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_identifiers")) >> pDefault >>= withAttribute OtherTok))

parseRules ("DoxygenLua","ML_types1") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_types1")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("DoxygenLua","ML_types2") =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","ML_types2")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("DoxygenLua","SL_TagWord") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((lookAhead (pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWord) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_TagWord")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_TagParam") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "[in]" >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_Tag2ndWord"))
   <|>
   ((pString False "[out]" >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_Tag2ndWord"))
   <|>
   ((pString False "[in,out]" >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_Tag2ndWord"))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_TagParam")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_TagWordWord") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_Tag2ndWord"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_TagWordWord")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_Tag2ndWord") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_Tag2ndWord")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_TagString") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("DoxygenLua","SL_htmlcomment"))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("DoxygenLua","SL_htmltag"))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_TagString")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_TagWordString") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_TagWordString")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_htmltag") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("DoxygenLua","SL_identifiers"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_htmltag")) >> pDefault >>= withAttribute OtherTok))

parseRules ("DoxygenLua","SL_htmlcomment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_htmlcomment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("DoxygenLua","SL_identifiers") =
  (((pRegExpr regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ pushContext ("DoxygenLua","SL_types1"))
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext ("DoxygenLua","SL_types2"))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_identifiers")) >> pDefault >>= withAttribute OtherTok))

parseRules ("DoxygenLua","SL_types1") =
  (((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_types1")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("DoxygenLua","SL_types2") =
  (((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("DoxygenLua","SL_types2")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression

parseRules x = parseRules ("DoxygenLua","Normal") <|> fail ("Unknown context" ++ show x)
