{- This module was generated from data in the Kate syntax
   highlighting file objectivecpp.xml, version 1.01, by Gennady Telegin (gepo@lvk.cs.msu.su -}

module Text.Highlighting.Kate.Syntax.Objectivecpp
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Objective-C++"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.mm;*.M;*.h"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Objective-C++","Default")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Objective-C++","Default") -> return ()
      ("Objective-C++","String") -> (popContext) >> pEndLine
      ("Objective-C++","SingleLineComment") -> (popContext) >> pEndLine
      ("Objective-C++","MultiLineComment") -> return ()
      ("Objective-C++","Preprocessor") -> pushContext ("Objective-C++","Default") >> return ()
      ("Objective-C++","MultiLineCommentPrep") -> return ()
      ("Objective-C++","Region Marker") -> (popContext) >> pEndLine
      ("Objective-C++","Commentar 1") -> (popContext) >> pEndLine
      ("Objective-C++","Commentar 2") -> return ()
      ("Objective-C++","Preprocessor") -> (popContext) >> pEndLine
      ("Objective-C++","Define") -> (popContext) >> pEndLine
      ("Objective-C++","Outscoped") -> return ()
      ("Objective-C++","Outscoped intern") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "break case continue default do else enum extern for goto if return sizeof struct switch typedef union while @class @defs @encode @end @implementation @interface @private @protected @protocol @public @selector self super asm catch class const_cast delete dynamic_cast explicit export false friend inline namespace new operator private protected public qobject_cast reinterpret_cast static_cast template this throw true try typeid type_info typename using virtual and and_eq bad_cast bad_typeid bitand bitor compl not not_eq or or_eq xor xor_eq"
list_extensions = Set.fromList $ words $ "K_DCOP SLOT SIGNAL Q_CLASSINFO Q_ENUMS Q_EXPORT Q_OBJECT Q_OVERRIDE Q_PROPERTY Q_SETS Q_SIGNALS Q_SLOTS Q_FOREACH Q_DECLARE_FLAGS Q_INIT_RESOURCE Q_CLEANUP_RESOURCE Q_GLOBAL_STATIC Q_GLOBAL_STATIC_WITH_ARGS Q_DECLARE_INTERFACE Q_DECLARE_TYPEINFO Q_DECLARE_SHARED Q_DECLARE_FLAGS Q_DECLARE_OPERATORS_FOR_FLAGS Q_FOREVER Q_DECLARE_PRIVATE Q_DECLARE_PUBLIC Q_D Q_Q Q_DISABLE_COPY Q_INTERFACES Q_FLAGS Q_SCRIPTABLE Q_INVOKABLE Q_GADGET Q_ARG Q_RETURN_ARG Q_ASSERT Q_ASSERT_X TRUE FALSE connect disconnect emit signals slots foreach forever"
list_types = Set.fromList $ words $ "auto char const double float int long register short signed static unsigned void volatile bool mutable uchar uint int8_t int16_t int32_t int64_t uint8_t uint16_t uint32_t uint64_t wchar_t"

regex_'23'5cs'2aif'5cs'2b0 = compileRegex "#\\s*if\\s+0"
regex_'23 = compileRegex "#"
regex_define'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex "define.*((?=\\\\))"
regex_define'2e'2a = compileRegex "define.*"
regex_'23'5cs'2aif = compileRegex "#\\s*if"
regex_'23'5cs'2a'28endif'7celse'7celif'29 = compileRegex "#\\s*(endif|else|elif)"
regex_'23'5cs'2aendif = compileRegex "#\\s*endif"

parseRules ("Objective-C++","Default") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0 >>= withAttribute OtherTok) >>~ pushContext ("Objective-C++","Outscoped"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute OtherTok) >>~ pushContext ("Objective-C++","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext ("Objective-C++","Region Marker"))
   <|>
   ((pFirstNonSpace >> pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext ("Objective-C++","Region Marker"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Objective-C++","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","SingleLineComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","MultiLineComment"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'23 >>= withAttribute OtherTok) >>~ pushContext ("Objective-C++","Preprocessor"))
   <|>
   ((pDetect2Chars False '@' '"' >>= withAttribute StringTok) >>~ pushContext ("Objective-C++","String"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extensions >>= withAttribute KeywordTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]{|}~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Default")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Objective-C++","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Objective-C++","SingleLineComment") =
  (currentContext >>= \x -> guard (x == ("Objective-C++","SingleLineComment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Objective-C++","MultiLineComment") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","MultiLineComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Objective-C++","Preprocessor") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute OtherTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","SingleLineComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","MultiLineCommentPrep"))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Preprocessor")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Objective-C++","MultiLineCommentPrep") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","MultiLineCommentPrep")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Objective-C++","Region Marker") =
  (currentContext >>= \x -> guard (x == ("Objective-C++","Region Marker")) >> pDefault >>= withAttribute RegionMarkerTok)

parseRules ("Objective-C++","Commentar 1") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Commentar 1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Objective-C++","Commentar 2") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Objective-C++","Preprocessor") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_define'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute OtherTok) >>~ pushContext ("Objective-C++","Define"))
   <|>
   ((pRegExpr regex_define'2e'2a >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute OtherTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","MultiLineCommentPrep"))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Preprocessor")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Objective-C++","Define") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Define")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Objective-C++","Outscoped") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Objective-C++","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28endif'7celse'7celif'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Outscoped")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Objective-C++","Outscoped intern") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Objective-C++","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Commentar 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("Objective-C++","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C++","Outscoped intern")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Doxygen", _) = Text.Highlighting.Kate.Syntax.Doxygen.parseExpression
parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression

parseRules x = parseRules ("Objective-C++","Default") <|> fail ("Unknown context" ++ show x)
