# $Id: 00default.rb,v 1.5.2.2 2004/06/18 03:47:43 fdiary Exp $
# Copyright (C) 2002-2003 TAKEUCHI Hitoshi <hitoshi@namaraii.com>

#==============================
#  tDiary plugins for Hiki
#==============================
def anchor( s )
  s.sub!(/^\d+$/, '')
  p = @page.escape.escapeHTML
  p.gsub!(/%/, '%%')
  %Q[?#{p}#{s}]
end

def my( a, str )
  %Q[<a href="#{anchor(a).gsub!(/%%/, '%')}">#{str.escapeHTML}</a>]
end

#==============================
#  Hiki default plugins
#==============================
#===== hiki_url
def hiki_url(page)
  "#{$cgi_name}?#{page.escape}"
end

#===== hiki_anchor
def hiki_anchor( page, display_text )
  make_anchor("#{$cgi_name}?#{page}", display_text)
end

#===== make_anchor
def make_anchor(url, display_text)
  %Q!<a href="#{url}">#{display_text}</a>!
end

#===== page_name
def page_name( page )
  pg_title = @db.get_attribute(page, :title)
  ((pg_title && pg_title.size > 0) ? pg_title : page).escapeHTML
end

#===== toc
def toc
  @toc_f = true
end

#===== recent
def recent( n = 20 )
  n = n > 0 ? n : 0

  l = @db.page_info.sort do |a, b|
    b[b.keys[0]][:last_modified] <=> a[a.keys[0]][:last_modified]
  end

  s = ''
  c = 0
  ddd = nil
  
  l.each do |a|
    break if (c += 1) > n
    name = a.keys[0]
    p = a[name]
    
    tm = p[:last_modified ] 
    cur_date = tm.strftime( msg_date_format )

    if ddd != cur_date
      s << "</ul>\n" if ddd
      s << "<h5>#{cur_date}</h5>\n<ul>\n"
      ddd = cur_date
    end
    t = page_name(name)
    an = hiki_anchor(name.escape, t)
    s << "<li>#{an}\n"
  end
  s << "</ul>\n"
  s
end

#===== update_proc
add_update_proc {
  updating_mail if $mail_on_update
}

#----- send a mail on updating
def updating_mail
  begin
    latest_text = @db.load(@page) || ''
    type = (!@db.text or @db.text.size == 0) ? 'create' : 'update'
    text = ''
    text  = "#{@db.text}\n#{'-' * 25}\n" if type == 'update'
    text << "#{latest_text}\n"

    send_updating_mail(@page, type, text)
  rescue
  end
end

#===== hiki_header
add_header_proc {
  hiki_header
}

def hiki_header
  s = <<EOS
  <meta http-equiv="Content-Language" content="#{$lang}">
  <meta http-equiv="Content-Type" content="text/html; charset=#{$charset}">
  <meta name="generator" content="#{$generator}">
  <title>#{$title.escapeHTML}</title>
  <link rel="stylesheet" type="text/css" href="#{base_css_url}" media="all">
  <link rel="stylesheet" type="text/css" href="#{theme_url}" media="all">
EOS
  s << <<EOS if @command != 'view'
  <meta name="ROBOTS" content="NOINDEX,NOFOLLOW"> 
  <meta http-equiv="pragma" content="no-cache">
  <meta http-equiv="cache-control" content="no-cache">
  <meta http-equiv="expires" content="0">
EOS
  s
end

#===== hiki_footer
add_footer_proc {
  hiki_footer
}

def hiki_footer
  <<EOS
Generated by <a href="http://www.namaraii.com/hiki/">Hiki</a> #{HIKI_VERSION}.<br>
Powered by <a href="http://www.ruby-lang.org/">Ruby</a> #{RUBY_VERSION} and
<a href="http://www.brain-tokyo.jp/research/amrita/">Amrita</a>.<br>
Founded by #{$author_name.escapeHTML}.<br>
EOS
end

#===== edit_proc
add_edit_proc {
  hiki_anchor(@page.escape, "[#{page_name(@page)}]")
}

#===== menu
def hiki_menu(data, command)
  menu = []
  editable = %w(view edit diff)

  menu << %Q!<a accesskey="c" href="#{$cgi_name}?c=create">#{msg_create}</a>!
  menu << %Q!<a accesskey="e" href="#{$cgi_name}?c=edit;p=#{@page.escape}">#{msg_edit}</a>! if editable.index(command) && @page
  menu << %Q!<a accesskey="d" href="#{$cgi_name}?c=diff;p=#{@page.escape}">#{msg_diff}</a>! if editable.index(command) && @page
  menu << %Q!#{hiki_anchor( 'FrontPage', page_name('FrontPage') )}!
  menu << %Q!<a accesskey="i" href="#{$cgi_name}?c=index">#{msg_index}</a>!
  menu << %Q!<a accesskey="s" href="#{$cgi_name}?c=search">#{msg_search}</a>!
  menu << %Q!<a accesskey="r" href="#{$cgi_name}?c=recent">#{msg_recent_changes}</a>!
  @plugin_menu.each do |c|
    next if c[:option].has_key?('p') && !editable.index(command)
    cmd =  %Q!<a href="#{$cgi_name}?c=#{c[:command]}!
    c[:option].each do |key, value|
      value = @page.escape if key == 'p'
      cmd << %Q!;#{key}=#{value}!
    end
    cmd << %Q!">#{c[:display_text]}</a>!
    menu << cmd
  end
  menu_proc.each {|i| menu << i}
  menu << %Q!<a accesskey="m" href="#{$cgi_name}?c=admin">#{msg_admin}</a>!

  data[:tools] = menu.collect! {|i| %Q!<span class="adminmenu">#{i}</span>! }.join("&nbsp;\n").sanitize
end
