#include "imgstore.h"
#ifndef __jpegh__
  #include "jpeg.h"
#endif
#ifndef __gifh__
  #include "gif.h"
#endif
#ifndef __pngh__
  #include "png.h"
#endif

#include <cstdio>

map<string,IMGStore::Image> IMGStore::m_imgMap;

bool IMGStore::GetSize(const string& fname,int& width,int& height){
  map<string,Image>::iterator iter=m_imgMap.find(fname);
  if(iter!=m_imgMap.end()){
    width=iter->second.m_width;
    height=iter->second.m_height;
    return iter->second.m_OK;
  }else{
    bool success=false;
    FILE* file=fopen(fname.c_str(),"rb");
    if(file!=NULL){
      success=JPEG::GetSize(file,height,width)||GIF::GetSize(file,height,width)
        ||PNG::GetSize(file,height,width);
      fclose(file);
    }
    m_imgMap[fname]=Image(width,height,success);
    return success;
  }
}
