// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.54 $
#include "hk_form.h"
#include "hk_visible.h"
#include "hk_dsdatavisible.h"
#include "hk_dsgrid.h"
#include "hk_database.h"
#include "hk_dsvisible.h"
#include "hk_dsdatavisible.h"
#include "hk_dslineedit.h"
#include "hk_dsrowselector.h"
#include "hk_dsboolean.h"
#include "hk_dscombobox.h"
#include "hk_dsmemo.h"
#include "hk_button.h"
#include "hk_label.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#define VERSION UNKNOWN
#endif

#ifdef HAVE_SSTREAM
#include <sstream>
#else
#include <strstream.h>
#endif


class hk_formprivate
{
public:
        list<hk_visible*>   p_visibles;

};


hk_form::hk_form(void) : hk_presentation()
{
#ifdef HK_DEBUG
    hkdebug("hk_form::hk_form");
#endif
p_private=new hk_formprivate;
    p_visibletype=hk_visible::form;
    set_designsize(800,600);
    p_presentationtype=hk_presentation::form;
}


hk_form::~hk_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::~hk_form");
#endif
    if (mode()==viewmode) action_on_close();
    p_presentation=NULL;
    clear_visiblelist();
    delete p_private;
#ifdef HK_DEBUG
    hkdebug("hk_form::~hk_form ENDE");
#endif
}




void hk_form::add_visible(hk_visible* v)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::add_visible");
#endif
    if (v==NULL) return;
    register_object(v);
    p_private->p_visibles.insert(p_private->p_visibles.end(),v);

}


void hk_form::remove_visible(hk_visible* v)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::remove_visible");
#endif
    p_private->p_visibles.remove(v);
}


hk_dsgrid*  hk_form::new_grid(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_grid");
#endif
    if (mode()==viewmode)return NULL;
    hk_dsgrid* g = widget_specific_new_grid();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
        g->set_presentationdatasource(presentationdatasource());
//g->set_foregroundcolour(foregroundcolour());
//g->set_backgroundcolour(backgroundcolour());
    }
    return g;
}


hk_dsrowselector*   hk_form::new_rowselector(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_rowselector");
#endif
    if (mode()==viewmode)return NULL;
    hk_dsrowselector* g = widget_specific_new_rowselector();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
        g->set_presentationdatasource(presentationdatasource());
        g->set_foregroundcolour(foregroundcolour());
        g->set_backgroundcolour(backgroundcolour());
    }
    return g;
}


hk_dslineedit*  hk_form::new_lineedit(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_lineedit");
#endif
    if (mode()==viewmode)return NULL;
    hk_dslineedit* g = widget_specific_new_lineedit();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
//g->set_foregroundcolour(foregroundcolour());
//g->set_backgroundcolour(backgroundcolour());
        g->set_presentationdatasource(presentationdatasource());
    }
    return g;
}


hk_dscombobox*  hk_form::new_combobox(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_lineedit");
#endif
    if (mode()==viewmode)return NULL;
    hk_dscombobox* g = widget_specific_new_combobox();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
//g->set_foregroundcolour(foregroundcolour());
//g->set_backgroundcolour(backgroundcolour());
        g->set_presentationdatasource(presentationdatasource());
    }
    return g;
}


hk_dsboolean*   hk_form::new_bool(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_bool");
#endif
    if (mode()==viewmode)return NULL;
    hk_dsboolean* g = widget_specific_new_bool();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
        g->set_foregroundcolour(foregroundcolour());
        g->set_backgroundcolour(backgroundcolour());
        g->set_presentationdatasource(presentationdatasource());
    }
    return g;

}


hk_dsmemo*  hk_form::new_memo(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_memo");
#endif
    if (mode()==viewmode)return NULL;
    hk_dsmemo* g = widget_specific_new_memo();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
        g->set_foregroundcolour(foregroundcolour());
        g->set_backgroundcolour(backgroundcolour());
        g->set_presentationdatasource(presentationdatasource());
    }
    return g;

}


hk_button*  hk_form::new_button(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_button");
#endif
    if (mode()==viewmode)return NULL;
    hk_button* g = widget_specific_new_button();
    if (g!=NULL)
    {
        add_visible(g);
//g->set_foregroundcolour(foregroundcolour());
//g->set_backgroundcolour(backgroundcolour());
        g->set_presentationdatasource(presentationdatasource());
        set_has_changed();
    }
    return g;

}


hk_label*   hk_form::new_label(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::new_label");
#endif
    if (mode()==viewmode)return NULL;
    hk_label* g = widget_specific_new_label();
    if (g!=NULL)
    {
        add_visible(g);
        set_has_changed();
        g->set_foregroundcolour(foregroundcolour());
        g->set_backgroundcolour(backgroundcolour());
    }
    return g;

}


void        hk_form::set_designsize(unsigned int w, unsigned int h,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::set_designsize");
#endif
    hk_presentation::set_designsize(w,h,registerchange);
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        (*it)->set_size((*it)->x(),(*it)->y(),(*it)->width(),(*it)->height(),false);

        it++;
    }

}


/*void 		hk_form::set_formsize(unsigned int w, unsigned int h)
{
#ifdef HK_DEBUG
hkdebug("hk_form::set_formsize");
#endif
 hk_presentation::set_presentationsize(w,h);

 list<hk_visible*>::iterator it=p_private->p_visibles.begin();

 while (it!=p_private->p_visibles.end())
 {
(*it)->widget_specific_form_resizes();
it++;
}

}
*/

void        hk_form::widget_specific_fieldresize(hk_visible* v)
{

}


bool  hk_form::save_form(const hk_string& n,bool ask)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::save_form");
#endif
    if (database()==NULL)
    {
        show_warningmessage(hk_translate("Form error: No database defined!"));
        return false;

    }
    if (n.size()>0) set_name(n);

    reset_has_changed();
    if (name().size()==0) if (!ask_name())return false;
    if (database()->storagemode(ft_form)==hk_database::local)
    {
      ofstream* p_save=database()->savestream(name(),ft_form,ask);
      if (p_save==NULL) return false;
      savedata(*p_save);
      p_save->close();
      delete p_save;
    }
    else
    { // store central
#ifdef HAVE_SSTREAM
       stringstream* p_save;
#else
       strstream*  p_save;
#endif
      p_save=database()->savestringstream(ft_form);
      if (p_save==NULL) return false;
      savedata(*p_save);
      hk_string s=p_save->str();
      database()->save(s,name(),ft_form,ask);
      delete p_save;
    }
    reset_has_changed();
    return true;
}


void hk_form::load_form(const hk_string& n)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::load_form");
#endif
    if (database()==NULL)
    {
        show_warningmessage(hk_translate("Form error: No database defined!"));
        return ;

    }
    if (has_changed())
    {
        save_form();
        reset_has_changed();
    }
    if (n.size()>0) set_name(n);
    enum_mode modebuffer=mode();
    hk_dsmodevisible::set_mode(designmode);
    if (name().size()==0) if (!ask_name())return ;
    hk_string res =database()->load(name(),ft_form);
    if (res.size()==0) show_warningmessage(hk_translate("Bug: form is empty!"));
    if ( res.find("encoding=\"UTF-8\"")<res.size() ) res=u2l(res);

    loaddata(res);
    hk_dsmodevisible::set_mode(modebuffer);
    widget_specific_after_loadform();
    reset_has_changed();

#ifdef HK_DEBUG
    hkdebug("hk_form::load_form ENDE");
#endif

}


void    hk_form::savedata(ostream& s)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::savedata");
#endif
    hk_string ftag="FORM";
    hk_string vistag="FORMOBJECT";
    start_mastertag(s,ftag);
    set_tagvalue(s,"HK_FORMVERSION",(hk_string)VERSION);
//   hk_string datatag="FORMDATA";
//   start_mastertag(s,datatag);
//   hk_dsvisible::savedata(s);
//   end_mastertag(s,datatag);
    hk_presentation::savedata(s);

    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        start_mastertag(s,vistag);
        (*it)->savedata(s);
        end_mastertag(s,vistag);
        it++;
    }

    end_mastertag(s,ftag);
}


void    hk_form::loaddata(const hk_string& definition)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::loaddata");
#endif
    clear_visiblelist();
    hk_string g;
    get_tagvalue(definition,"PRESENTATION",g,1,mastertag);
    hk_presentation::loaddata(g);
    if (get_tagvalue(definition,"FORMDATA",g))
        hk_dsvisible::loaddata(g);                //delete this entry for hk_classes 1.0
    hk_string buffer;
    hk_string buffer2;
    hk_string value;
    long unsigned int b;
// the following 2 lines are for compatibilty reasons to old versions <0.5
    if (get_tagvalue(definition,"FORMDESIGNWIDTH",b))
    {
        unsigned int w=b;
        long unsigned int h=0;
        get_tagvalue(definition,"FORDESIGNHEIGHT",h);
        set_designsize(w,h);
    }
// end compatibility lines
    int i=1;
    while (get_tagvalue(definition,"FORMOBJECT",value,i))
    {
        get_tagvalue(value,"VISIBLETYPE",buffer2);
        hk_visible* vis=new_object(buffer2);
        if (vis!=NULL)
        {
            vis->loaddata(value);
            register_object(vis);
        }
        i++;
    }
}


hk_visible* hk_form::new_object(const hk_string& name)
{
    if (name=="BUTTON") return new_button();
    else
    if (name=="SELECTOR") return new_rowselector();
        else
        if (name=="BOOLEAN") return new_bool();
            else
            if (name=="LINEEDIT") return new_lineedit();
                else
                if (name=="MEMO") return new_memo();
                    else
                    if (name=="COMBOBOX") return new_combobox();
                        else
                        if (name=="GRID") return new_grid();
                            else
                            if (name=="TEXTLABEL") return new_label();

                                return NULL;
}


void hk_form::clear_visiblelist(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::clear_visiblelist()");
#endif
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        hk_visible* v=(*it);
        it++;
//    v->p_form =NULL;
        v->p_presentation = NULL;
        delete v;
    }
#ifdef HK_DEBUG
    hkdebug("hk_form::clear_visiblelist() ENDE");
#endif

}


hk_visible* hk_form::get_visible(long nr)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::get_visible(long)");
#endif
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        if ( (*it)->p_vupn==nr) return (*it);
        it++;
    }
    return NULL;
}

hk_visible* hk_form::get_visible(const hk_string &identifier)
{
#ifdef HK_DEBUG
    hkdebug("hk_form::get_visible(identifier)");
#endif
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        if ( (*it)->identifier()==identifier) return (*it);
        it++;
    }
    return NULL;
}




void hk_form::bulk_operation(enum_bulkoperation bulkoperation)
{
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        switch (bulkoperation)
        {
            case hk_presentation::bulkfont:  (*it)->set_font(font());break;
            case hk_presentation::bulkforeground:  (*it)->set_foregroundcolour(foregroundcolour());break;
            case hk_presentation::bulkbackground:
            {
                switch((*it)->type())
                {
                    case lineedit:;
                    case memo:;
                    case rowselector:;
                    case grid :break;
                    default:(*it)->set_backgroundcolour(backgroundcolour());break;
                }
            }
        }
        ++it;
    }

}


bool    hk_form::set_mode(enum_mode s)
{
    bool res=hk_presentation::set_mode(s);
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    if (s==viewmode) action_on_open();

	while (it!=p_private->p_visibles.end())
        {
	    (*it)->presentationmode_changed();
	    ++it;
        }
    if (s==designmode) action_on_close();
    return res;

}


void hk_form::raise_widget(hk_visible* v)
{
    p_private->p_visibles.remove(v);
    p_private->p_visibles.insert(p_private->p_visibles.end(),v);
}


void hk_form::lower_widget(hk_visible* v)
{
    p_private->p_visibles.remove(v);
    p_private->p_visibles.insert(p_private->p_visibles.begin(),v);

}


list<hk_visible*>*  hk_form::visibles(void)
{
return &(p_private->p_visibles);
}

void hk_form::sizetype_changed(void)
{
    list<hk_visible*>::iterator it=p_private->p_visibles.begin();
    while (it!=p_private->p_visibles.end())
    {
        (*it)->sizetype_changed();
        ++it;
    }
}

