// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.51 $
#include "hk_reportdata.h"
#include "hk_reportsection.h"
#include "hk_report.h"
#include <math.h>
#include "hk_reportutils.h"
#include "hk_column.h"
#include "hk_datasource.h"


class hk_reportdatamodeprivate
{
public:
        hk_string p_data;
        hk_string p_beforedata;
        hk_string p_afterdata;
        hk_string p_displayname;
        bool p_top;
        bool p_left;
        bool p_right;
        bool p_bottom;
        bool p_loru;
        bool p_luro;


};
class hk_reportdataprivate
{
public:
       unsigned long p_count;
        bool p_runningcount;
        bool p_minmax_alreadyset;
        number sum;
        number min;
        number max;
        longnumber squaresum;
        data_replacefunctiontype* p_replacefunction;
        hk_string p_replacefunctionstring;
        reportdatacounttype* p_datacountfunction;
        hk_string p_datacountfunctionstring;
        data_configurefunctiontype* p_dataconfigurefunction;
        hk_string p_dataconfigurefunctionstring;
	hk_string p_on_print_action;
        bool p_wordbreak;

};



hk_reportdata::reportdataconfigurelisttype  hk_reportdata::p_reportdataconfigurefunctions;
list<hk_string> hk_reportdata::p_reportdataconfigurelist;

hk_reportdata::datacountlisttype  hk_reportdata::p_datacountfunctions;
list<hk_string> hk_reportdata::p_datacountfunctionlist;

hk_reportdata::datareplacelisttype  hk_reportdata::p_datareplacefunctions;
list<hk_string> hk_reportdata::p_datareplacefunctionlist;

//********************************************
//**   hk_reportdata                        **
//********************************************

hk_reportdata::hk_reportdata(hk_reportsection* s):hk_dsdatavisible(s->report())
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::hk_reportdata");
#endif
    p_viewdata=new hk_reportdatamodeprivate;
    p_designdata=new hk_reportdatamodeprivate;
    p_private=new hk_reportdataprivate;
    p_visibletype=hk_visible::reportdata;
    p_report=s!=NULL?s->report():NULL;
    set_backgroundcolour(p_report?p_report->backgroundcolour():hk_white,false);
    set_foregroundcolour(p_report?p_report->foregroundcolour():hk_black,false);
    p_section=s;
    p_private->p_count=0;
//  commadigits()=-1;
    p_private->p_runningcount=false;
    p_private->p_minmax_alreadyset=false;
    p_private->p_replacefunction=NULL;
    p_private->p_datacountfunction=NULL;
    p_designdata->p_top=p_designdata->p_bottom=p_designdata->p_left=p_designdata->p_right=p_designdata->p_luro=p_designdata->p_loru=false;
    p_private->p_wordbreak=false;
    set_height(40,false);
    set_width(300,false);
//  wanna_debug(true);
    if (p_reportdataconfigurefunctions.size()==0)
    {
        add_configurefunctiontype("Postscript",&configure_postscriptdata);
        add_configurefunctiontype("None",NULL);
    }

    set_configurefunction("None",false);

    if (p_datacountfunctions.size()==0)
    {
        add_datacountfunctiontype("None",NULL);
    }
    set_datacountfunction("None",false);

    if (p_datareplacefunctions.size()==0)
    {
        add_datareplacefunctiontype("None",NULL);
    }
    set_replacefunction("None",false);
    set_data("%VALUE%",false);

}


hk_reportdata::~hk_reportdata()
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::~hk_reportdata");
#endif
    if (p_section!=NULL) p_section->remove_data(this);
    delete p_private;
    delete p_designdata;
    delete p_viewdata;
}


void hk_reportdata::set_data(const hk_string& d,bool registerchange)
{
    p_viewdata->p_data=d;
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_data=d;
    has_changed(registerchange);
}


hk_string hk_reportdata::data(void)
{
     if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_data;
     else return p_viewdata->p_data;
}


void hk_reportdata::set_beforedata(const hk_string& b,bool registerchange)
{
     if (p_report->mode()==hk_presentation::designmode) p_designdata->p_beforedata=b;
     p_viewdata->p_beforedata=b;
    has_changed(registerchange);
}


void hk_reportdata::set_afterdata(const hk_string& a,bool registerchange)
{
     if (p_report->mode()==hk_presentation::designmode) p_designdata->p_afterdata=a;
     p_viewdata->p_afterdata=a;
    has_changed(registerchange);
}


hk_string hk_reportdata::replace(const hk_string& where)
{
    hk_string p_localbuffer;
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::replace");
#endif
    p_localbuffer=hk_dsdatavisible::replace(where);
    list<hk_column*>* cols=p_report->datasource()->columns();
    list<hk_column*>::iterator it=cols->begin();
    while(it!=cols->end())
    {
        hk_string name="#";
        name+=(*it)->name();
        name+="#";
        if (p_report->recodefunction()==NULL)
            p_localbuffer=replace_all(name,p_localbuffer,(*it)->asstring(true));
        else     p_localbuffer=replace_all(name,p_localbuffer,p_report->recodefunction()((*it)->asstring(true),p_report));
        it++;
    }
    p_localbuffer=replace_all("%XPOS%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(p_section->relativ2horizontal(x())):longint2string(x()));
    p_localbuffer=replace_all("%YPOS%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(p_section->relativ2vertical(y())):longint2string(y()));
    p_localbuffer=replace_all("%WIDTH%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(p_section->relativ2horizontal(width())):longint2string(width()));
    p_localbuffer=replace_all("%HEIGHT%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(p_section->relativ2vertical(height())):longint2string(height()));
    p_localbuffer=replace_all("%RELXPOS%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(x()):longint2string(p_section->horizontal2relativ(x())));
    p_localbuffer=replace_all("%RELYPOS%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(y()):longint2string(p_section->vertical2relativ(y())));
    p_localbuffer=replace_all("%RELWIDTH%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(width()):longint2string(p_section->horizontal2relativ(width())));
    p_localbuffer=replace_all("%RELHEIGHT%",p_localbuffer,p_report->sizetype()==hk_presentation::relative?longint2string(height()):longint2string(p_section->vertical2relativ(height())));
    p_localbuffer=replace_all("%PAGENUMBER%",p_localbuffer,format_number(p_report->pagenumber(),use_numberseparator(),(commadigits()<0?0:commadigits())));
    p_localbuffer=replace_all("%ABSOLUTEPAGENUMBER%",p_localbuffer,format_number(p_report->absolutepagenumber(),use_numberseparator(),(commadigits()<0?0:commadigits())));
    p_localbuffer=replace_all("%ROWNUMBER%",p_localbuffer,format_number(p_report->rownumber(),use_numberseparator(),(commadigits()<0?0:commadigits())));

    hk_string align;
    switch (alignment())
    {
        case alignright : align="RIGHT";break;
        case aligncenter : align="CENTER";break;
        default         : align="LEFT";
    };

    p_localbuffer=replace_all("%ALIGN%",p_localbuffer,align);

    if (column()!=NULL)
    {
        p_localbuffer=replace_all("%value%",p_localbuffer,column()->asstring(true));
        p_localbuffer=replace_all("%fieldname%",p_localbuffer,columnname());
        p_localbuffer=replace_all("%displayname%",p_localbuffer,p_viewdata->p_displayname);
        p_localbuffer=replace_all("%COUNT%",p_localbuffer,format_number(p_private->p_count,use_numberseparator(),(commadigits()<0?0:commadigits())));
        hk_string format="%.3f";
        switch  (column()->columntype())
        {
            case  hk_column::integercolumn: ;
            case hk_column::auto_inccolumn: ;
            case hk_column::smallintegercolumn :
            {
                p_localbuffer=replace_all("%SUM%",p_localbuffer,format_number(p_private->sum.integer,use_numberseparator(),(commadigits()<0?0:commadigits())));
                p_localbuffer=replace_all("%MIN%",p_localbuffer,format_number(p_private->min.integer,use_numberseparator(),(commadigits()<0?0:commadigits())));
                p_localbuffer=replace_all("%MAX%",p_localbuffer,format_number(p_private->max.integer,use_numberseparator(),(commadigits()<0?0:commadigits())));
                if (p_private->p_count>0)
                {
                    double average=(double)p_private->sum.integer/(double)p_private->p_count;
                    p_localbuffer=replace_all("%AVERAGE%",p_localbuffer,format_number(average,use_numberseparator(),commadigits()));
                    double stddev=sqrt((p_private->squaresum.integer-2.0*average*p_private->sum.integer+p_private->p_count*average*average)/p_private->p_count);
                    p_localbuffer=replace_all("%STDDEV%",p_localbuffer,format_number(stddev,use_numberseparator(),commadigits()));
                    stddev=sqrt((p_private->squaresum.integer-2.0*average*p_private->sum.integer+p_private->p_count*average*average)/(p_private->p_count-1));
                    p_localbuffer=replace_all("%STDDEVSAMPLE%",p_localbuffer,format_number(stddev,use_numberseparator(),commadigits()));
                }
            };break;

            case hk_column::floatingcolumn:  ;
            case hk_column::smallfloatingcolumn:
            {
                p_localbuffer=replace_all("%SUM%",p_localbuffer,format_number(p_private->sum.real,use_numberseparator(),commadigits())); cerr <<"sum="<<p_private->sum.real<<endl;
                p_localbuffer=replace_all("%MIN%",p_localbuffer,format_number(p_private->min.real,use_numberseparator(),commadigits()));
                p_localbuffer=replace_all("%MAX%",p_localbuffer,format_number(p_private->max.real,use_numberseparator(),commadigits()));
                if (p_private->p_count>0)
                {
                    double average=p_private->sum.real/(double)p_private->p_count;
                    p_localbuffer=replace_all("%AVERAGE%",p_localbuffer,format_number(average,use_numberseparator(),commadigits()));
                    double stddev=sqrt((p_private->squaresum.real-2*average*p_private->sum.real+p_private->p_count*average*average)/p_private->p_count);
                    p_localbuffer=replace_all("%STDDEV%",p_localbuffer,format_number(stddev,use_numberseparator(),commadigits()));
                    stddev=sqrt((p_private->squaresum.real-2*average*p_private->sum.real+p_private->p_count*average*average)/(p_private->p_count-1));
                    p_localbuffer=replace_all("%STDDEVSAMPLE%",p_localbuffer,format_number(stddev,use_numberseparator(),commadigits()));

                }
                const char* i="?";
                p_localbuffer=replace_all("%AVERAGE%",p_localbuffer,i);
                p_localbuffer=replace_all("%STDDEV%",p_localbuffer,i);
                p_localbuffer=replace_all("%STDDEVSAMPLE%",p_localbuffer,i);
            } break;
            default:;

        }

        if (p_report!=NULL)
        {
            recodefunctiontype* r=p_report->recodefunction();
            hk_string value;
            hk_string name;
            hk_string display;

            if (is_numerictype(column()))
            {
                double n=localestring2double(column()->asstring(true));
                value=format_number(n,use_numberseparator(),commadigits()<0?(is_integertype(column())?0:-1):commadigits());
//                value=format_number(n,use_numberseparator(),is_integertype(column())?(commadigits()<0)?0:commadigits():(commadigits()<0)?-1:commadigits());
            }
            else   value=column()->asstring(true);
            name=columnname();
            display=p_viewdata->p_displayname;

            if (r!=NULL)
            {
                value=r(value,p_report);
                name=r(name,p_report);
                display=r(display,p_report);
            }
            p_localbuffer=replace_all("%VALUE%",p_localbuffer,value);
            p_localbuffer=replace_all("%FIELDNAME%",p_localbuffer,name);
            p_localbuffer=replace_all("%DISPLAYNAME%",p_localbuffer,display);
        }

    }
    p_localbuffer=replace_all("%FONT%",p_localbuffer,font().fontname());
    p_localbuffer=replace_all("%PSFONT%",p_localbuffer,font().psfontname());
    p_localbuffer=replace_all("%FONTSIZE%",p_localbuffer,longint2string(font().fontsize()));
    return p_localbuffer;

}


hk_string hk_reportdata::actual_string(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::actual_string");
#endif
    hk_string r;
    hk_string b;
    if (!action_on_print())
    {
      report()->stop_execution();
      return "";
    }
    r=p_viewdata->p_beforedata+p_viewdata->p_data+p_viewdata->p_afterdata;
    r=replace(r);
    b=r;
    if (p_private->p_replacefunction!=NULL) r=p_private->p_replacefunction(this,r);
    if (p_private->p_datacountfunction!=NULL)set_counts_as(p_private->p_datacountfunction(this));
    p_report->rowcount(counts_as());
    r=b;
    return  r;

}


void hk_reportdata::count(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::count");
#endif
    p_private->p_count++;
    if(column()==0) return;

    switch(column()->columntype())
    {
        case hk_column::integercolumn  :;
        case hk_column::auto_inccolumn :;
        case hk_column::smallintegercolumn:
        {
            hk_string s=column()->asstring(true);
            int r=atoi(s.c_str());
            if (datasource()->row_position()==0)
            {
                p_private->sum.integer=r;
                p_private->squaresum.integer=r*r;
            }
            else
            {
                p_private->sum.integer+=r;
                p_private->squaresum.integer+=r*r;
            }
            if (s.size()>0)
            {
                if (p_private->p_minmax_alreadyset)
                {
                    if (r<p_private->min.integer)p_private->min.integer=r;
                    if (r>p_private->max.integer)p_private->max.integer=r;
                }
                else
                {
                    p_private->min.integer=r;
                    p_private->max.integer=r;
                    p_private->p_minmax_alreadyset=true;
                }
            }

        };break;
        case  hk_column::floatingcolumn:;
        case  hk_column::smallfloatingcolumn:;
        {
             hk_string s=column()->asstring();
           double r=localestring2double(s);
            if (datasource()->row_position()==0)
            {
                p_private->sum.real=r;
                p_private->squaresum.real=r*r;
            }
            else
            {
                p_private->sum.real+=r;
                p_private->squaresum.real+=r*r;
            }
            if (s.size()>0)
            {
                if (p_private->p_minmax_alreadyset)
                {
                    if (r<p_private->min.real)p_private->min.real=r;
                    if (r>p_private->max.real)p_private->max.real=r;
                }
                else
                {
                    p_private->min.real=r;
                    p_private->max.real=r;
                    p_private->p_minmax_alreadyset=true;
                }
            }
        }
        default:;
    }
}


void hk_reportdata::set_runningcount(bool c,bool registerchange)
{
    p_private->p_runningcount=c;
    has_changed(registerchange);
}


bool hk_reportdata::runningcount(void)
{

    return p_private->p_runningcount;
}


void hk_reportdata::set_replacefunction(const hk_string& f,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::set_replacefunction");
#endif
    if (f==p_private->p_replacefunctionstring)return;
    datareplacelisttype::iterator it=p_datareplacefunctions.find(f);
    if (it==p_datareplacefunctions.end())
    {

        show_warningmessage(hk_translate("replacefunction not found"));
        p_private->p_replacefunction=NULL;
        p_private->p_replacefunctionstring="None";
        return;
    }
    data_replacefunctiontype* c=*it->second;

    p_private->p_replacefunction=c;
    p_private->p_replacefunctionstring=f;
    has_changed(registerchange);
}


void hk_reportdata::set_datacountfunction(const hk_string& f,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::set_datacountfunction");
#endif
    if (f==p_private->p_datacountfunctionstring)return;

    datacountlisttype::iterator it=p_datacountfunctions.find(f);
    if (it==p_datacountfunctions.end())
    {

        show_warningmessage(hk_translate("Data Countfunction not found"));
        p_private->p_datacountfunction=NULL;
        p_private->p_datacountfunctionstring="None";
        return;
    }
    reportdatacounttype* c=*it->second;

    p_private->p_datacountfunction=c;
    p_private->p_datacountfunctionstring=f;
    has_changed(registerchange);
}


hk_string hk_reportdata::datacountfunctionstring(void)
{
    return p_private->p_datacountfunctionstring;

}


reportdatacounttype* hk_reportdata::datacountfunction(void)
{

    return p_private->p_datacountfunction;
}


bool    hk_reportdata::diagonalloru(void)
{
        if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_loru;
	else return p_viewdata->p_loru;
}


bool    hk_reportdata::topline(void)
{
        if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_top;
	else return p_viewdata->p_top;
;
}


bool    hk_reportdata::bottomline(void)
{
        if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_bottom;
	else return p_viewdata->p_bottom;

}


bool    hk_reportdata::leftline(void)
{
            if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_left;
	else return p_viewdata->p_left;
}


bool    hk_reportdata::rightline(void)
{
            if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_right;
	else return p_viewdata->p_right;
}


bool    hk_reportdata::diagonalluro(void)
{
            if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_luro;
	else return p_viewdata->p_luro;
}


bool    hk_reportdata::wordbreak(void)
{
    return p_private->p_wordbreak;
}


void hk_reportdata::reset_count()
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::reset_count");
#endif
    if (!p_private->p_runningcount)
    {
      clear_counting();
    }
}

void hk_reportdata::clear_counting(void)
{
        p_private->p_count=0;
        if (column()!=NULL)
            if (column()->columntype()==hk_column::integercolumn||
            column()->columntype()==hk_column::smallintegercolumn||
            column()->columntype()==hk_column::auto_inccolumn)
        {
            p_private->sum.integer=0;
            p_private->squaresum.integer=0;
            p_private->min.integer=0;
            p_private->max.integer=0;
            p_private->p_minmax_alreadyset=false;
        }
        else
        if (column()->columntype()==hk_column::floatingcolumn||
            column()->columntype()==hk_column::smallfloatingcolumn)
        {
            p_private->sum.real=0;
            p_private->squaresum.real=0;
            p_private->min.real=0;
            p_private->max.real=0;
            p_private->p_minmax_alreadyset=false;
        }


}


hk_font hk_reportdata::font(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::font");
#endif
    if (hk_dsdatavisible::font().fontname().size()==0) return p_section->font();
    else return hk_dsdatavisible::font();
}




void    hk_reportdata::set_topline(bool l,bool registerchange)
{
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_top=l;

    p_viewdata->p_top=l;
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


void    hk_reportdata::set_bottomline(bool l,bool registerchange)
{
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_bottom=l;
    p_viewdata->p_bottom=l;

    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);

}


void    hk_reportdata::set_leftline(bool l,bool registerchange)
{
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_left=l;
    p_viewdata->p_left=l;

    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


void    hk_reportdata::set_rightline(bool l,bool registerchange)
{
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_right=l;
    p_viewdata->p_right=l;
    has_changed(registerchange);
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);

}


void    hk_reportdata::set_diagonalluro(bool l,bool registerchange)
{
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_luro=l;
    p_viewdata->p_luro=l;
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


void    hk_reportdata::set_diagonalloru(bool l,bool registerchange)
{
    if (p_report->mode()==hk_presentation::designmode) p_designdata->p_loru=l;
    p_viewdata->p_loru=l;
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


void     hk_reportdata::set_frame(bool l,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::set_frame");
#endif
    if (p_report->mode()==hk_presentation::designmode)
    {
      p_designdata->p_top=l;
      p_designdata->p_left=l;
      p_designdata->p_right=l;
      p_designdata->p_bottom=l;
    }
    p_viewdata->p_top=l;
    p_viewdata->p_bottom=l;
    p_viewdata->p_left=l;
    p_viewdata->p_right=l;
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


void hk_reportdata::set_wordbreak(bool b,bool registerchange)
{
    p_private->p_wordbreak=b;
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


void  hk_reportdata::savedata(ostream& s,bool userdefined)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::savedata");
#endif
    start_mastertag(s,"HK_REPORTDATA");
    hk_dsdatavisible::savedata(s);
    set_tagvalue(s,"DATAVALUE",p_designdata->p_data);
    set_tagvalue(s,"DISPLAYNAME",p_designdata->p_displayname);
    set_tagvalue(s,"TOPBORDER",p_designdata->p_top);
    set_tagvalue(s,"LEFTBORDER",p_designdata->p_left);
    set_tagvalue(s,"RIGHTBORDER",p_designdata->p_right);
    set_tagvalue(s,"BOTTOMBORDER",p_designdata->p_bottom);
    set_tagvalue(s,"DIAGONALLORU",p_designdata->p_loru);
    set_tagvalue(s,"DIAGONALLURO",p_designdata->p_luro);
    set_tagvalue(s,"WORDBREAK",p_private->p_wordbreak);
    set_tagvalue(s,"RUNNINGCOUNT",p_private->p_runningcount);
    set_tagvalue(s,"ONPRINT_ACTION",p_private->p_on_print_action);

    if (userdefined)
    {
        set_tagvalue(s,"BEFOREDATA",p_designdata->p_beforedata);
        set_tagvalue(s,"AFTERDATA",p_designdata->p_afterdata);
        set_tagvalue(s,"DATACONFIGUREFUNCTION",p_private->p_dataconfigurefunctionstring);
        set_tagvalue(s,"DATACOUNTFUNCTION",p_private->p_datacountfunctionstring);
        set_tagvalue(s,"DATAREPLACEFUNCTION",p_private->p_replacefunctionstring);
    }

    end_mastertag(s,"HK_REPORTDATA");

}


void  hk_reportdata::loaddata(const hk_string& definition,bool userdefined)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::loaddata");
#endif
    hk_dsdatavisible::loaddata(definition);
    get_tagvalue(definition,"DATAVALUE",p_designdata->p_data);
    p_viewdata->p_data=p_designdata->p_data;
    hk_string sbuffer;
    if (userdefined)
    {
        get_tagvalue(definition,"BEFOREDATA",p_designdata->p_beforedata);
	p_viewdata->p_beforedata=p_designdata->p_beforedata;
        get_tagvalue(definition,"AFTERDATA",p_designdata->p_afterdata);
	p_viewdata->p_afterdata=p_designdata->p_afterdata;
        if (get_tagvalue(definition,"DATACONFIGUREFUNCTION",sbuffer))
            set_configurefunction(sbuffer);
        if (get_tagvalue(definition,"DATACOUNTFUNCTION",sbuffer))
            set_datacountfunction(sbuffer,false);
        if (get_tagvalue(definition,"DATAREPLACEFUNCTION",sbuffer))
            set_replacefunction(sbuffer);

    }
    get_tagvalue(definition,"DISPLAYNAME",p_designdata->p_displayname);
    get_tagvalue(definition,"TOPBORDER",p_designdata->p_top);
    p_viewdata->p_top=p_designdata->p_top;
    get_tagvalue(definition,"LEFTBORDER",p_designdata->p_left);
    p_viewdata->p_left=p_designdata->p_left;
    get_tagvalue(definition,"RIGHTBORDER",p_designdata->p_right);
    p_viewdata->p_right=p_designdata->p_right;
    get_tagvalue(definition,"BOTTOMBORDER",p_designdata->p_bottom);
    p_viewdata->p_bottom=p_designdata->p_bottom;
    get_tagvalue(definition,"DIAGONALLORU",p_designdata->p_loru);
    p_viewdata->p_loru=p_designdata->p_loru;
    get_tagvalue(definition,"DIAGONALLURO",p_designdata->p_luro);
    p_viewdata->p_luro=p_designdata->p_luro;
    get_tagvalue(definition,"WORDBREAK",p_private->p_wordbreak);
    get_tagvalue(definition,"RUNNINGCOUNT",p_private->p_runningcount);
    get_tagvalue(definition,"ONPRINT_ACTION",p_private->p_on_print_action);

    hk_string configurefunc;
    get_tagvalue(definition,"DATACONFIGUREFUNCTION",configurefunc);
    if  (configurefunc=="POSTSCRIPT") p_private->p_dataconfigurefunction=&configure_postscriptdata;
    if(p_private->p_dataconfigurefunction!=NULL)p_private->p_dataconfigurefunction(this);
}


void    hk_reportdata::set_configurefunction(const hk_string& f,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::set_configurefunction");
#endif

    if (f==p_private->p_dataconfigurefunctionstring)return;

    reportdataconfigurelisttype::iterator it=p_reportdataconfigurefunctions.find(f);
    if (it==p_reportdataconfigurefunctions.end())
    {

        show_warningmessage(hk_translate("Dataconfigurefunction not found"));
        p_private->p_dataconfigurefunction=NULL;
        p_private->p_dataconfigurefunctionstring="None";
        return;
    }

    data_configurefunctiontype* rf=*it->second;
    p_private->p_dataconfigurefunction=rf;
    p_private->p_dataconfigurefunctionstring=f;
    if (p_private->p_dataconfigurefunction!=NULL) p_private->p_dataconfigurefunction(this);
    has_changed(registerchange);
}


data_configurefunctiontype* hk_reportdata::configurefunction(void)
{
    return p_private->p_dataconfigurefunction;
}


hk_string hk_reportdata::configurefunctionstring(void)
{
    return p_private->p_dataconfigurefunctionstring;
}


void    hk_reportdata::neutralize_definition(bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_reportdata::neutralize_definition");
#endif
    set_beforedata("",registerchange);
    set_afterdata("",registerchange);
    set_replacefunction("None",registerchange);
    set_datacountfunction("None",registerchange);
    set_configurefunction("None",registerchange);

}


void hk_reportdata::add_configurefunctiontype(const hk_string& name,data_configurefunctiontype* f)
{
    if (name.size()==0) return;
    typedef reportdataconfigurelisttype::value_type recodevalue;
    p_reportdataconfigurefunctions.insert(recodevalue(name,f));
    p_reportdataconfigurelist.insert(p_reportdataconfigurelist.end(),name);

}


list<hk_string>* hk_reportdata::configurefunctionlist(void)
{
    return &p_reportdataconfigurelist;
}


void hk_reportdata::add_datacountfunctiontype(const hk_string& name,reportdatacounttype* f)
{

    if (name.size()==0) return;
    typedef datacountlisttype::value_type datacountvalue;
    p_datacountfunctions.insert(datacountvalue(name,f));
    p_datacountfunctionlist.insert(p_datacountfunctionlist.end(),name);
}


list<hk_string>* hk_reportdata::datacountfunctionlist(void)
{
    return &p_datacountfunctionlist;
}


void hk_reportdata::add_datareplacefunctiontype(const hk_string& name,data_replacefunctiontype* f)
{
    if (name.size()==0) return;
    typedef datareplacelisttype::value_type datareplacevalue;
    p_datareplacefunctions.insert(datareplacevalue(name,f));
    p_datareplacefunctionlist.insert(p_datareplacefunctionlist.end(),name);
}


list<hk_string>* hk_reportdata::datareplacefunctionlist(void)
{
    return &p_datareplacefunctionlist;
}


hk_report* hk_reportdata::report(void)
{
    return p_report;
}


hk_reportsection* hk_reportdata::section(void)
{
    return p_section;
}


void hk_reportdata::new_column_pointer_created(void)
{
    hk_column* col=column();
    if (col)
    {
        if (is_integertype(col)) {p_private->sum.integer=0;p_private->min.integer=0;p_private->max.integer=0;p_private->squaresum.integer=0;}
        else if (is_realtype(col)){p_private->sum.real=0;p_private->min.real=0;p_private->max.real=0;p_private->squaresum.real=0;}
    }

}


void hk_reportdata::lower_widget(bool registerchange)
{
    if (p_section) p_section->lower_widget(this);
    has_changed(registerchange);
    widget_specific_lower_widget();
}


void hk_reportdata::raise_widget(bool registerchange)
{
    if (p_section) p_section->raise_widget(this);
    has_changed(registerchange);
    widget_specific_raise_widget();

}


void hk_reportdata::sizetype_changed(void)
{
 if (!p_report) return;

p_setwidgetcoordinates=true;
 if (p_report->sizetype()==hk_presentation::relative)
  {
// this means previous sizetype was hk_presentation::absolute
// and changed now to hk_presentation::relative

   set_size(p_section->horizontal2relativ(x()),
   		p_section->vertical2relativ(y()),
		p_section->horizontal2relativ(width()),
		p_section->vertical2relativ(height()),
		false
		);


  }
else
  {
// this means previous sizetype was hk_presentation::relative
// and changed now to hk_presentation::absolute

   set_size(p_section->relativ2horizontal(x()),
   		p_section->relativ2vertical(y()),
		p_section->relativ2horizontal(width()),
		p_section->relativ2vertical(height()),
		false
		);

  }
p_setwidgetcoordinates=false;
}


void hk_reportdata::presentationmode_changed(void)
{
hk_dsdatavisible::presentationmode_changed();
    if (p_report->mode()==hk_presentation::viewmode)
    {
        p_viewdata->p_data=p_designdata->p_data;
        p_viewdata->p_beforedata=p_designdata->p_beforedata;
        p_viewdata->p_afterdata=p_designdata->p_afterdata;
        p_viewdata->p_displayname=p_designdata->p_displayname;
	p_viewdata->p_top=p_designdata->p_top;
	p_viewdata->p_bottom=p_designdata->p_bottom;
	p_viewdata->p_left=p_designdata->p_left;
	p_viewdata->p_right=p_designdata->p_right;
	p_viewdata->p_luro=p_designdata->p_luro;
	p_viewdata->p_loru=p_designdata->p_loru;
   }
}


void hk_reportdata::set_on_print_action(const hk_string& a,bool registerchange)
{
 p_private->p_on_print_action=a;
 has_changed(registerchange);
}

hk_string hk_reportdata::on_print_action(void)
{
return p_private->p_on_print_action;
}

bool hk_reportdata::action_on_print(void)
{
if (p_private->p_on_print_action.size()==0) return true;
 if (!p_report)return false;
	return p_report->interpreter()->on_print_data(this);
}


hk_string hk_reportdata::beforedata()
{
     if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_beforedata;
     else return p_viewdata->p_beforedata;
}

hk_string hk_reportdata::afterdata()
{
     if (p_report->mode()==hk_presentation::designmode) return p_designdata->p_afterdata;
     else return p_viewdata->p_afterdata;
}


