/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 240
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct {int value; int mask;} yy13;
  struct TrigEvent yy132;
  IdList* yy160;
  Expr* yy178;
  int yy230;
  Select* yy239;
  TriggerStep* yy247;
  struct LimitVal yy270;
  SrcList* yy285;
  Expr * yy292;
  Token yy384;
  struct LikeOp yy440;
  ExprList* yy462;
  int yy479;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 560
#define YYNRULE 295
#define YYERRORSYMBOL 137
#define YYERRSYMDT yy479
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   279,   68,  283,   70,  148,  166,  546,  419,   62,   62,
 /*    10 */    62,   62,  202,   64,   64,   64,   64,   65,   65,   66,
 /*    20 */    66,   66,   67,   67,  548,  549,  432,   69,   64,   64,
 /*    30 */    64,   64,   65,   65,   66,   66,   66,   67,   68,  454,
 /*    40 */    70,  148,  499,   61,   59,  287,  440,  441,  437,  437,
 /*    50 */    63,   63,   62,   62,   62,   62,  501,   64,   64,   64,
 /*    60 */    64,   65,   65,   66,   66,   66,   67,  279,  371,  283,
 /*    70 */   419,    2,  377,   80,  158,  115,  220,  304,  225,  305,
 /*    80 */   170,  245,  856,  119,  559,  504,  204,    2,  246,  389,
 /*    90 */   496,  219,   22,  432,  514,   21,  419,   58,  493,  171,
 /*   100 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   110 */    61,   59,  287,  440,  441,  437,  437,   63,   63,   62,
 /*   120 */    62,   62,   62,  512,   64,   64,   64,   64,   65,   65,
 /*   130 */    66,   66,   66,   67,  279,  378,  379,  175,  202,  377,
 /*   140 */   330,  333,  334,  220,  304,  225,  305,  170,  245,  203,
 /*   150 */   146,  357,  335,  281,  377,  246,   55,  301,  373,  419,
 /*   160 */   432,  505,   92,  200,  530,   66,   66,   66,   67,  525,
 /*   170 */   192,   65,   65,   66,   66,   66,   67,   61,   59,  287,
 /*   180 */   440,  441,  437,  437,   63,   63,   62,   62,   62,   62,
 /*   190 */   433,   64,   64,   64,   64,   65,   65,   66,   66,   66,
 /*   200 */    67,  279,  378,  379,  411,  431,  110,  226,  427,  205,
 /*   210 */   435,  436,  308,  358,  261,  260,  175,  378,  379,  330,
 /*   220 */   333,  334,  372,  369,  202,  511,  480,  432,  547,  362,
 /*   230 */   466,  335,  510,  500,  410,   41,  276,  414,  434,  429,
 /*   240 */   503,  162,  233,  527,   61,   59,  287,  440,  441,  437,
 /*   250 */   437,   63,   63,   62,   62,   62,   62,  319,   64,   64,
 /*   260 */    64,   64,   65,   65,   66,   66,   66,   67,  279,  472,
 /*   270 */   416,  416,  416,  308,  322,  236,  308,   68,  308,   70,
 /*   280 */   148,    1,  308,  793,  308,  377,   68,  153,   70,  148,
 /*   290 */   149,  377,  325,  282,  432,  410,   35,  551,  410,   35,
 /*   300 */   410,   36,  427,  205,  410,   35,  410,   35,  286,  422,
 /*   310 */   423,   61,   59,  287,  440,  441,  437,  437,   63,   63,
 /*   320 */    62,   62,   62,   62,  411,   64,   64,   64,   64,   65,
 /*   330 */    65,   66,   66,   66,   67,  308,  504,  466,  290,  255,
 /*   340 */   279,  324,  485,  147,  237,  388,   21,  288,  378,  379,
 /*   350 */   451,  419,  232,  451,  378,  379,  308,  410,   28,  451,
 /*   360 */   175,  450,  486,  330,  333,  334,  432,  215,  347,  145,
 /*   370 */   513,  204,  350,  186,  168,  335,  238,  411,  410,   41,
 /*   380 */   256,  462,   76,   61,   59,  287,  440,  441,  437,  437,
 /*   390 */    63,   63,   62,   62,   62,   62,  309,   64,   64,   64,
 /*   400 */    64,   65,   65,   66,   66,   66,   67,  411,  411,  186,
 /*   410 */   396,  308,  279,  291,  419,  338,  476,  308,  390,  234,
 /*   420 */   169,  154,  397,  475,  396,  327,  493,  311,  422,  423,
 /*   430 */   444,  377,  356,  410,   49,  398,  397,  394,  432,  410,
 /*   440 */    49,  502,  171,  411,  429,  312,  162,  395,  351,  398,
 /*   450 */   497,  318,  470,  352,   79,   61,   59,  287,  440,  441,
 /*   460 */   437,  437,   63,   63,   62,   62,   62,   62,  356,   64,
 /*   470 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  279,
 /*   480 */   298,  445,  376,  479,  532,  405,  299,   11,  504,  352,
 /*   490 */   204,  377,  406,  377,  378,  379,  281,  556,   21,  491,
 /*   500 */   491,  246,  560,  372,  369,  432,  392,  393,  314,  123,
 /*   510 */   443,  443,  166,  289,  419,  314,  116,  443,  443,  251,
 /*   520 */   264,  463,   61,   59,  287,  440,  441,  437,  437,   63,
 /*   530 */    63,   62,   62,   62,   62,  292,   64,   64,   64,   64,
 /*   540 */    65,   65,   66,   66,   66,   67,  279,  459,  328,  474,
 /*   550 */   498,  308,  202,  308,  378,  379,  378,  379,  181,  131,
 /*   560 */   179,  265,  308,    5,  308,  363,  314,  355,  443,  443,
 /*   570 */   410,    3,  432,  410,   29,  410,   24,  419,  243,  244,
 /*   580 */   380,  381,  382,  404,  410,   33,  410,   54,  466,   61,
 /*   590 */    59,  287,  440,  441,  437,  437,   63,   63,   62,   62,
 /*   600 */    62,   62,  308,   64,   64,   64,   64,   65,   65,   66,
 /*   610 */    66,   66,   67,  279,  521,  344,  521,  249,  308,  491,
 /*   620 */   308,  470,  308,  470,  410,   25,  308,  240,  308,  314,
 /*   630 */   308,  443,  443,  213,  172,  173,  174,  142,  266,  432,
 /*   640 */   410,   52,  410,   97,  410,   94,  528,  393,  410,   99,
 /*   650 */   410,  100,  410,  111,  212,  255,   61,   59,  287,  440,
 /*   660 */   441,  437,  437,   63,   63,   62,   62,   62,   62,  308,
 /*   670 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   680 */   279,  308,  345,  188,  297,   91,  308,  491,  308,  415,
 /*   690 */   308,  410,  112,  308,  428,  308,  537,  308,  244,  165,
 /*   700 */   154,  409,  355,  410,   18,  408,  432,  320,  410,   98,
 /*   710 */   410,   34,  410,   95,  313,  410,   53,  410,  113,  410,
 /*   720 */   114,  255,  293,   61,   59,  287,  440,  441,  437,  437,
 /*   730 */    63,   63,   62,   62,   62,   62,  308,   64,   64,   64,
 /*   740 */    64,   65,   65,   66,   66,   66,   67,  279,  308,  491,
 /*   750 */   491,  523,  308,  452,  308,  522,  308,  461,  410,   26,
 /*   760 */   308,   75,  539,   77,  308,  460,  244,  346,  214,  465,
 /*   770 */   410,   37,  469,  432,  410,   38,  410,   27,  410,   39,
 /*   780 */   242,   82,  410,   40,  294,  296,  410,   42,  438,  329,
 /*   790 */    61,   59,  287,  440,  441,  437,  437,   63,   63,   62,
 /*   800 */    62,   62,   62,  308,   64,   64,   64,   64,   65,   65,
 /*   810 */    66,   66,   66,   67,  279,  308,  409,  190,  221,  308,
 /*   820 */   408,  308,  152,  308,  159,  410,   43,  308,  244,  244,
 /*   830 */   222,   20,  308,  139,  425,  425,  481,  410,   44,  482,
 /*   840 */   432,  410,   30,  410,   31,  410,   45,  487,  461,  410,
 /*   850 */    46,  411,  506,  255,  410,   47,  488,   61,   71,  287,
 /*   860 */   440,  441,  437,  437,   63,   63,   62,   62,   62,   62,
 /*   870 */   308,   64,   64,   64,   64,   65,   65,   66,   66,   66,
 /*   880 */    67,  279,  308,  401,  402,  250,  308,  193,  308,  420,
 /*   890 */   308,   23,  410,   48,  540,  449,  255,   14,  468,  477,
 /*   900 */   167,   14,  484,  483,  410,   32,  252,  432,  410,   12,
 /*   910 */   410,   50,  410,   51,  255,  255,  594,  255,  255,  150,
 /*   920 */   489,  411,  123,  253,  279,   59,  287,  440,  441,  437,
 /*   930 */   437,   63,   63,   62,   62,   62,   62,  541,   64,   64,
 /*   940 */    64,   64,   65,   65,   66,   66,   66,   67,  254,  248,
 /*   950 */   432,  123,  337,  411,  123,  267,  269,  196,  361,  366,
 /*   960 */   183,  177,  180,  519,  520,  526,  534,  123,  167,  287,
 /*   970 */   440,  441,  437,  437,   63,   63,   62,   62,   62,   62,
 /*   980 */   342,   64,   64,   64,   64,   65,   65,   66,   66,   66,
 /*   990 */    67,   72,  315,  259,    4,  411,  411,  535,  285,   89,
 /*  1000 */   544,  349,   89,  353,  354,   19,  310,   72,  315,  368,
 /*  1010 */     4,  386,  262,  263,  285,  223,  545,  270,  364,  273,
 /*  1020 */   274,  141,  310,  317,  227,  316,  555,  424,  426,  480,
 /*  1030 */   455,  458,  490,  431,  332,  492,  533,  157,  543,  317,
 /*  1040 */   375,  383,  384,  385,    8,  302,  303,  391,  284,  431,
 /*  1050 */   404,  399,   74,   73,  224,  403,  407,   82,  323,  321,
 /*  1060 */    72,  306,  307,  400,  231,  414,   81,  206,   74,   73,
 /*  1070 */   473,   57,   78,  164,  453,  412,   72,  306,  307,   72,
 /*  1080 */   315,  414,    4,  228,  202,  229,  285,  235,  230,  456,
 /*  1090 */   457,  413,  207,  120,  310,   83,  326,  102,  416,  416,
 /*  1100 */   416,  417,  418,   13,  239,  495,  467,  241,  277,  208,
 /*  1110 */   471,  317,  494,  210,  416,  416,  416,  417,  418,   13,
 /*  1120 */   211,  431,  156,  278,  339,  507,  508,  216,  217,  218,
 /*  1130 */   106,  509,  515,  178,  343,   84,  341,  182,  517,  456,
 /*  1140 */    74,   73,   86,  198,  518,  271,  257,  184,   72,  306,
 /*  1150 */   307,  348,  272,  414,  118,  529,  187,  127,  536,  359,
 /*  1160 */   128,  136,  129,  542,  195,  130,  530,  133,  300,  552,
 /*  1170 */   553,  194,  137,  197,  431,   90,  554,  557,   96,  209,
 /*  1180 */   101,  374,  387,  117,  201,   56,  416,  416,  416,  417,
 /*  1190 */   418,   13,   93,  143,  144,  595,  596,  109,  160,  161,
 /*  1200 */    60,  439,  500,  421,  430,  442,  414,  138,  446,  151,
 /*  1210 */     6,  447,  155,  448,  163,  360,  268,  260,   15,    7,
 /*  1220 */    14,  280,  121,  464,  122,  478,  202,  103,  104,  331,
 /*  1230 */   247,   85,  105,  336,  222,  176,  340,  140,  516,  416,
 /*  1240 */   416,  416,  124,  295,  125,  167,  524,  258,  107,  185,
 /*  1250 */   365,    9,  531,   10,  126,  189,   16,  538,  191,  132,
 /*  1260 */   134,   87,   88,  135,   17,  108,  275,  550,  367,  199,
 /*  1270 */   370,  536,  558,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  216,   16,  218,  219,   21,  146,   23,   68,   69,
 /*    10 */    70,   71,  109,   73,   74,   75,   76,   77,   78,   79,
 /*    20 */    80,   81,   82,   82,  164,  165,   42,   72,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,  216,  217,
 /*    40 */   218,  219,  168,   59,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,  168,   73,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   16,  140,   16,
 /*    70 */    86,  143,   23,   22,   88,   89,   90,   91,   92,   93,
 /*    80 */    94,   95,  138,  139,  140,  146,  226,  143,  102,  166,
 /*    90 */   167,  152,   19,   42,  155,  156,   23,   46,  175,   43,
 /*   100 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   120 */    69,   70,   71,  180,   73,   74,   75,   76,   77,   78,
 /*   130 */    79,   80,   81,   82,   16,   86,   87,   88,  109,   23,
 /*   140 */    91,   92,   93,   90,   91,   92,   93,   94,   95,  191,
 /*   150 */    22,  122,  103,   97,   23,  102,  198,  141,  142,   86,
 /*   160 */    42,  180,   44,  147,   49,   79,   80,   81,   82,   18,
 /*   170 */   154,   77,   78,   79,   80,   81,   82,   59,   60,   61,
 /*   180 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   190 */    42,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   200 */    82,   16,   86,   87,  188,   58,   21,  189,   77,   78,
 /*   210 */    62,   63,  146,   98,   99,  100,   88,   86,   87,   91,
 /*   220 */    92,   93,    1,    2,  109,  175,  176,   42,   97,  213,
 /*   230 */   160,  103,  182,   86,  168,  169,  157,   90,   90,  160,
 /*   240 */   161,  162,  146,   92,   59,   60,   61,   62,   63,   64,
 /*   250 */    65,   66,   67,   68,   69,   70,   71,  185,   73,   74,
 /*   260 */    75,   76,   77,   78,   79,   80,   81,   82,   16,  199,
 /*   270 */   123,  124,  125,  146,  208,  209,  146,  216,  146,  218,
 /*   280 */   219,   19,  146,  132,  146,   23,  216,  146,  218,  219,
 /*   290 */   154,   23,  146,  149,   42,  168,  169,  236,  168,  169,
 /*   300 */   168,  169,   77,   78,  168,  169,  168,  169,  163,  164,
 /*   310 */   165,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   320 */    68,   69,   70,   71,  188,   73,   74,   75,   76,   77,
 /*   330 */    78,   79,   80,   81,   82,  146,  146,  160,  211,  146,
 /*   340 */    16,  211,   30,  154,  146,  155,  156,  211,   86,   87,
 /*   350 */   223,   23,  220,  223,   86,   87,  146,  168,  169,  223,
 /*   360 */    88,  223,   50,   91,   92,   93,   42,  144,  224,  179,
 /*   370 */   180,  226,  228,  154,  154,  103,  199,  188,  168,  169,
 /*   380 */   187,  113,  130,   59,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,  146,   73,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,  188,  188,  154,
 /*   410 */    12,  146,   16,  101,   86,   16,   20,  146,  167,  209,
 /*   420 */   200,  201,   24,   20,   12,  205,  175,  163,  164,  165,
 /*   430 */    20,   23,  213,  168,  169,   37,   24,   39,   42,  168,
 /*   440 */   169,  159,   43,  188,  160,  161,  162,   49,  229,   37,
 /*   450 */   168,   39,  146,  234,  130,   59,   60,   61,   62,   63,
 /*   460 */    64,   65,   66,   67,   68,   69,   70,   71,  213,   73,
 /*   470 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   16,
 /*   480 */   215,   20,  146,   20,  229,   27,  215,   19,  146,  234,
 /*   490 */   226,   23,   34,   23,   86,   87,   97,  155,  156,  146,
 /*   500 */   146,  102,    0,    1,    2,   42,  184,  185,  105,   22,
 /*   510 */   107,  108,   21,  207,   23,  105,  146,  107,  108,   14,
 /*   520 */    14,  113,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   530 */    67,   68,   69,   70,   71,  181,   73,   74,   75,   76,
 /*   540 */    77,   78,   79,   80,   81,   82,   16,   22,  146,   79,
 /*   550 */    20,  146,  109,  146,   86,   87,   86,   87,   53,   53,
 /*   560 */    55,   55,  146,  190,  146,  122,  105,  146,  107,  108,
 /*   570 */   168,  169,   42,  168,  169,  168,  169,   86,  225,  225,
 /*   580 */     7,    8,    9,   96,  168,  169,  168,  169,  160,   59,
 /*   590 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,  146,   73,   74,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   16,   98,   99,  100,   20,  146,  146,
 /*   620 */   146,  146,  146,  146,  168,  169,  146,  199,  146,  105,
 /*   630 */   146,  107,  108,  212,   98,   99,  100,  112,  132,   42,
 /*   640 */   168,  169,  168,  169,  168,  169,  184,  185,  168,  169,
 /*   650 */   168,  169,  168,  169,  181,  146,   59,   60,   61,   62,
 /*   660 */    63,   64,   65,   66,   67,   68,   69,   70,   71,  146,
 /*   670 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   680 */    16,  146,  207,   22,  207,   21,  146,  146,  146,  146,
 /*   690 */   146,  168,  169,  146,  160,  146,  187,  146,  225,  200,
 /*   700 */   201,  106,  146,  168,  169,  110,   42,  146,  168,  169,
 /*   710 */   168,  169,  168,  169,   16,  168,  169,  168,  169,  168,
 /*   720 */   169,  146,  181,   59,   60,   61,   62,   63,   64,   65,
 /*   730 */    66,   67,   68,   69,   70,   71,  146,   73,   74,   75,
 /*   740 */    76,   77,   78,   79,   80,   81,   82,   16,  146,  146,
 /*   750 */   146,   25,  146,  146,  146,   29,  146,   22,  168,  169,
 /*   760 */   146,  129,  187,  131,  146,  202,  225,   41,  212,  146,
 /*   770 */   168,  169,  146,   42,  168,  169,  168,  169,  168,  169,
 /*   780 */   146,  120,  168,  169,  181,  181,  168,  169,   90,   79,
 /*   790 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   800 */    69,   70,   71,  146,   73,   74,   75,   76,   77,   78,
 /*   810 */    79,   80,   81,   82,   16,  146,  106,  154,   90,  146,
 /*   820 */   110,  146,   87,  146,   19,  168,  169,  146,  225,  225,
 /*   830 */   102,   19,  146,   21,  123,  124,  146,  168,  169,  177,
 /*   840 */    42,  168,  169,  168,  169,  168,  169,  177,  113,  168,
 /*   850 */   169,  188,  146,  146,  168,  169,  177,   59,   60,   61,
 /*   860 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   870 */   146,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   880 */    82,   16,  146,    7,    8,  146,  146,  154,  146,   20,
 /*   890 */   146,   22,  168,  169,  187,   20,  146,   22,   20,   20,
 /*   900 */    22,   22,   89,   90,  168,  169,  146,   42,  168,  169,
 /*   910 */   168,  169,  168,  169,  146,  146,  111,  146,  146,  154,
 /*   920 */    20,  188,   22,  146,   16,   60,   61,   62,   63,   64,
 /*   930 */    65,   66,   67,   68,   69,   70,   71,  187,   73,   74,
 /*   940 */    75,   76,   77,   78,   79,   80,   81,   82,  146,   20,
 /*   950 */    42,   22,   20,  188,   22,  187,  187,   19,  187,  187,
 /*   960 */   230,  154,  154,   51,   52,   20,   20,   22,   22,   61,
 /*   970 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   980 */   231,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   990 */    82,   16,   17,  146,   19,  188,  188,   20,   23,   22,
 /*  1000 */    20,  146,   22,  146,  146,   67,   31,   16,   17,  237,
 /*  1010 */    19,  148,  146,  146,   23,  171,  146,  146,  146,  146,
 /*  1020 */   146,  190,   31,   48,  192,  222,  146,  227,  227,  176,
 /*  1030 */   171,  171,  171,   58,  172,  171,  193,    6,  193,   48,
 /*  1040 */   145,  145,  145,  145,   22,  153,   97,  170,   40,   58,
 /*  1050 */    96,  170,   77,   78,  170,  172,  170,  120,  117,  115,
 /*  1060 */    85,   86,   87,  178,  196,   90,  118,  221,   77,   78,
 /*  1070 */    79,  119,  129,  111,  151,  188,   85,   86,   87,   16,
 /*  1080 */    17,   90,   19,  193,  109,  194,   23,   95,  195,   23,
 /*  1090 */   159,  197,  210,  151,   31,   97,  114,   19,  123,  124,
 /*  1100 */   125,  126,  127,  128,  203,  178,  204,  203,  173,  210,
 /*  1110 */   204,   48,  159,  210,  123,  124,  125,  126,  127,  128,
 /*  1120 */   210,   58,    5,  173,   15,  170,  170,   10,   11,   12,
 /*  1130 */    13,  170,  151,  150,   38,   19,  151,  151,  151,   23,
 /*  1140 */    77,   78,  129,   26,  233,   28,  232,  150,   85,   86,
 /*  1150 */    87,  151,   35,   90,   59,  183,  183,   19,  193,   15,
 /*  1160 */   186,  214,  186,  193,   47,  186,   49,  183,  151,   33,
 /*  1170 */   151,   54,  214,   56,   58,  235,  151,  136,  158,  174,
 /*  1180 */   174,    1,   20,   32,   44,   19,  123,  124,  125,  126,
 /*  1190 */   127,  128,  235,   77,   78,  111,  111,  238,  111,  111,
 /*  1200 */    19,   90,   86,   20,   20,  106,   90,   19,   11,   19,
 /*  1210 */   116,   20,  111,   20,   22,   98,   99,  100,   22,  116,
 /*  1220 */    22,  104,   19,  113,   20,   20,  109,   19,   19,   44,
 /*  1230 */    20,   19,   19,   44,  102,   94,   16,   21,   17,  123,
 /*  1240 */   124,  125,   97,   36,   45,   22,   45,  132,   19,   97,
 /*  1250 */   133,    5,   11,    1,  101,  121,   19,   17,  112,  112,
 /*  1260 */   101,   67,   67,  121,   19,   14,  135,   20,   57,  134,
 /*  1270 */     3,  239,    4,
};
#define YY_SHIFT_USE_DFLT (-98)
#define YY_SHIFT_MAX 370
static const short yy_shift_ofst[] = {
 /*     0 */   221,  975, 1117,  -16,  975, 1063, 1063, 1063,   49,  115,
 /*    10 */   115,  -97,  118, 1063, 1063, 1063, 1063, 1063,  -45,  131,
 /*    20 */   116,  328,  225,  225,   51,  185,  252,  324,  396,  463,
 /*    30 */   530,  597,  664,  731,  798,  731,  731,  731,  731,  731,
 /*    40 */   731,  731,  731,  731,  731,  731,  731,  731,  731,  731,
 /*    50 */   731,  731,  865,  908,  908,  991, 1063, 1063, 1063, 1063,
 /*    60 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*    70 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*    80 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*    90 */  1063, 1063, 1063, 1063,  -60,  -60,  -14,   27,   27,   94,
 /*   100 */    86,  399,  116,  116,  116,  116,  151,  116,  116,  116,
 /*   110 */   328,  -59,  -98,  -98,  -98, 1116,   53,  398,  398,  502,
 /*   120 */   491,  116,  491,  116,  116,  116,  116,  116,  116,  116,
 /*   130 */   116,  116,  116,  116,  116,  116,   29,  443,  -97,  -97,
 /*   140 */   -97,  -98,  -98,  147,  147,  128,  272,  403,  262,  410,
 /*   150 */   461,  412,  268,  408,  468,  470,  573,  116,  116,  710,
 /*   160 */   116,  116,   73,  116,  116,  735,  116,  116,  524,  735,
 /*   170 */   116,  116,  312,  312,  312,  116,  116,  524,  116,  116,
 /*   180 */   524,  116,  726,  516,  116,  116,  524,  116,  116,  116,
 /*   190 */   524,  116,  524,  524,  116,  116,  116,  116,  116,  116,
 /*   200 */   812,  458,  595,  525,  711,  711,  632,  458,  458,   56,
 /*   210 */   458,  458,  487,  661,  661, 1031, 1031, 1031, 1031, 1022,
 /*   220 */   949,  949, 1008,  949,  954,  949,  -97,  937,  941,  948,
 /*   230 */   944,  952,  943,  962,  992, 1066,  992,  962,  998,  982,
 /*   240 */   998,  982, 1078,  992,  992, 1066, 1008,  949,  949,  949,
 /*   250 */  1078, 1109,  962,  962,  962,  962, 1096, 1013, 1109,  962,
 /*   260 */  1095, 1095, 1138,  937, 1144, 1144, 1144,  937, 1095, 1138,
 /*   270 */   962, 1136, 1136,  962,  962, 1041,  -98,  -98,  -98,  148,
 /*   280 */   506,  536,  505,  728,  876,  805,  869,  698,  875,  878,
 /*   290 */   879,  813,  900,  929,  932,  912,  945,  946,  977,  980,
 /*   300 */   938, 1180, 1162, 1151, 1140, 1166, 1084, 1085, 1087, 1088,
 /*   310 */  1181, 1183, 1184, 1111, 1099, 1188, 1197, 1190, 1191, 1192,
 /*   320 */  1193, 1094, 1196, 1103, 1198, 1110, 1203, 1204, 1101, 1205,
 /*   330 */  1185, 1208, 1210, 1209, 1212, 1189, 1213, 1141, 1132, 1220,
 /*   340 */  1221, 1216, 1145, 1207, 1199, 1223, 1201, 1115, 1152, 1229,
 /*   350 */  1246, 1241, 1252, 1153, 1194, 1195, 1134, 1237, 1146, 1240,
 /*   360 */  1147, 1159, 1142, 1245, 1247, 1251, 1211, 1135, 1131, 1267,
 /*   370 */  1268,
};
#define YY_REDUCE_USE_DFLT (-216)
#define YY_REDUCE_MAX 278
static const short yy_reduce_ofst[] = {
 /*     0 */   -56,  136,   16,   70,  189,  127,   66,  130,  190,  219,
 /*    10 */   255,  220,   61,  132,  138,  210,  265,  271, -178, -140,
 /*    20 */   -61,   79,  145,  264, -215, -215, -215, -215, -215, -215,
 /*    30 */  -215, -215, -215, -215, -215, -215, -215, -215, -215, -215,
 /*    40 */  -215, -215, -215, -215, -215, -215, -215, -215, -215, -215,
 /*    50 */  -215, -215, -215, -215, -215,  402,  405,  407,  416,  418,
 /*    60 */   456,  472,  474,  476,  480,  482,  484,  523,  535,  540,
 /*    70 */   542,  544,  547,  549,  551,  590,  602,  606,  608,  610,
 /*    80 */   614,  618,  657,  669,  673,  675,  677,  681,  686,  724,
 /*    90 */   736,  740,  742,  744, -215, -215,  -77, -215, -215, -215,
 /*   100 */  -215,   50,  354,  473,  541,  603,  144,  604,  772,  342,
 /*   110 */   284, -215, -215, -215, -215,  282,  251,  322,  462,  -72,
 /*   120 */   177,  306,  428,  353,  193,  475,  421,  477,  509,  575,
 /*   130 */   707,  750,  768,  771,  556,  769,  663,  733,  765,  807,
 /*   140 */   808,  -42,  499, -126, -112,  -57,  -19,   18,   96,   18,
 /*   150 */    18,   72,  141,  146,  198,  250,  223,  336,  370,  373,
 /*   160 */   250,  543,  534,  561,  607,  563,  623,  626,   18,  563,
 /*   170 */   634,  690,  662,  670,  679,  706,  739,   18,  760,  777,
 /*   180 */    18,  802,  730,  749,  847,  855,   18,  857,  858,  866,
 /*   190 */    18,  867,   18,   18,  870,  871,  872,  873,  874,  880,
 /*   200 */   863,  844,  831,  832,  800,  801,  803,  859,  860,  853,
 /*   210 */   861,  864,  862,  843,  845,  895,  896,  897,  898,  892,
 /*   220 */   877,  881,  885,  884,  883,  886,  887,  890,  891,  893,
 /*   230 */   868,  894,  846,  923,  882,  931,  899,  942,  901,  902,
 /*   240 */   904,  906,  935,  903,  910,  953,  927,  955,  956,  961,
 /*   250 */   950,  983,  981,  985,  986,  987,  914,  911,  997, 1000,
 /*   260 */   972,  973,  947,  965,  974,  976,  979,  970,  984,  958,
 /*   270 */  1017,  940,  957, 1019, 1025,  959, 1020, 1005, 1006,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   566,  790,  855,  681,  855,  790,  855,  790,  855,  828,
 /*    10 */   828,  685,  841,  786,  790,  855,  855,  855,  761,  812,
 /*    20 */   855,  597,  812,  812,  716,  855,  855,  855,  855,  855,
 /*    30 */   855,  855,  855,  717,  855,  789,  785,  781,  783,  782,
 /*    40 */   718,  705,  714,  721,  697,  826,  723,  724,  729,  730,
 /*    50 */   842,  845,  751,  767,  750,  855,  855,  855,  855,  855,
 /*    60 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*    70 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*    80 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*    90 */   855,  855,  855,  855,  753,  772,  590,  752,  760,  754,
 /*   100 */   755,  650,  855,  855,  855,  855,  585,  855,  855,  855,
 /*   110 */   855,  756,  757,  768,  769,  855,  855,  855,  855,  566,
 /*   120 */   681,  855,  681,  855,  855,  855,  855,  855,  855,  855,
 /*   130 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*   140 */   855,  675,  685,  855,  855,  641,  855,  855,  855,  855,
 /*   150 */   855,  855,  855,  855,  855,  855,  573,  571,  855,  673,
 /*   160 */   855,  855,  599,  855,  855,  683,  855,  855,  688,  689,
 /*   170 */   855,  855,  855,  855,  855,  855,  855,  587,  855,  855,
 /*   180 */   662,  855,  818,  855,  855,  855,  833,  855,  855,  855,
 /*   190 */   831,  855,  664,  726,  800,  855,  855,  846,  848,  855,
 /*   200 */   855,  708,  673,  682,  855,  855,  784,  708,  708,  620,
 /*   210 */   708,  708,  623,  720,  720,  570,  570,  570,  570,  640,
 /*   220 */   652,  652,  637,  652,  623,  652,  855,  720,  711,  713,
 /*   230 */   701,  715,  855,  690,  709,  855,  709,  690,  698,  700,
 /*   240 */   698,  700,  794,  709,  709,  855,  637,  652,  652,  652,
 /*   250 */   794,  582,  690,  690,  690,  690,  822,  825,  582,  690,
 /*   260 */   654,  654,  731,  720,  661,  661,  661,  720,  654,  731,
 /*   270 */   690,  844,  844,  690,  690,  853,  607,  625,  625,  855,
 /*   280 */   855,  855,  855,  855,  855,  738,  855,  855,  855,  855,
 /*   290 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*   300 */   807,  855,  855,  855,  855,  855,  743,  739,  855,  740,
 /*   310 */   855,  855,  855,  855,  667,  855,  855,  855,  855,  855,
 /*   320 */   855,  855,  702,  855,  712,  855,  855,  855,  855,  855,
 /*   330 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*   340 */   855,  855,  855,  855,  820,  821,  855,  855,  855,  855,
 /*   350 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*   360 */   855,  855,  855,  855,  855,  855,  852,  855,  855,  567,
 /*   370 */   855,  561,  564,  563,  565,  569,  572,  594,  595,  596,
 /*   380 */   574,  575,  576,  577,  578,  579,  580,  586,  588,  606,
 /*   390 */   608,  615,  653,  656,  657,  658,  836,  837,  838,  616,
 /*   400 */   635,  638,  639,  617,  624,  706,  707,  618,  671,  672,
 /*   410 */   735,  665,  666,  670,  737,  741,  742,  744,  745,  593,
 /*   420 */   600,  601,  604,  605,  808,  810,  809,  811,  603,  602,
 /*   430 */   746,  749,  758,  759,  765,  771,  774,  763,  764,  766,
 /*   440 */   770,  773,  668,  669,  777,  779,  780,  834,  835,  775,
 /*   450 */   787,  788,  691,  778,  762,  703,  592,  710,  704,  674,
 /*   460 */   684,  693,  694,  695,  696,  679,  680,  686,  699,  733,
 /*   470 */   734,  687,  676,  677,  678,  776,  736,  747,  748,  619,
 /*   480 */   626,  627,  628,  631,  632,  633,  634,  629,  630,  795,
 /*   490 */   796,  798,  797,  621,  622,  636,  609,  610,  611,  612,
 /*   500 */   743,  613,  614,  598,  591,  642,  645,  646,  647,  648,
 /*   510 */   649,  651,  643,  644,  589,  581,  583,  692,  814,  823,
 /*   520 */   824,  819,  815,  816,  817,  584,  791,  792,  655,  727,
 /*   530 */   728,  813,  827,  829,  732,  830,  832,  659,  660,  663,
 /*   540 */   799,  839,  719,  722,  725,  801,  802,  803,  804,  805,
 /*   550 */   806,  840,  843,  847,  849,  850,  851,  854,  568,  562,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "REINDEX",       "RENAME",        "CTIME_KW",      "OR",          
  "AND",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "COLLATE",     
  "AUTOINCR",      "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "EXCEPT",      
  "INTERSECT",     "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "INTEGER",     
  "FLOAT",         "BLOB",          "REGISTER",      "VARIABLE",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "INDEX",         "ALTER",         "TO",            "ADD",         
  "COLUMNKW",      "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "ifnotexists",   "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "carg",          "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tcons",         "idxlist",       "defer_subclause_opt",  "orconf",      
  "resolvetype",   "raisetype",     "ifexists",      "fullname",    
  "oneselect",     "multiselect_op",  "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "sclp",          "as",          
  "seltablist",    "stl_prefix",    "joinop",        "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "inscollist",  
  "sortlist",      "sortitem",      "collate",       "exprlist",    
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "likeop",        "escape",        "between_op",    "in_op",       
  "case_operand",  "case_exprlist",  "case_else",     "expritem",    
  "uniqueflag",    "idxitem",       "plus_opt",      "number",      
  "trigger_decl",  "trigger_cmd_list",  "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd",   "database_kw_opt",
  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "insert_cmd ::= INSERT orconf",
 /* 168 */ "insert_cmd ::= REPLACE",
 /* 169 */ "itemlist ::= itemlist COMMA expr",
 /* 170 */ "itemlist ::= expr",
 /* 171 */ "inscollist_opt ::=",
 /* 172 */ "inscollist_opt ::= LP inscollist RP",
 /* 173 */ "inscollist ::= inscollist COMMA nm",
 /* 174 */ "inscollist ::= nm",
 /* 175 */ "expr ::= term",
 /* 176 */ "expr ::= LP expr RP",
 /* 177 */ "term ::= NULL",
 /* 178 */ "expr ::= ID",
 /* 179 */ "expr ::= JOIN_KW",
 /* 180 */ "expr ::= nm DOT nm",
 /* 181 */ "expr ::= nm DOT nm DOT nm",
 /* 182 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 183 */ "term ::= STRING",
 /* 184 */ "expr ::= REGISTER",
 /* 185 */ "expr ::= VARIABLE",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "escape ::= ESCAPE expr",
 /* 201 */ "escape ::=",
 /* 202 */ "expr ::= expr likeop expr escape",
 /* 203 */ "expr ::= expr ISNULL|NOTNULL",
 /* 204 */ "expr ::= expr IS NULL",
 /* 205 */ "expr ::= expr NOT NULL",
 /* 206 */ "expr ::= expr IS NOT NULL",
 /* 207 */ "expr ::= NOT|BITNOT expr",
 /* 208 */ "expr ::= MINUS expr",
 /* 209 */ "expr ::= PLUS expr",
 /* 210 */ "between_op ::= BETWEEN",
 /* 211 */ "between_op ::= NOT BETWEEN",
 /* 212 */ "expr ::= expr between_op expr AND expr",
 /* 213 */ "in_op ::= IN",
 /* 214 */ "in_op ::= NOT IN",
 /* 215 */ "expr ::= expr in_op LP exprlist RP",
 /* 216 */ "expr ::= LP select RP",
 /* 217 */ "expr ::= expr in_op LP select RP",
 /* 218 */ "expr ::= expr in_op nm dbnm",
 /* 219 */ "expr ::= EXISTS LP select RP",
 /* 220 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 221 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 222 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 223 */ "case_else ::= ELSE expr",
 /* 224 */ "case_else ::=",
 /* 225 */ "case_operand ::= expr",
 /* 226 */ "case_operand ::=",
 /* 227 */ "exprlist ::= exprlist COMMA expritem",
 /* 228 */ "exprlist ::= expritem",
 /* 229 */ "expritem ::= expr",
 /* 230 */ "expritem ::=",
 /* 231 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 232 */ "uniqueflag ::= UNIQUE",
 /* 233 */ "uniqueflag ::=",
 /* 234 */ "idxlist_opt ::=",
 /* 235 */ "idxlist_opt ::= LP idxlist RP",
 /* 236 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 237 */ "idxlist ::= idxitem collate sortorder",
 /* 238 */ "idxitem ::= nm",
 /* 239 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 240 */ "cmd ::= VACUUM",
 /* 241 */ "cmd ::= VACUUM nm",
 /* 242 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 243 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 244 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 246 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 247 */ "cmd ::= PRAGMA nm dbnm",
 /* 248 */ "plus_num ::= plus_opt number",
 /* 249 */ "minus_num ::= MINUS number",
 /* 250 */ "number ::= INTEGER|FLOAT",
 /* 251 */ "plus_opt ::= PLUS",
 /* 252 */ "plus_opt ::=",
 /* 253 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 254 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 255 */ "trigger_time ::= BEFORE",
 /* 256 */ "trigger_time ::= AFTER",
 /* 257 */ "trigger_time ::= INSTEAD OF",
 /* 258 */ "trigger_time ::=",
 /* 259 */ "trigger_event ::= DELETE|INSERT",
 /* 260 */ "trigger_event ::= UPDATE",
 /* 261 */ "trigger_event ::= UPDATE OF inscollist",
 /* 262 */ "foreach_clause ::=",
 /* 263 */ "foreach_clause ::= FOR EACH ROW",
 /* 264 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 265 */ "when_clause ::=",
 /* 266 */ "when_clause ::= WHEN expr",
 /* 267 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 268 */ "trigger_cmd_list ::=",
 /* 269 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 270 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 271 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 272 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 273 */ "trigger_cmd ::= select",
 /* 274 */ "expr ::= RAISE LP IGNORE RP",
 /* 275 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 276 */ "raisetype ::= ROLLBACK",
 /* 277 */ "raisetype ::= ABORT",
 /* 278 */ "raisetype ::= FAIL",
 /* 279 */ "cmd ::= DROP TRIGGER fullname",
 /* 280 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 281 */ "key_opt ::=",
 /* 282 */ "key_opt ::= KEY expr",
 /* 283 */ "database_kw_opt ::= DATABASE",
 /* 284 */ "database_kw_opt ::=",
 /* 285 */ "cmd ::= DETACH database_kw_opt expr",
 /* 286 */ "cmd ::= REINDEX",
 /* 287 */ "cmd ::= REINDEX nm dbnm",
 /* 288 */ "cmd ::= ANALYZE",
 /* 289 */ "cmd ::= ANALYZE nm dbnm",
 /* 290 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 291 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 292 */ "add_column_fullname ::= fullname",
 /* 293 */ "kwcolumn_opt ::=",
 /* 294 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 154:
    case 188:
    case 205:
#line 368 "parse.y"
{sqlite3SelectDelete((yypminor->yy239));}
#line 1216 "parse.c"
      break;
    case 168:
    case 169:
    case 193:
    case 195:
    case 203:
    case 209:
    case 217:
    case 220:
    case 222:
    case 223:
    case 233:
#line 625 "parse.y"
{sqlite3ExprDelete((yypminor->yy178));}
#line 1231 "parse.c"
      break;
    case 173:
    case 181:
    case 191:
    case 194:
    case 196:
    case 198:
    case 208:
    case 211:
    case 212:
    case 215:
    case 221:
#line 855 "parse.y"
{sqlite3ExprListDelete((yypminor->yy462));}
#line 1246 "parse.c"
      break;
    case 187:
    case 192:
    case 200:
    case 201:
#line 496 "parse.y"
{sqlite3SrcListDelete((yypminor->yy285));}
#line 1254 "parse.c"
      break;
    case 197:
#line 557 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy270).pLimit);
  sqlite3ExprDelete((yypminor->yy270).pOffset);
}
#line 1262 "parse.c"
      break;
    case 204:
    case 207:
    case 214:
#line 513 "parse.y"
{sqlite3IdListDelete((yypminor->yy160));}
#line 1269 "parse.c"
      break;
    case 229:
    case 234:
#line 949 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy247));}
#line 1275 "parse.c"
      break;
    case 231:
#line 933 "parse.y"
{sqlite3IdListDelete((yypminor->yy132).b);}
#line 1280 "parse.c"
      break;
    case 236:
#line 1008 "parse.y"
{sqlite3ExprDelete((yypminor->yy292));}
#line 1285 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 138, 1 },
  { 139, 2 },
  { 139, 1 },
  { 141, 1 },
  { 140, 1 },
  { 140, 3 },
  { 143, 0 },
  { 143, 1 },
  { 143, 3 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 2 },
  { 144, 0 },
  { 144, 1 },
  { 144, 1 },
  { 144, 1 },
  { 142, 2 },
  { 142, 2 },
  { 142, 2 },
  { 142, 2 },
  { 147, 6 },
  { 150, 0 },
  { 150, 3 },
  { 149, 1 },
  { 149, 0 },
  { 148, 4 },
  { 148, 2 },
  { 152, 3 },
  { 152, 1 },
  { 155, 3 },
  { 156, 1 },
  { 159, 1 },
  { 160, 1 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 157, 0 },
  { 157, 1 },
  { 161, 1 },
  { 161, 4 },
  { 161, 6 },
  { 162, 1 },
  { 162, 2 },
  { 163, 1 },
  { 163, 1 },
  { 158, 2 },
  { 158, 0 },
  { 166, 3 },
  { 166, 1 },
  { 166, 2 },
  { 166, 4 },
  { 166, 3 },
  { 166, 3 },
  { 166, 2 },
  { 167, 2 },
  { 167, 3 },
  { 167, 5 },
  { 167, 2 },
  { 167, 4 },
  { 167, 4 },
  { 167, 1 },
  { 167, 2 },
  { 172, 0 },
  { 172, 1 },
  { 174, 0 },
  { 174, 2 },
  { 176, 2 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 1 },
  { 177, 1 },
  { 175, 3 },
  { 175, 2 },
  { 178, 0 },
  { 178, 2 },
  { 178, 2 },
  { 153, 0 },
  { 153, 2 },
  { 179, 3 },
  { 179, 2 },
  { 179, 1 },
  { 180, 2 },
  { 180, 7 },
  { 180, 5 },
  { 180, 5 },
  { 180, 10 },
  { 182, 0 },
  { 182, 1 },
  { 170, 0 },
  { 170, 3 },
  { 183, 0 },
  { 183, 2 },
  { 184, 1 },
  { 184, 1 },
  { 184, 1 },
  { 142, 4 },
  { 186, 2 },
  { 186, 0 },
  { 142, 7 },
  { 142, 4 },
  { 142, 1 },
  { 154, 1 },
  { 154, 3 },
  { 189, 1 },
  { 189, 2 },
  { 189, 1 },
  { 188, 9 },
  { 190, 1 },
  { 190, 1 },
  { 190, 0 },
  { 198, 2 },
  { 198, 0 },
  { 191, 3 },
  { 191, 2 },
  { 191, 4 },
  { 199, 2 },
  { 199, 1 },
  { 199, 0 },
  { 192, 0 },
  { 192, 2 },
  { 201, 2 },
  { 201, 0 },
  { 200, 6 },
  { 200, 7 },
  { 205, 1 },
  { 205, 1 },
  { 151, 0 },
  { 151, 2 },
  { 187, 2 },
  { 202, 1 },
  { 202, 2 },
  { 202, 3 },
  { 202, 4 },
  { 203, 2 },
  { 203, 0 },
  { 204, 4 },
  { 204, 0 },
  { 196, 0 },
  { 196, 3 },
  { 208, 5 },
  { 208, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 0 },
  { 210, 0 },
  { 210, 2 },
  { 194, 0 },
  { 194, 3 },
  { 195, 0 },
  { 195, 2 },
  { 197, 0 },
  { 197, 2 },
  { 197, 4 },
  { 197, 4 },
  { 142, 4 },
  { 193, 0 },
  { 193, 2 },
  { 142, 6 },
  { 212, 5 },
  { 212, 3 },
  { 142, 8 },
  { 142, 5 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 207, 3 },
  { 207, 1 },
  { 169, 1 },
  { 169, 3 },
  { 168, 1 },
  { 169, 1 },
  { 169, 1 },
  { 169, 3 },
  { 169, 5 },
  { 168, 1 },
  { 168, 1 },
  { 169, 1 },
  { 169, 1 },
  { 169, 6 },
  { 169, 5 },
  { 169, 4 },
  { 168, 1 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 216, 1 },
  { 216, 2 },
  { 217, 2 },
  { 217, 0 },
  { 169, 4 },
  { 169, 2 },
  { 169, 3 },
  { 169, 3 },
  { 169, 4 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 218, 1 },
  { 218, 2 },
  { 169, 5 },
  { 219, 1 },
  { 219, 2 },
  { 169, 5 },
  { 169, 3 },
  { 169, 5 },
  { 169, 4 },
  { 169, 4 },
  { 169, 5 },
  { 221, 5 },
  { 221, 4 },
  { 222, 2 },
  { 222, 0 },
  { 220, 1 },
  { 220, 0 },
  { 211, 3 },
  { 211, 1 },
  { 223, 1 },
  { 223, 0 },
  { 142, 11 },
  { 224, 1 },
  { 224, 0 },
  { 173, 0 },
  { 173, 3 },
  { 181, 5 },
  { 181, 3 },
  { 225, 1 },
  { 142, 4 },
  { 142, 1 },
  { 142, 2 },
  { 142, 5 },
  { 142, 5 },
  { 142, 5 },
  { 142, 5 },
  { 142, 6 },
  { 142, 3 },
  { 164, 2 },
  { 165, 2 },
  { 227, 1 },
  { 226, 1 },
  { 226, 0 },
  { 142, 5 },
  { 228, 10 },
  { 230, 1 },
  { 230, 1 },
  { 230, 2 },
  { 230, 0 },
  { 231, 1 },
  { 231, 1 },
  { 231, 3 },
  { 232, 0 },
  { 232, 3 },
  { 232, 3 },
  { 233, 0 },
  { 233, 2 },
  { 229, 3 },
  { 229, 0 },
  { 234, 6 },
  { 234, 8 },
  { 234, 5 },
  { 234, 4 },
  { 234, 1 },
  { 169, 4 },
  { 169, 6 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 142, 3 },
  { 142, 6 },
  { 236, 0 },
  { 236, 2 },
  { 235, 1 },
  { 235, 0 },
  { 142, 3 },
  { 142, 1 },
  { 142, 3 },
  { 142, 1 },
  { 142, 3 },
  { 142, 6 },
  { 142, 6 },
  { 237, 1 },
  { 238, 0 },
  { 238, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 95 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1805 "parse.c"
        break;
      case 6:
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1810 "parse.c"
        break;
      case 7:
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1815 "parse.c"
        break;
      case 8:
#line 101 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1820 "parse.c"
        break;
      case 9:
#line 107 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy230);}
#line 1825 "parse.c"
        break;
      case 13:
#line 112 "parse.y"
{yygotominor.yy230 = TK_DEFERRED;}
#line 1830 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 113 "parse.y"
{yygotominor.yy230 = yymsp[0].major;}
#line 1839 "parse.c"
        break;
      case 17:
      case 18:
#line 116 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1845 "parse.c"
        break;
      case 19:
#line 118 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1850 "parse.c"
        break;
      case 21:
#line 123 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-5].minor.yy0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384,yymsp[-4].minor.yy230,0,yymsp[-2].minor.yy230);
}
#line 1857 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 210:
      case 213:
#line 127 "parse.y"
{yygotominor.yy230 = 0;}
#line 1872 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 211:
      case 214:
#line 128 "parse.y"
{yygotominor.yy230 = 1;}
#line 1884 "parse.c"
        break;
      case 26:
#line 134 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy0,0);
}
#line 1891 "parse.c"
        break;
      case 27:
#line 137 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy239);
  sqlite3SelectDelete(yymsp[0].minor.yy239);
}
#line 1899 "parse.c"
        break;
      case 30:
#line 149 "parse.y"
{
  yygotominor.yy384.z = yymsp[-2].minor.yy384.z;
  yygotominor.yy384.n = (pParse->sLastToken.z-yymsp[-2].minor.yy384.z) + pParse->sLastToken.n;
}
#line 1907 "parse.c"
        break;
      case 31:
#line 153 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy384);
  yygotominor.yy384 = yymsp[0].minor.yy384;
}
#line 1915 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 250:
#line 163 "parse.y"
{yygotominor.yy384 = yymsp[0].minor.yy0;}
#line 1925 "parse.c"
        break;
      case 38:
#line 222 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy384);}
#line 1930 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 238:
      case 248:
      case 249:
#line 223 "parse.y"
{yygotominor.yy384 = yymsp[0].minor.yy384;}
#line 1943 "parse.c"
        break;
      case 40:
#line 224 "parse.y"
{
  yygotominor.yy384.z = yymsp[-3].minor.yy384.z;
  yygotominor.yy384.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy384.z;
}
#line 1951 "parse.c"
        break;
      case 41:
#line 228 "parse.y"
{
  yygotominor.yy384.z = yymsp[-5].minor.yy384.z;
  yygotominor.yy384.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy384.z;
}
#line 1959 "parse.c"
        break;
      case 43:
#line 234 "parse.y"
{yygotominor.yy384.z=yymsp[-1].minor.yy384.z; yygotominor.yy384.n=yymsp[0].minor.yy384.n+(yymsp[0].minor.yy384.z-yymsp[-1].minor.yy384.z);}
#line 1964 "parse.c"
        break;
      case 44:
#line 236 "parse.y"
{ yygotominor.yy230 = atoi((char*)yymsp[0].minor.yy384.z); }
#line 1969 "parse.c"
        break;
      case 45:
#line 237 "parse.y"
{ yygotominor.yy230 = -atoi((char*)yymsp[0].minor.yy384.z); }
#line 1974 "parse.c"
        break;
      case 50:
      case 52:
#line 246 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy178);}
#line 1980 "parse.c"
        break;
      case 51:
#line 247 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy178);}
#line 1985 "parse.c"
        break;
      case 53:
#line 249 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 1993 "parse.c"
        break;
      case 54:
#line 253 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy384);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2001 "parse.c"
        break;
      case 56:
#line 262 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy230);}
#line 2006 "parse.c"
        break;
      case 57:
#line 264 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy230,yymsp[0].minor.yy230,yymsp[-2].minor.yy230);}
#line 2011 "parse.c"
        break;
      case 58:
#line 265 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy230,0,0,0,0);}
#line 2016 "parse.c"
        break;
      case 59:
#line 266 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy178);}
#line 2021 "parse.c"
        break;
      case 60:
#line 268 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy384,yymsp[-1].minor.yy462,yymsp[0].minor.yy230);}
#line 2026 "parse.c"
        break;
      case 61:
#line 269 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy230);}
#line 2031 "parse.c"
        break;
      case 62:
#line 270 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy384.z, yymsp[0].minor.yy384.n);}
#line 2036 "parse.c"
        break;
      case 65:
#line 283 "parse.y"
{ yygotominor.yy230 = OE_Restrict * 0x010101; }
#line 2041 "parse.c"
        break;
      case 66:
#line 284 "parse.y"
{ yygotominor.yy230 = (yymsp[-1].minor.yy230 & yymsp[0].minor.yy13.mask) | yymsp[0].minor.yy13.value; }
#line 2046 "parse.c"
        break;
      case 67:
#line 286 "parse.y"
{ yygotominor.yy13.value = 0;     yygotominor.yy13.mask = 0x000000; }
#line 2051 "parse.c"
        break;
      case 68:
#line 287 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230;     yygotominor.yy13.mask = 0x0000ff; }
#line 2056 "parse.c"
        break;
      case 69:
#line 288 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230<<8;  yygotominor.yy13.mask = 0x00ff00; }
#line 2061 "parse.c"
        break;
      case 70:
#line 289 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230<<16; yygotominor.yy13.mask = 0xff0000; }
#line 2066 "parse.c"
        break;
      case 71:
#line 291 "parse.y"
{ yygotominor.yy230 = OE_SetNull; }
#line 2071 "parse.c"
        break;
      case 72:
#line 292 "parse.y"
{ yygotominor.yy230 = OE_SetDflt; }
#line 2076 "parse.c"
        break;
      case 73:
#line 293 "parse.y"
{ yygotominor.yy230 = OE_Cascade; }
#line 2081 "parse.c"
        break;
      case 74:
#line 294 "parse.y"
{ yygotominor.yy230 = OE_Restrict; }
#line 2086 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 167:
#line 296 "parse.y"
{yygotominor.yy230 = yymsp[0].minor.yy230;}
#line 2097 "parse.c"
        break;
      case 80:
#line 306 "parse.y"
{yygotominor.yy384.n = 0; yygotominor.yy384.z = 0;}
#line 2102 "parse.c"
        break;
      case 81:
#line 307 "parse.y"
{yygotominor.yy384 = yymsp[-1].minor.yy0;}
#line 2107 "parse.c"
        break;
      case 86:
#line 313 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy462,yymsp[0].minor.yy230,yymsp[-2].minor.yy230,0);}
#line 2112 "parse.c"
        break;
      case 87:
#line 315 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy462,yymsp[0].minor.yy230,0,0,0,0);}
#line 2117 "parse.c"
        break;
      case 88:
#line 316 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy178);}
#line 2122 "parse.c"
        break;
      case 89:
#line 318 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy462, &yymsp[-3].minor.yy384, yymsp[-2].minor.yy462, yymsp[-1].minor.yy230);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy230);
}
#line 2130 "parse.c"
        break;
      case 92:
      case 94:
#line 332 "parse.y"
{yygotominor.yy230 = OE_Default;}
#line 2136 "parse.c"
        break;
      case 97:
#line 337 "parse.y"
{yygotominor.yy230 = OE_Ignore;}
#line 2141 "parse.c"
        break;
      case 98:
      case 168:
#line 338 "parse.y"
{yygotominor.yy230 = OE_Replace;}
#line 2147 "parse.c"
        break;
      case 99:
#line 342 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy285, 0, yymsp[-1].minor.yy230);
}
#line 2154 "parse.c"
        break;
      case 102:
#line 352 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy384, &yymsp[-2].minor.yy384, yymsp[0].minor.yy239, yymsp[-5].minor.yy230);
}
#line 2161 "parse.c"
        break;
      case 103:
#line 355 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy285, 1, yymsp[-1].minor.yy230);
}
#line 2168 "parse.c"
        break;
      case 104:
#line 362 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy239, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy239);
}
#line 2176 "parse.c"
        break;
      case 105:
      case 128:
#line 372 "parse.y"
{yygotominor.yy239 = yymsp[0].minor.yy239;}
#line 2182 "parse.c"
        break;
      case 106:
#line 374 "parse.y"
{
  if( yymsp[0].minor.yy239 ){
    yymsp[0].minor.yy239->op = yymsp[-1].minor.yy230;
    yymsp[0].minor.yy239->pPrior = yymsp[-2].minor.yy239;
  }
  yygotominor.yy239 = yymsp[0].minor.yy239;
}
#line 2193 "parse.c"
        break;
      case 108:
#line 383 "parse.y"
{yygotominor.yy230 = TK_ALL;}
#line 2198 "parse.c"
        break;
      case 110:
#line 387 "parse.y"
{
  yygotominor.yy239 = sqlite3SelectNew(yymsp[-6].minor.yy462,yymsp[-5].minor.yy285,yymsp[-4].minor.yy178,yymsp[-3].minor.yy462,yymsp[-2].minor.yy178,yymsp[-1].minor.yy462,yymsp[-7].minor.yy230,yymsp[0].minor.yy270.pLimit,yymsp[0].minor.yy270.pOffset);
}
#line 2205 "parse.c"
        break;
      case 114:
      case 235:
#line 408 "parse.y"
{yygotominor.yy462 = yymsp[-1].minor.yy462;}
#line 2211 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 234:
#line 409 "parse.y"
{yygotominor.yy462 = 0;}
#line 2219 "parse.c"
        break;
      case 116:
#line 410 "parse.y"
{
   yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-2].minor.yy462,yymsp[-1].minor.yy178,yymsp[0].minor.yy384.n?&yymsp[0].minor.yy384:0);
}
#line 2226 "parse.c"
        break;
      case 117:
#line 413 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-1].minor.yy462, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2233 "parse.c"
        break;
      case 118:
#line 416 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-3].minor.yy462, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2242 "parse.c"
        break;
      case 121:
#line 428 "parse.y"
{yygotominor.yy384.n = 0;}
#line 2247 "parse.c"
        break;
      case 122:
#line 440 "parse.y"
{yygotominor.yy285 = sqliteMalloc(sizeof(*yygotominor.yy285));}
#line 2252 "parse.c"
        break;
      case 123:
#line 441 "parse.y"
{yygotominor.yy285 = yymsp[0].minor.yy285;}
#line 2257 "parse.c"
        break;
      case 124:
#line 446 "parse.y"
{
   yygotominor.yy285 = yymsp[-1].minor.yy285;
   if( yygotominor.yy285 && yygotominor.yy285->nSrc>0 ) yygotominor.yy285->a[yygotominor.yy285->nSrc-1].jointype = yymsp[0].minor.yy230;
}
#line 2265 "parse.c"
        break;
      case 125:
#line 450 "parse.y"
{yygotominor.yy285 = 0;}
#line 2270 "parse.c"
        break;
      case 126:
#line 451 "parse.y"
{
  yygotominor.yy285 = sqlite3SrcListAppend(yymsp[-5].minor.yy285,&yymsp[-4].minor.yy384,&yymsp[-3].minor.yy384);
  if( yymsp[-2].minor.yy384.n ) sqlite3SrcListAddAlias(yygotominor.yy285,&yymsp[-2].minor.yy384);
  if( yymsp[-1].minor.yy178 ){
    if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pOn = yymsp[-1].minor.yy178; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy178); }
  }
  if( yymsp[0].minor.yy160 ){
    if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pUsing = yymsp[0].minor.yy160; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy160); }
  }
}
#line 2286 "parse.c"
        break;
      case 127:
#line 465 "parse.y"
{
    yygotominor.yy285 = sqlite3SrcListAppend(yymsp[-6].minor.yy285,0,0);
    yygotominor.yy285->a[yygotominor.yy285->nSrc-1].pSelect = yymsp[-4].minor.yy239;
    if( yymsp[-2].minor.yy384.n ) sqlite3SrcListAddAlias(yygotominor.yy285,&yymsp[-2].minor.yy384);
    if( yymsp[-1].minor.yy178 ){
      if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pOn = yymsp[-1].minor.yy178; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy178); }
    }
    if( yymsp[0].minor.yy160 ){
      if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pUsing = yymsp[0].minor.yy160; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy160); }
    }
  }
#line 2303 "parse.c"
        break;
      case 129:
#line 486 "parse.y"
{
     yygotominor.yy239 = sqlite3SelectNew(0,yymsp[0].minor.yy285,0,0,0,0,0,0,0);
  }
#line 2310 "parse.c"
        break;
      case 130:
#line 492 "parse.y"
{yygotominor.yy384.z=0; yygotominor.yy384.n=0;}
#line 2315 "parse.c"
        break;
      case 132:
#line 497 "parse.y"
{yygotominor.yy285 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384);}
#line 2320 "parse.c"
        break;
      case 133:
#line 501 "parse.y"
{ yygotominor.yy230 = JT_INNER; }
#line 2325 "parse.c"
        break;
      case 134:
#line 502 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2330 "parse.c"
        break;
      case 135:
#line 503 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy384,0); }
#line 2335 "parse.c"
        break;
      case 136:
#line 505 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy384,&yymsp[-1].minor.yy384); }
#line 2340 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 175:
      case 200:
      case 223:
      case 225:
      case 229:
#line 509 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy178;}
#line 2353 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 201:
      case 224:
      case 226:
      case 230:
#line 510 "parse.y"
{yygotominor.yy178 = 0;}
#line 2364 "parse.c"
        break;
      case 139:
      case 172:
#line 514 "parse.y"
{yygotominor.yy160 = yymsp[-1].minor.yy160;}
#line 2370 "parse.c"
        break;
      case 140:
      case 171:
#line 515 "parse.y"
{yygotominor.yy160 = 0;}
#line 2376 "parse.c"
        break;
      case 142:
      case 152:
#line 526 "parse.y"
{yygotominor.yy462 = yymsp[0].minor.yy462;}
#line 2382 "parse.c"
        break;
      case 143:
#line 527 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462,yymsp[-2].minor.yy178,yymsp[-1].minor.yy384.n>0?&yymsp[-1].minor.yy384:0);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2390 "parse.c"
        break;
      case 144:
#line 531 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy178,yymsp[-1].minor.yy384.n>0?&yymsp[-1].minor.yy384:0);
  if( yygotominor.yy462 && yygotominor.yy462->a ) yygotominor.yy462->a[0].sortOrder = yymsp[0].minor.yy230;
}
#line 2398 "parse.c"
        break;
      case 146:
      case 148:
#line 540 "parse.y"
{yygotominor.yy230 = SQLITE_SO_ASC;}
#line 2404 "parse.c"
        break;
      case 147:
#line 541 "parse.y"
{yygotominor.yy230 = SQLITE_SO_DESC;}
#line 2409 "parse.c"
        break;
      case 149:
#line 543 "parse.y"
{yygotominor.yy384.z = 0; yygotominor.yy384.n = 0;}
#line 2414 "parse.c"
        break;
      case 155:
#line 561 "parse.y"
{yygotominor.yy270.pLimit = 0; yygotominor.yy270.pOffset = 0;}
#line 2419 "parse.c"
        break;
      case 156:
#line 562 "parse.y"
{yygotominor.yy270.pLimit = yymsp[0].minor.yy178; yygotominor.yy270.pOffset = 0;}
#line 2424 "parse.c"
        break;
      case 157:
#line 564 "parse.y"
{yygotominor.yy270.pLimit = yymsp[-2].minor.yy178; yygotominor.yy270.pOffset = yymsp[0].minor.yy178;}
#line 2429 "parse.c"
        break;
      case 158:
#line 566 "parse.y"
{yygotominor.yy270.pOffset = yymsp[-2].minor.yy178; yygotominor.yy270.pLimit = yymsp[0].minor.yy178;}
#line 2434 "parse.c"
        break;
      case 159:
#line 570 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy285,yymsp[0].minor.yy178);}
#line 2439 "parse.c"
        break;
      case 162:
#line 581 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy285,yymsp[-1].minor.yy462,yymsp[0].minor.yy178,yymsp[-4].minor.yy230);}
#line 2444 "parse.c"
        break;
      case 163:
#line 587 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462,yymsp[0].minor.yy178,&yymsp[-2].minor.yy384);}
#line 2449 "parse.c"
        break;
      case 164:
#line 588 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[0].minor.yy178,&yymsp[-2].minor.yy384);}
#line 2454 "parse.c"
        break;
      case 165:
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy285, yymsp[-1].minor.yy462, 0, yymsp[-4].minor.yy160, yymsp[-7].minor.yy230);}
#line 2459 "parse.c"
        break;
      case 166:
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy285, 0, yymsp[0].minor.yy239, yymsp[-1].minor.yy160, yymsp[-4].minor.yy230);}
#line 2464 "parse.c"
        break;
      case 169:
      case 227:
#line 606 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-2].minor.yy462,yymsp[0].minor.yy178,0);}
#line 2470 "parse.c"
        break;
      case 170:
      case 228:
#line 607 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[0].minor.yy178,0);}
#line 2476 "parse.c"
        break;
      case 173:
#line 616 "parse.y"
{yygotominor.yy160 = sqlite3IdListAppend(yymsp[-2].minor.yy160,&yymsp[0].minor.yy384);}
#line 2481 "parse.c"
        break;
      case 174:
#line 617 "parse.y"
{yygotominor.yy160 = sqlite3IdListAppend(0,&yymsp[0].minor.yy384);}
#line 2486 "parse.c"
        break;
      case 176:
#line 628 "parse.y"
{yygotominor.yy178 = yymsp[-1].minor.yy178; sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2491 "parse.c"
        break;
      case 177:
      case 182:
      case 183:
#line 629 "parse.y"
{yygotominor.yy178 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2498 "parse.c"
        break;
      case 178:
      case 179:
#line 630 "parse.y"
{yygotominor.yy178 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2504 "parse.c"
        break;
      case 180:
#line 632 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy384);
  yygotominor.yy178 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2513 "parse.c"
        break;
      case 181:
#line 637 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy384);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy384);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy178 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2524 "parse.c"
        break;
      case 184:
#line 646 "parse.y"
{yygotominor.yy178 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2529 "parse.c"
        break;
      case 185:
#line 647 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy178 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2538 "parse.c"
        break;
      case 186:
#line 653 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy178, 0, &yymsp[-1].minor.yy384);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2546 "parse.c"
        break;
      case 187:
#line 658 "parse.y"
{
  yygotominor.yy178 = sqlite3ExprFunction(yymsp[-1].minor.yy462, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy230 ){
    yygotominor.yy178->flags |= EP_Distinct;
  }
}
#line 2557 "parse.c"
        break;
      case 188:
#line 665 "parse.y"
{
  yygotominor.yy178 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2565 "parse.c"
        break;
      case 189:
#line 669 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy178 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy178 ) yygotominor.yy178->op = TK_CONST_FUNC;  
}
#line 2575 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 675 "parse.y"
{yygotominor.yy178 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy178, yymsp[0].minor.yy178, 0);}
#line 2587 "parse.c"
        break;
      case 198:
#line 685 "parse.y"
{yygotominor.yy440.eOperator = yymsp[0].minor.yy0; yygotominor.yy440.not = 0;}
#line 2592 "parse.c"
        break;
      case 199:
#line 686 "parse.y"
{yygotominor.yy440.eOperator = yymsp[0].minor.yy0; yygotominor.yy440.not = 1;}
#line 2597 "parse.c"
        break;
      case 202:
#line 691 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy178, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy178, 0);
  if( yymsp[0].minor.yy178 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy178, 0);
  }
  yygotominor.yy178 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy440.eOperator);
  if( yymsp[-2].minor.yy440.not ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-3].minor.yy178->span, &yymsp[-1].minor.yy178->span);
}
#line 2611 "parse.c"
        break;
      case 203:
#line 702 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2619 "parse.c"
        break;
      case 204:
#line 706 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2627 "parse.c"
        break;
      case 205:
#line 710 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2635 "parse.c"
        break;
      case 206:
#line 714 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2643 "parse.c"
        break;
      case 207:
#line 718 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2651 "parse.c"
        break;
      case 208:
#line 722 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2659 "parse.c"
        break;
      case 209:
#line 726 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2667 "parse.c"
        break;
      case 212:
#line 733 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy178, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy178, 0);
  yygotominor.yy178 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy178, 0, 0);
  if( yygotominor.yy178 ){
    yygotominor.yy178->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy178->span);
}
#line 2683 "parse.c"
        break;
      case 215:
#line 749 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pList = yymsp[-1].minor.yy462;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy462);
    }
    if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy0);
  }
#line 2697 "parse.c"
        break;
      case 216:
#line 759 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = yymsp[-1].minor.yy239;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2710 "parse.c"
        break;
      case 217:
#line 768 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = yymsp[-1].minor.yy239;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
    if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy0);
  }
#line 2724 "parse.c"
        break;
      case 218:
#line 778 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384);
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy178->span,yymsp[0].minor.yy384.z?&yymsp[0].minor.yy384:&yymsp[-1].minor.yy384);
  }
#line 2739 "parse.c"
        break;
      case 219:
#line 789 "parse.y"
{
    Expr *p = yygotominor.yy178 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy239;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
  }
#line 2752 "parse.c"
        break;
      case 220:
#line 801 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy178, yymsp[-1].minor.yy178, 0);
  if( yygotominor.yy178 ){
    yygotominor.yy178->pList = yymsp[-2].minor.yy462;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy462);
  }
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2765 "parse.c"
        break;
      case 221:
#line 812 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462, yymsp[-2].minor.yy178, 0);
  yygotominor.yy462 = sqlite3ExprListAppend(yygotominor.yy462, yymsp[0].minor.yy178, 0);
}
#line 2773 "parse.c"
        break;
      case 222:
#line 816 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy178, 0);
  yygotominor.yy462 = sqlite3ExprListAppend(yygotominor.yy462, yymsp[0].minor.yy178, 0);
}
#line 2781 "parse.c"
        break;
      case 231:
#line 843 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy384, &yymsp[-5].minor.yy384, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy384,0), yymsp[-1].minor.yy462, yymsp[-9].minor.yy230,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy230);
}
#line 2789 "parse.c"
        break;
      case 232:
      case 277:
#line 849 "parse.y"
{yygotominor.yy230 = OE_Abort;}
#line 2795 "parse.c"
        break;
      case 233:
#line 850 "parse.y"
{yygotominor.yy230 = OE_None;}
#line 2800 "parse.c"
        break;
      case 236:
#line 860 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy384.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy384.z, yymsp[-1].minor.yy384.n);
  }
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462, p, &yymsp[-2].minor.yy384);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2813 "parse.c"
        break;
      case 237:
#line 869 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy384.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy384.z, yymsp[-1].minor.yy384.n);
  }
  yygotominor.yy462 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy384);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2826 "parse.c"
        break;
      case 239:
#line 883 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy285, yymsp[-1].minor.yy230);}
#line 2831 "parse.c"
        break;
      case 240:
      case 241:
#line 887 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2837 "parse.c"
        break;
      case 242:
      case 244:
#line 893 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy384,0);}
#line 2843 "parse.c"
        break;
      case 243:
#line 894 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy0,0);}
#line 2848 "parse.c"
        break;
      case 245:
#line 896 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy384,1);
}
#line 2855 "parse.c"
        break;
      case 246:
#line 899 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy384,&yymsp[-3].minor.yy384,&yymsp[-1].minor.yy384,0);}
#line 2860 "parse.c"
        break;
      case 247:
#line 900 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384,0,0);}
#line 2865 "parse.c"
        break;
      case 253:
#line 912 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy384.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy384.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy247, &all);
}
#line 2875 "parse.c"
        break;
      case 254:
#line 921 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy384, &yymsp[-6].minor.yy384, yymsp[-5].minor.yy230, yymsp[-4].minor.yy132.a, yymsp[-4].minor.yy132.b, yymsp[-2].minor.yy285, yymsp[-1].minor.yy230, yymsp[0].minor.yy178, yymsp[-9].minor.yy230);
  yygotominor.yy384 = (yymsp[-6].minor.yy384.n==0?yymsp[-7].minor.yy384:yymsp[-6].minor.yy384);
}
#line 2883 "parse.c"
        break;
      case 255:
      case 258:
#line 927 "parse.y"
{ yygotominor.yy230 = TK_BEFORE; }
#line 2889 "parse.c"
        break;
      case 256:
#line 928 "parse.y"
{ yygotominor.yy230 = TK_AFTER;  }
#line 2894 "parse.c"
        break;
      case 257:
#line 929 "parse.y"
{ yygotominor.yy230 = TK_INSTEAD;}
#line 2899 "parse.c"
        break;
      case 259:
      case 260:
#line 934 "parse.y"
{yygotominor.yy132.a = yymsp[0].major; yygotominor.yy132.b = 0;}
#line 2905 "parse.c"
        break;
      case 261:
#line 936 "parse.y"
{yygotominor.yy132.a = TK_UPDATE; yygotominor.yy132.b = yymsp[0].minor.yy160;}
#line 2910 "parse.c"
        break;
      case 262:
      case 263:
#line 939 "parse.y"
{ yygotominor.yy230 = TK_ROW; }
#line 2916 "parse.c"
        break;
      case 264:
#line 941 "parse.y"
{ yygotominor.yy230 = TK_STATEMENT; }
#line 2921 "parse.c"
        break;
      case 265:
#line 945 "parse.y"
{ yygotominor.yy178 = 0; }
#line 2926 "parse.c"
        break;
      case 266:
#line 946 "parse.y"
{ yygotominor.yy178 = yymsp[0].minor.yy178; }
#line 2931 "parse.c"
        break;
      case 267:
#line 950 "parse.y"
{
  yymsp[-2].minor.yy247->pNext = yymsp[0].minor.yy247;
  yygotominor.yy247 = yymsp[-2].minor.yy247;
}
#line 2939 "parse.c"
        break;
      case 268:
#line 954 "parse.y"
{ yygotominor.yy247 = 0; }
#line 2944 "parse.c"
        break;
      case 269:
#line 960 "parse.y"
{ yygotominor.yy247 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy384, yymsp[-1].minor.yy462, yymsp[0].minor.yy178, yymsp[-4].minor.yy230); }
#line 2949 "parse.c"
        break;
      case 270:
#line 965 "parse.y"
{yygotominor.yy247 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy384, yymsp[-4].minor.yy160, yymsp[-1].minor.yy462, 0, yymsp[-7].minor.yy230);}
#line 2954 "parse.c"
        break;
      case 271:
#line 968 "parse.y"
{yygotominor.yy247 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy384, yymsp[-1].minor.yy160, 0, yymsp[0].minor.yy239, yymsp[-4].minor.yy230);}
#line 2959 "parse.c"
        break;
      case 272:
#line 972 "parse.y"
{yygotominor.yy247 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy384, yymsp[0].minor.yy178);}
#line 2964 "parse.c"
        break;
      case 273:
#line 975 "parse.y"
{yygotominor.yy247 = sqlite3TriggerSelectStep(yymsp[0].minor.yy239); }
#line 2969 "parse.c"
        break;
      case 274:
#line 978 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy178->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2978 "parse.c"
        break;
      case 275:
#line 983 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy384); 
  yygotominor.yy178->iColumn = yymsp[-3].minor.yy230;
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2987 "parse.c"
        break;
      case 276:
#line 991 "parse.y"
{yygotominor.yy230 = OE_Rollback;}
#line 2992 "parse.c"
        break;
      case 278:
#line 993 "parse.y"
{yygotominor.yy230 = OE_Fail;}
#line 2997 "parse.c"
        break;
      case 279:
#line 998 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy285);
}
#line 3004 "parse.c"
        break;
      case 280:
#line 1004 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy178, yymsp[-1].minor.yy178, yymsp[0].minor.yy292);
}
#line 3011 "parse.c"
        break;
      case 281:
#line 1009 "parse.y"
{ yygotominor.yy292 = 0; }
#line 3016 "parse.c"
        break;
      case 282:
#line 1010 "parse.y"
{ yygotominor.yy292 = yymsp[0].minor.yy178; }
#line 3021 "parse.c"
        break;
      case 285:
#line 1016 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy178);
}
#line 3028 "parse.c"
        break;
      case 286:
#line 1022 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3033 "parse.c"
        break;
      case 287:
#line 1023 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy384, &yymsp[0].minor.yy384);}
#line 3038 "parse.c"
        break;
      case 288:
#line 1028 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3043 "parse.c"
        break;
      case 289:
#line 1029 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy384, &yymsp[0].minor.yy384);}
#line 3048 "parse.c"
        break;
      case 290:
#line 1034 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy285,&yymsp[0].minor.yy384);
}
#line 3055 "parse.c"
        break;
      case 291:
#line 1037 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy384);
}
#line 3062 "parse.c"
        break;
      case 292:
#line 1040 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy285);
}
#line 3069 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3136 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
