// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.61 $
#include "hk_dsdatavisible.h"
#include "hk_form.h"
#include "hk_datasource.h"
#include "hk_presentation.h"
#include "hk_label.h"

int hk_dsdatavisible::p_defaultprecision=2;
bool hk_dsdatavisible::p_defaultthousandsseparator=false;

class hk_dsdatavisiblemodeprivate
{
public:
        hk_string      p_columnname;
        hk_string      p_defaultvalue;
        hk_string      p_valuechangedaction;
        bool           p_usedefault;
        int  p_precision;
        bool p_use_numberseparator;
        int p_columnoccurance;
hk_dsdatavisiblemodeprivate()
  {
    p_use_numberseparator=false;
    p_columnoccurance=-1;
    p_usedefault=false;
  }
bool operator=(const hk_dsdatavisiblemodeprivate& v)
   {
     p_columnname=v.p_columnname;
     p_defaultvalue=v.p_defaultvalue;
     p_precision=v.p_precision;
     p_columnoccurance=v.p_columnoccurance;
     p_usedefault=v.p_usedefault;
     p_valuechangedaction=v.p_valuechangedaction;
     return true;
   }
};

class hk_dsdatavisibleprivate
{
public:
hk_string p_value;
};

hk_dsdatavisible::hk_dsdatavisible(hk_presentation* p) :hk_dsvisible(p)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::hk_dsdatavisible");
#endif
p_private=new hk_dsdatavisibleprivate;
p_designdata=new hk_dsdatavisiblemodeprivate;
p_viewdata=new hk_dsdatavisiblemodeprivate;
    p_column=NULL;
    set_numberformat(defaultuse_numberseparator(),defaultprecision(),false,true);
    set_alignment(aligndefault,false);
    p_virginname=true;

}


hk_dsdatavisible::~hk_dsdatavisible()
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::destructor");
#endif
    if (p_column!=NULL) p_column->datavisible_remove(this);
delete p_designdata;
delete p_viewdata;
delete p_private;
}


void hk_dsdatavisible::set_datasource(hk_datasource* d)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_datasource");
#endif

    hk_dsvisible::set_datasource(d);
    if(d==NULL)
    {
        if (p_column!=NULL) p_column->datavisible_remove(this);
        p_column=NULL;
        return;
    }
    if ((d->is_enabled())&&(p_designdata->p_columnname!="")) column();
}


hk_datasource* hk_dsdatavisible::datasource(void)
{
    return hk_dsvisible::datasource();
}


void hk_dsdatavisible::set_columnname(const hk_string& c,bool registerchange)
{
    set_columnname(c,registerchange,1);
}


void hk_dsdatavisible::set_columnname(const hk_string& c, bool registerchange, int coloccurance)
{
#ifdef HK_DEBUG
    hkclassname(c);
    hkdebug("hk_dsdatavisible::set_columnname(hk_string&)");
    debug_p_columnname=c;
#endif
    p_designdata->p_columnname=c;
    p_designdata->p_columnoccurance=(coloccurance<1?1:coloccurance);
    if (label().size()==0) set_label(c,registerchange);
    has_changed(registerchange);

    hk_form* f=dynamic_cast<hk_form*>(p_presentation);
    if (f!=NULL && buddylabel()>-1)
    {
       hk_label* l=dynamic_cast<hk_label*>(f->get_visible(buddylabel()));
       if (l && l->label().size()==0&&c.size()>0)
       {
        l->set_label(c+":");
       }
    }

    if (datasource()!=NULL)
    {
        if ((datasource()->is_enabled())&&(p_designdata->p_columnname!=""))
        {
            set_column();
            row_change();
        }
#ifdef HK_DEBUG
        else
        {
//cout <<"columnname: "<<p_columnname<<endl<<"datasource-enabled() "<<(datasource()->is_enabled()?"ja":"nein")<<endl;
        }
    }else
    {
        hkdebug("hk_dsdatavisible::set_columnname(hk_string&) datasource==NULL");
#endif
    }
    widget_specific_enable_disable();
    widget_specific_set_column();

}


hk_column* hk_dsdatavisible::column()
{
#ifdef HK_DEBUG
  //  hkdebug("hk_dsdatavisible::column");
  //  hkdebug("columname= ",p_designdata->p_columnname);
#endif
/*        if (datasource()!=NULL)
            if (datasource()->depending_on()!=NULL) p_column=NULL;
    */
    if (p_column!=NULL)
    {
#ifdef HK_DEBUG
//        hkdebug("p_colum!=NULL=>return");
#endif
        return p_column;
    };
    if (p_designdata->p_columnname!="")
    {

        if (p_datasource!=NULL)
        {
#ifdef HK_DEBUG
            hkdebug("p_colum=NULL");
#endif
            if (p_datasource->is_enabled())
                set_column();
//	     cout <<"p_column: "<<p_column<<endl;
        }
    }
    return p_column;
}


bool hk_dsdatavisible::datasource_disable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::datasource_disable");
#endif
    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    hk_dsvisible::datasource_disable();
//widget_specific_enable_disable();
    return true;
}


bool hk_dsdatavisible::datasource_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::datasource_enable");
#endif

p_private->p_value="";
    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    column();
    hk_dsvisible::datasource_enable();
//widget_specific_enable_disable();
    return true;
}


void hk_dsdatavisible::datasource_delete(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::datasource_delete");
#endif

    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    p_datasource=NULL;
    widget_specific_enable_disable();
}


bool hk_dsdatavisible::before_columns_deleted(void)
{
    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    return true;
}


void hk_dsdatavisible::savedata(ostream& s )
{
    hk_string tag="HK_DSDATAVISIBLE";
    start_mastertag(s,tag);
    hk_dsvisible::savedata(s);
    set_tagvalue(s,"COLUMN",p_designdata->p_columnname);
    set_tagvalue(s,"COLUMNOCCURANCE",p_designdata->p_columnoccurance);
    set_tagvalue(s,"DEFAULTVALUE",p_designdata->p_defaultvalue);
    set_tagvalue(s,"USE_DEFAULTVALUE",p_designdata->p_usedefault);
    set_tagvalue(s,"NUMBERSEPARATOR",p_designdata->p_use_numberseparator);
    set_tagvalue(s,"COMMADIGITS",(long int)p_designdata->p_precision);
    set_tagvalue(s,"ONVALUECHANGED_ACTION",p_designdata->p_valuechangedaction);

    end_mastertag(s,tag);
}


void hk_dsdatavisible::loaddata(const hk_string& definition)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::loaddata");
#endif
    hk_string buffer;
    get_tagvalue(definition,"HK_DSVISIBLE",buffer);

    hk_dsvisible::loaddata(buffer);
    p_virginname=false;
    get_tagvalue(definition,"COLUMN",p_designdata->p_columnname);
    get_tagvalue(definition,"COLUMNOCCURANCE",p_designdata->p_columnoccurance);
    get_tagvalue(definition,"ONVALUECHANGED_ACTION",p_designdata->p_valuechangedaction);

#ifdef HK_DEBUG
    hkclassname(p_designdata->p_columnname);
#endif
    hk_string b;
    if (get_tagvalue(definition,"DEFAULTVALUE",b))p_designdata->p_defaultvalue=b;
    bool bb;
    if (get_tagvalue(definition,"USE_DEFAULTVALUE",bb))p_designdata->p_usedefault=bb;
    get_tagvalue(definition,"NUMBERSEPARATOR",p_designdata->p_use_numberseparator);
    get_tagvalue(definition,"COMMADIGITS",p_designdata->p_precision);
    set_numberformat(p_designdata->p_use_numberseparator,p_designdata->p_precision,false,true);
//compatibility code version 0.5.5 : now has moved to hk_visible. remove this code in version 1.0
    hk_string align;
    get_tagvalue(definition,"ALIGN",align);
    alignmenttype a=alignleft;
    if (align=="RIGHT") a=alignright;
    else if (align=="CENTER")a=aligncenter;
    set_alignment(a,false);
    *p_viewdata=*p_designdata;
//end compatibility code

}


hk_string hk_dsdatavisible::columnname(void)
{
    return p_designdata->p_columnname;
}


void hk_dsdatavisible::widget_specific_set_column(void)
{

}


void hk_dsdatavisible::set_column(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_column");
#endif
    if (p_column!=NULL)
    {
        p_column->datavisible_remove(this);
        p_column=NULL;
    }
    if(datasource()!=NULL) p_column=datasource()->column_by_name(p_designdata->p_columnname,p_designdata->p_columnoccurance);
    if (p_column!=NULL)
    {
        p_column->datavisible_add(this);
        p_column->set_dateformat(dateformat());
        p_column->set_timeformat(timeformat());
        p_column->set_datetimeformat(datetimeformat());
        if (!use_defaultvalue()&&p_virginname)
        {

            switch (p_column->columntype())
            {
                case hk_column::smallintegercolumn : ;
                case hk_column::integercolumn : set_defaultvalue(format_number(0,use_numberseparator(),precision(),locale()),false);break;
                case hk_column::smallfloatingcolumn :;
                case hk_column::floatingcolumn : ; set_defaultvalue(format_number(0.0,use_numberseparator(),precision(),locale()),false);break;
                case hk_column::datecolumn : ;
                case hk_column::timecolumn :;
                case hk_column::timestampcolumn:;
                case hk_column::datetimecolumn  :; set_defaultvalue("%NOW%",false);break;
                case hk_column::boolcolumn : ; set_defaultvalue("",false);break;
                default:;
            }
        }
//	    cout <<"col: "<<p_column->name()<<" type: "<<p_column->columntype_name()<<" is_numeric: "<<(is_numerictype(p_column)?"ja":"nein")<<endl;
        if (alignment()==hk_visible::aligndefault)
        {
            if (is_numerictype(p_column))set_alignment(defaultnumberalignment(),false);
            else set_alignment(defaulttextalignment(),false);
        }
        new_column_pointer_created();
	p_virginname=false;
    }

}


bool    hk_dsdatavisible::use_defaultvalue(void)
{
    if (p_column!=NULL)
        if (p_column->columntype()==hk_column::auto_inccolumn)
            return true;
if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
    return p_viewdata->p_usedefault;
return p_designdata->p_usedefault;

}


void    hk_dsdatavisible::set_defaultvalue(const hk_string& def,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_defaultvalue");
#endif
    if (allow_datachanging(false))
    {
    p_designdata->p_defaultvalue=def;
    p_designdata->p_usedefault=true;

    }
    p_viewdata->p_usedefault=true;
    p_viewdata->p_defaultvalue=def;

    has_changed(registerchange);

}


hk_string  hk_dsdatavisible::raw_defaultvalue(void)
{

    return p_designdata->p_defaultvalue;
}


hk_string  hk_dsdatavisible::defaultvalue(void)
{

    if (!p_column)
    {
    if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
    return p_viewdata->p_defaultvalue;
    else
    return p_designdata->p_defaultvalue;
    }
    hk_string dt;

    switch  (p_column->columntype())
    {
        case hk_column::auto_inccolumn :  return hk_translate("[Auto]");
        case hk_column::datecolumn :  dt=p_date.date_asstring();break;
        case hk_column::timecolumn :  dt=p_date.time_asstring();break;
        case hk_column::datetimecolumn :;
        case hk_column::timestampcolumn:;
        default:dt=p_date.datetime_asstring();
    }
    hk_string p_res=(p_presentation && p_presentation->mode()==hk_presentation::viewmode?p_viewdata->p_defaultvalue:p_designdata->p_defaultvalue);
    p_res=replace_all("%NOW%",p_res,dt);
    p_res=replace_all("%NOWTIME%",p_res,p_date.time_asstring());
    p_res=replace_all("%NOWDATE%",p_res,p_date.date_asstring());
    p_res=replace_all("%TRUE%",p_res,"TRUE");
    p_res=replace_all("%FALSE%",p_res,"FALSE");

    return p_res;
}


void    hk_dsdatavisible::reset_default(bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::reset_default");
#endif

    p_viewdata->p_usedefault=false;
    p_viewdata->p_defaultvalue="";
   if (allow_datachanging(false))
   {
    p_designdata->p_usedefault=false;
    p_designdata->p_defaultvalue="";

   }
    has_changed(registerchange);
}


void hk_dsdatavisible::before_insert_row(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::before_insert_row");
#endif
    if (datasource()==NULL||p_column==NULL||!use_defaultvalue()) return;
    if (!p_column->has_changed()&&use_defaultvalue()&&defaultvalue().size()>0)
    {
        p_column->set_asstring(defaultvalue(),true,true);
    }

}


void    hk_dsdatavisible::set_numberformat(bool use_numberseparator, int commadigits,bool registerchange)
{
   set_numberformat(use_numberseparator,commadigits,registerchange,false);
}


void    hk_dsdatavisible::set_numberformat(bool use_numberseparator, int commadigits,bool registerchange,bool force_setting)
{

    if (allow_datachanging(force_setting))
    {
    p_designdata->p_use_numberseparator=use_numberseparator;
    p_designdata->p_precision=(commadigits<0?-1:commadigits);

    }
    p_viewdata->p_use_numberseparator=use_numberseparator;
    p_viewdata->p_precision=(commadigits<0?-1:commadigits);
    widget_specific_numberformat();
    has_changed(registerchange);
}


bool    hk_dsdatavisible::use_numberseparator(void)
{
if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
    return p_viewdata->p_use_numberseparator;
    return p_designdata->p_use_numberseparator;

}


int     hk_dsdatavisible::commadigits(void)
{
    return precision();
}


int     hk_dsdatavisible::precision(void)
{

if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
    return p_viewdata->p_precision;
    return p_designdata->p_precision;

}


void hk_dsdatavisible::set_defaultnumberformat(bool use_thousandsseparator,int precision)
{
    p_defaultthousandsseparator=use_thousandsseparator;
    p_defaultprecision=precision;

}


bool hk_dsdatavisible::defaultuse_numberseparator(void)
{
    return p_defaultthousandsseparator;

}


int hk_dsdatavisible::defaultprecision(void)
{
    return p_defaultprecision;
}


void hk_dsdatavisible::widget_specific_numberformat(void)
{

}


hk_string hk_dsdatavisible::value_at(unsigned long at)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::value_at");
#endif
    if (!column()) return p_private->p_value;
    hk_string value;
    bool is_null=false;
    if (p_column->has_changed() &&
        ((datasource()->row_position()==at&&datasource()->mode()!=hk_datasource::mode_insertrow)
        ||(datasource()->row_position()==datasource()->max_rows()&&datasource()->mode()==hk_datasource::mode_insertrow))

        )
	{
        value=p_column->changed_data_asstring();
	is_null=p_column->changed_data_is_nullvalue();
	}
    else
    if (datasource()->mode()==hk_datasource::mode_insertrow&& at>= datasource()->max_rows()&& use_defaultvalue())
    {
        value=defaultvalue();
	is_null=(value.size()==0);
    }
    else
    {
        value=p_column->asstring_at(at,true);
	is_null=p_column->is_nullvalue_at(at);
     }
    if (!is_null&&is_numerictype(p_column)&&p_column->columntype()!=hk_column::auto_inccolumn&&value.length()>0
        || (p_column->columntype()==hk_column::auto_inccolumn
        && (datasource()->mode()!=hk_datasource::mode_insertrow||at<datasource()->max_rows())))
    {
        value=format_number(value,true,use_numberseparator(),commadigits(),locale());
    }

    return value;

}

hk_string hk_dsdatavisible::value(void)
{
     if (!column()) return p_private->p_value;
hk_datasource* ds=datasource();
if (ds)
   {
     return value_at(ds->row_position());
   }
   else return p_private->p_value;
}




void hk_dsdatavisible::new_column_pointer_created(void)
{

}


void hk_dsdatavisible::set_value(const hk_string& v)
{
 p_private->p_value=v;
 hk_column* c=column();
 if (c)c->set_asstring(v);
 action_on_valuechanged();
}

unsigned int hk_dsdatavisible::find(unsigned int from,unsigned int to,const hk_string& searchtext,bool wholephrase,bool casesensitive,bool backwards)
{
 hk_column* c=column();
 if (c)return c->find(from,to,searchtext,wholephrase,casesensitive,backwards);
 else return (unsigned int) -1;
}


unsigned int hk_dsdatavisible::find(const hk_string& searchtext,bool wholephrase,bool casesensitive, bool backwards)
{
 hk_column* c=column();
 if (c)return c->find(searchtext,wholephrase,casesensitive,backwards);
 else return (unsigned int) -1;
}


bool     hk_dsdatavisible::presentationmode_changed(void)
{

    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    if (p_presentation->mode()==hk_presentation::viewmode )
      *p_viewdata=*p_designdata;
    return hk_dsvisible::presentationmode_changed();
}

void hk_dsdatavisible::set_on_valuechanged_action(const hk_string& action,bool registerchange,bool force_setting)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_on_valuechanged_action",action);
#endif
    if (allow_datachanging(force_setting))
    {
      p_designdata->p_valuechangedaction=action;
    }
p_viewdata->p_valuechangedaction=action;
has_changed(registerchange);
}

hk_string hk_dsdatavisible::on_valuechanged_action(void)
{
if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
  return p_viewdata->p_valuechangedaction;
  return p_designdata->p_valuechangedaction;
}


bool hk_dsdatavisible::action_on_valuechanged(void)
{
if (on_valuechanged_action().size()==0) return true;
 if (!p_presentation)return false;
	return p_presentation->interpreter()->on_valuechanged(this);
 }


void hk_dsdatavisible::set_data_has_changed(void)
{
   if (p_column) p_column->set_has_changed();

}

