<?php

require_once 'Horde/Browser.php';
require_once 'Horde/Block/Collection.php';

/**
 * The Horde_Block_Layout_View class represents the user defined portal layout.
 *
 * $Horde: framework/Block/Block/Layout/View.php,v 1.4.2.2 2006/03/08 17:54:08 chuck Exp $
 *
 * Copyright 2003-2006 Mike Cochrane <mike@graftonhall.co.nz>
 * Copyright 2003-2006 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @author  Jan Schneider <jan@horde.org>
 * @since   Horde 3.2
 * @package Horde_Block
 */
class Horde_Block_Layout_View {

    /**
     * The current block layout.
     *
     * @var array
     */
    var $_layout = array();

    /**
     * All applications used in this layout.
     *
     * @var array
     */
    var $_applications = array();

    /**
     * CSS link tags pulled out of block content.
     *
     * @var array
     */
    var $_linkTags = array();

    /**
     * Constructor.
     */
    function Horde_Block_Layout_View($layout = '')
    {
        $this->_layout = @unserialize($layout);
        if (!$this->_layout) {
            $this->_layout = array();
        }
    }

    /**
     * Render the current layout as HTML.
     *
     * @return string HTML layout.
     */
    function toHtml()
    {
        $browser = &Browser::singleton();
        $tplDir = $GLOBALS['registry']->get('templates', 'horde');
        $interval = $GLOBALS['prefs']->getValue('summary_refresh_time');

        ob_start();

        echo '<table class="nopadding" cellspacing="6" width="100%">';

        $covered = array();
        foreach ($this->_layout as $row_num => $row) {
            $width = floor(100 / count($row));
            echo '<tr>';
            foreach ($row as $col_num => $item) {
                if (isset($covered[$row_num]) && isset($covered[$row_num][$col_num])) {
                    continue;
                }
                if (is_array($item)) {
                    $this->_applications[$item['app']] = $item['app'];
                    $block = &Horde_Block_Collection::getBlock($item['app'], $item['params']['type'], $item['params']['params']);
                    $rowspan = $item['height'];
                    $colspan = $item['width'];
                    $width *= $colspan;
                    for ($i = 0; $i < $item['height']; $i++) {
                        if (!isset($covered[$row_num + $i])) {
                            $covered[$row_num + $i] = array();
                        }
                        for ($j = 0; $j < $item['width']; $j++) {
                            $covered[$row_num + $i][$col_num + $j] = true;
                        }
                    }
                    if (is_a($block, 'PEAR_Error')) {
                        $header = _("Error");
                        $content = $block->getMessage();
                        include $tplDir . '/portal/block.inc';
                    } elseif (is_a($block, 'Horde_Block')) {
                        $header = $block->getTitle();
                        $content = $block->getContent();
                        include $tplDir . '/portal/block.inc';
                    } else {
                        echo '<td width="' . $width . '%">&nbsp;</td>';
                    }
                } else {
                    echo '<td width="' . $width . '%">&nbsp;</td>';
                }
            }
            echo '</tr>';
        }
        echo '</table>';

        $html = ob_get_clean();

        // Strip any CSS <link> tags out of the returned content so
        // they can be handled seperately.
        if (preg_match_all('/<link .*?rel="stylesheet".*?\/>/', $html, $links)) {
            $html = str_replace($links[0], '', $html);
            $this->_linkTags = $links[0];
        }

        return $html;
    }

    /**
     * Get any link tags found in the view.
     */
    function getLinkTags()
    {
        return $this->_linkTags;
    }

    /**
     * Return a list of all the applications used by blocks in this layout.
     *
     * @return array List of applications.
     */
    function getApplications()
    {
        return array_keys($this->_applications);
    }

}
