/*
 * http_digest.h -- header file for Digest Authentication.
 * Much of the source is taken from RFC2617.
 * Created: Espeleta Tomas <espeleta@libero.it>, 12-Apr-2001
 * Christopher Blizzard <blizzard@appliedtheory.com>, 21-Aug-1998
 *
 * Copyright (C) 1998 Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define HASHLEN 16
typedef char HASH[HASHLEN];
#define HASHHEXLEN 32
typedef char HASHHEX[HASHHEXLEN+1];
#define IN
#define OUT

struct digest_struct {
    IN char *pszAlg;         /* Algoritm, default is MD5 */
    IN char *pszUserName;    /* UserName */
    IN char *pszRealm;       /* Realm */
    IN char *pszPassword;    /* nonce from server */
    IN char *pszNonce;       /* nonce from server */
    IN int   NonceCount;     /* Mantain noncecount */
    IN char *pszNonceCount;  /* 8 hex digits */
    IN char *pszCNonce;      /* client nonce */
    IN char *pszQop;         /* qop-value: "", "auth", "auth-int" */
    IN char *pszMethod;      /* method from the request */
    IN char *pszDigestUri;   /* requested URL */
    IN HASHHEX HEntity;      /* H(entity body) if qop="auth-int" */
};
typedef struct digest_struct DIGEST_STRUCT;


/* Struct containing values passed between public ghttp_set_digestinfo()
 * and private http_digest_header()
 */
struct _authdata {
    IN  char *username;
    IN  char *password;
    IN  char *hdr_wwwauth;
    IN  char *method;
    IN  char *path;
    OUT char *header;
    OUT char *old_realm;
    OUT char *old_nonce;
    OUT char *old_qop;
    OUT int  old_nc;
};
typedef struct _authdata auth_data;

/* calculate H(A1) as per HTTP Digest spec */
void DigestCalcHA1(
    IN DIGEST_STRUCT *mystruct, OUT HASHHEX SessionKey
);

/* calculate request-digest/response-digest as per HTTP Digest spec */
void DigestCalcResponse(
    IN DIGEST_STRUCT *mystruct, OUT HASHHEX Response
);

/*
 * Uses given authdata struct <OR> WWWAuthenticate header to prepare
 * a Digest-type Authorization header
*/
auth_data *
http_digest_header(ghttp_request *request,
			auth_data *authdata,
			int mantainlogged);

