/*
 * commands_smtp.c -- SMTP specific command handlers
 * This file contains all the SMTP specific command implementations. Should be
 * used in conjunction with commands.c which contains all the POP3/IMAP/SMTP
 * independent commands.
 *
 * Created by: Trever Adams <tadams-lists@myrealbox.com> 26-Jan-2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "../httpmail.h"
#include "../hotwayd.h"
#include "hotsmtpd.h"
#include "commands_smtp.h"
#include "../libghttp-1.0.9-mod/ghttp.h"
#include "../libghttp-1.0.9-mod/ghttp_constants.h"
#include "../commands.h"
#include "../xmlstuff.h"

extern ghttp_request *request;
extern char buffer[N_BUFFER];

/* functions from commands.c */
extern char *get_moved_url(ghttp_request *);
extern int dologin(ghttp_request *request, int protocol);
extern URL_STRUCT *smtpurl;
extern const char *http_hdr_Brief;

/* functions and data from hotsmtpd.c */
extern void get_input(void);
extern char input[N_BUFLEN];
extern int state;
extern int log_level;
extern LISTS HEADERS;
extern LISTS MAILDATA;

void delete_list(LISTS *LIST_HEAD)
{
  if(LIST_HEAD->next != NULL) delete_list(LIST_HEAD->next);
  if(LIST_HEAD->next != NULL) free(LIST_HEAD->next);
  LIST_HEAD->next=NULL;
  if(LIST_HEAD->buffer != NULL) free(LIST_HEAD->buffer);
  LIST_HEAD->buffer=NULL;
  LIST_HEAD->size=0;
}

void init_list(LISTS *LIST_HEAD)
{
  LIST_HEAD->buffer=NULL;
  LIST_HEAD->next=NULL;
  LIST_HEAD->size=0;
}

unsigned long compute_list_size(LISTS *LIST_HEAD)
{
unsigned long size=0;

  if(LIST_HEAD->next != NULL) size=compute_list_size(LIST_HEAD->next);
  size=size+LIST_HEAD->size;
  return size;
}

int add_item(LISTS *LIST_HEAD, char *buffer, int size)
{
LISTS *item;

  item=malloc(sizeof(LISTS));
  if(item==NULL) return -1;
  item->next=LIST_HEAD->next;
  LIST_HEAD->next=item;
  item->buffer=buffer;
  item->size=size;
  return 0;
}

/* ghttp requires just one big body, this function dumps the list out in
 * the right order into a body fit for ghttp.  It gets called however
 * many times we have lists. */
void build_body(LISTS *LIST_HEAD, char *body)
{
  if(LIST_HEAD->next != NULL) build_body(LIST_HEAD->next, body);
  if(LIST_HEAD->size > 0) strcat(body, LIST_HEAD->buffer); /* We don't want to copy empty crap */
}

void do_send(int *state)
{
char *body;
unsigned long body_len=compute_list_size(&HEADERS) + compute_list_size(&MAILDATA) + 2;

  /* Create our body in httpmail upload format... this includes the headers */
  body=malloc(body_len+1);
  memset(body, 0, body_len+1);  
  build_body(&HEADERS, body);
  strcat(body, "\r\n");
  build_body(&MAILDATA, body);

  /* Do the work */
  httpmail_send(smtpurl->href, body, body_len);

  /* reset to authenticated */
  *state = AUTHENTICATED;
}

void process_mail(LISTS *LIST_HEAD, int *state)
{
  while(1)
  {
    get_input();
    if(strncmp(input, ".\r\n", 3) == 0) /* Ok, we have the end command, and we have queued, drop out */
    {
        do_send(state);
        return;
    }
    process_line(LIST_HEAD, state);
  }
}

void process_line(LISTS *LIST_HEAD, int *state)
{
int len=0, offset=0;
char *buffer;

  len=strlen(input);
  if(len > MAX_TEXT_LEN) {
    PSOUT("501 DATA line too long");
    PCRLF;
  }
  if(*state == DATA)
  {
    if(strncmp(input, "..", 2) == 0) /* Handle "transparency" as defined in RFC 821 */
    {
      offset=1;
      len-=1;
    }
  }
  if((buffer=malloc(len+1)) == NULL)
  {
    PSOUT("452 Unable to allocate memory");
    PCRLF;
    return;
  }
  else /* Ok, add this to our list */
  {
    strcpy(buffer, &input[offset]);
    add_item(LIST_HEAD, buffer, len);
  }
}
/* Since we don't know how the client spaced things, this function removes the
 * nulls added by main_loop on decoding the command and readds the \r\n.  This
 * is not a perfect thing. */
void unbork_input(int argc, char *argv[])
{
  for(argc-=2; argc>=0; argc--) argv[argc][strlen(argv[argc])]=' ';
  strcat(input, "\r\n");
}

void httpmail_send(char *sendmsg_url, char *body, unsigned long body_len)
{
ghttp_request *request = NULL;
int status;
long ret_len;

  /* We don't want to timeout on upload to httpmail server */
  alarm(0);

  /* Allocate a new empty request object */
  request = ghttp_request_new();

  /* Set the URI for the request object */
  ghttp_set_uri(request, sendmsg_url);

  /* Set the type of request */
  ghttp_set_type(request, ghttp_type_post);

/* Do not go wildly adding headers.  httpmail servers are very picky *
 * about what headers they see.  If this function stops working properly *
 * someone went screwing around with headers here or in prepare_and_send. *
 * If this isn't it, then httpmail has changed its interface! */  
  ghttp_set_header(request, "Content-Type", "message/rfc821");

  /* Set our body */
  ghttp_set_body(request, body, body_len);

  /* Prepare the request and send it */
  prepare_and_send(request, sendmsg_url);

  /* Get the return codes */
  status = ghttp_status_code(request);
  ret_len = ghttp_get_body_len(request);

  /* We got something we didn't expect. We should have status = 200 and no
   * body on success! Tell user. */
  if(status != 200 || ret_len > 0)
  {
  PFSOUT("554 Enqueue operation failed.  Server returned Status: %d and Body w/ Length of %ld", status, ret_len);
  PCRLF;
  if (log_level > 2)
    LOG("Unable to send.  httpmail service returned status: %d and body: %*s\n", status, ret_len, ghttp_get_body(request));
  }

  /* Every thing worked out.  Good to go.  Tell user so. */
  else
  {
  PFSOUT("250 OK Queued - Server Returned: %d and Empty Body", status);
  PCRLF;
  }

  /* Clean up after ourselves */
  ghttp_request_destroy(request);
  free(body);
}
