-- A Haskell implementation of the Berkeley DB example program (example.cs)

{-# OPTIONS -fglasgow-exts #-}

module Main where

import DB_H

import Control.Monad

main = do

  let dbperm = fromIntegral $ c_S_IRUSR .|. c_S_IWUSR .|. c_S_IRGRP .|. c_S_IWGRP .|. c_S_IROTH

  putStrLn "Test of Autogenerated BerkeleyDB Binding"

-- Create the database handle and open the underlying database.

  (ret, dbp) <- alloca $ \pdbp -> do
    r <- f_db_create pdbp nullPtr 0
    h <- peek pdbp
    return (r,h)

  putStrLn $ "DB Handle created: " ++ (show ret)

  ret <- withCString "access.db" $ \dbname -> do
    r <- (dbp ==> X_open) dbp 
                          nullPtr 
                          dbname 
                          nullPtr 
                          (fromIntegral e_DB_BTREE) 
                          (fromIntegral c_DB_CREATE) 
                          dbperm
    return r

  putStrLn $ "Database created: " ++ (show ret)
  when (ret /= 0) $ do errmsg <- f_db_strerror ret >>= peekCString
                       putStrLn $ "Error: " ++ errmsg

-- Initialize key/data structures.

  ret <- alloca $ \dbkey -> 
         alloca $ \dbdata -> 
         withCStringLen "fruit" $ \fruit ->
         withCStringLen "apple" $ \apple -> do
           (dbkey,V_data) <-- fst fruit
           (dbkey,V_size) <-- (fromIntegral $ snd fruit)
           (dbdata,V_data) <-- fst apple
           (dbdata,V_size) <-- (fromIntegral $ snd apple)

-- Store a key/value pair.

           r <- (dbp ==> X_put) dbp nullPtr dbkey dbdata 0
           return r

  putStrLn $ "Data item stored: " ++ (show ret)
  when (ret /= 0) $ do errmsg <- f_db_strerror ret >>= peekCString
                       putStrLn $ "Error: " ++ errmsg

-- Retrieve a key/value pair.

  (ret,
   ks,
   vs) <- alloca $ \dbkey ->
          alloca $ \dbdata ->  
          withCStringLen "fruit" $ \fruit -> do
            (dbkey,V_data) <-- fst fruit
            (dbkey,V_size) <-- (fromIntegral $ snd fruit)
            r <- (dbp ==> X_get) dbp nullPtr dbkey dbdata 0
            ksc <- (dbkey --> V_data) :: IO CString
            kss <- dbkey --> V_size
            if (r == 0) 
              then do dsc <- (dbdata --> V_data) :: IO CString
                      dss <- dbdata --> V_size
                      ks <- peekCStringLen (ksc, fromIntegral kss)
                      vs <- peekCStringLen (dsc ,fromIntegral dss)
                      return (r, ks, vs)
              else return (r, undefined, undefined)

  putStrLn $ "Data item retrieved: " ++ (show ret)

  if (ret == 0) 
    then putStrLn $ "Value is: " ++  vs
    else do errmsg <- f_db_strerror ret >>= peekCString
            putStrLn $ "Error: " ++ errmsg

-- Delete a key/value pair.

  ret <- alloca $ \dbkey ->
         withCStringLen "fruit" $ \fruit -> do
           (dbkey,V_data) <-- fst fruit
           (dbkey,V_size) <-- (fromIntegral $ snd fruit)
           r <- (dbp ==> X_del) dbp nullPtr dbkey 0
           return r

  putStrLn $ "Data item deleted: " ++ (show ret)
  when (ret /= 0) $ do errmsg <- f_db_strerror ret >>= peekCString
                       putStrLn $ "Error: " ++ errmsg

-- Retrieve a key/value pair.

  (ret,
   ks,
   vs) <- alloca $ \dbkey ->
          alloca $ \dbdata ->
          withCStringLen "fruit" $ \fruit -> do
            (dbkey,V_data) <-- fst fruit
            (dbkey,V_size) <-- (fromIntegral $ snd fruit)
            r <- (dbp ==> X_get) dbp nullPtr dbkey dbdata 0
            ksc <- (dbkey --> V_data) :: IO CString
            kss <- dbkey --> V_size
            if (r == 0)
              then do dsc <- (dbdata --> V_data) :: IO CString
                      dss <- dbdata --> V_size
                      ks <- peekCStringLen (ksc, fromIntegral kss)
                      vs <- peekCStringLen (dsc, fromIntegral dss)
                      return (r, ks, vs)
              else return (r, undefined, undefined)

  putStrLn $ "Data item retrieved: " ++ (show ret)

  if (ret == 0)
    then putStrLn $ "Value is: " ++  vs
    else do errmsg <- f_db_strerror ret >>= peekCString
            putStrLn $ "Error: " ++ errmsg

  ret <- (dbp ==> X_close) dbp 0

  putStrLn $ "Database closed: " ++ (show ret) 
  when (ret /= 0) $ do errmsg <- f_db_strerror ret >>= peekCString
                       putStrLn $ "Error: " ++ errmsg

  return ()
