///////
   //    _Server.h
   //    _Server Class declaration
   //
   //    Class to interface with Server table of mysql Database
   //    This inherits from the Server class.
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: _Server.h,v 1.9 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 02.07.1999
///////

#ifndef __SERVER_H
#define __SERVER_H

#include "Server.h"

class _Server : public Server
{
   public:
   
      // Construction / Destruction
      _Server (const String &host, int port );
      _Server (const _Server& rhs);
      virtual ~_Server();

///////
   //    Interface with protected methods
///////

      void SetID (unsigned int ID) { IDServer = ID; }
      void SetIPAddress (const String &IP) { IPAddress = IP; }
      void SetHttpVersion (const String &V) { HttpVersion = V; }
      void SetHttpServer (const String &S) { HttpServer = S; }
      void SetRequests (unsigned int R) { Requests = R; }
      unsigned int IncrementRequests () { return ++Requests; }      
      
      unsigned int GetID () const { return IDServer; }
      const String &GetIPAddress () const { return IPAddress; }
      const String &GetHttpVersion () const { return HttpVersion; }
      const String &GetHttpServer () const { return HttpServer; }
      unsigned int GetRequests () const { return Requests; }


///////
   //    Static Methods
///////

      static unsigned int GetTotServers () { return TotServers; }
      static unsigned int IncrementTotServers () { return ++TotServers; }
      
   protected:
   
    _Server() {};   // not accessible!

    // It inherits every attribute from the Server class

      unsigned int      IDServer;
      String            IPAddress;
      String            HttpServer;
      String            HttpVersion;
      unsigned int      Requests;

///////
   //    Static variable storing the number of server "crawled"
   //    It's designed for assigning the IDServer, in a incremental way
///////

      static unsigned int TotServers;

};

#endif
