/* Do not edit this file. It was automatically genarated. */

#ifndef HEADER_ProcessList
#define HEADER_ProcessList
/*
htop
(C) 2004 Hisham H. Muhammad
Released under the GNU GPL, see the COPYING file
in the source distribution for its full text.
*/

#include "Process.h"
#include "ProcessFilter.h"
#include "TypedVector.h"
#include "UsersTable.h"
#include "Hashtable.h"

#include "debug.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <signal.h>
#include <stdbool.h>

#ifndef PROCDIR
#define PROCDIR "/proc"
#endif

#ifndef PROCSTATFILE
#define PROCSTATFILE "/proc/stat"
#endif

#ifndef PROCMEMINFOFILE
#define PROCMEMINFOFILE "/proc/meminfo"
#endif

typedef struct ProcessList_ {
   TypedVector* processes;
   Hashtable* processTable;
   ProcessFilter* filter;
   Process* prototype;
   UsersTable* usersTable;
   long int totalTime;
   long int userTime;
   long int systemTime;
   long int idleTime;
   long int niceTime;
   long int totalPeriod;
   long int userPeriod;
   long int systemPeriod;
   long int idlePeriod;
   long int nicePeriod;
   long int totalMem;
   long int usedMem;
   long int freeMem;
   long int sharedMem;
   long int buffersMem;
   long int cachedMem;
   long int totalSwap;
   long int usedSwap;
   long int freeSwap;
} ProcessList;

ProcessList* ProcessList_new(ProcessFilter* filter, UsersTable* usersTable);

void ProcessList_delete(ProcessList* this);

void ProcessList_prune(ProcessList* this);

void ProcessList_add(ProcessList* this, Process* p);

void ProcessList_remove(ProcessList* this, Process* p);

Process* ProcessList_get(ProcessList* this, int index);

int ProcessList_size(ProcessList* this);

void ProcessList_sort(ProcessList* this);

/* private */
int ProcessList_readStatFile(Process *proc, FILE *f, char *command);

void ProcessList_scan(ProcessList* this);

void ProcessList_dontCrash(int signal);

#endif
