package lib::plugin;

$VERSION="1.0";
sub Version { $VERSION; }

require lib;
require lib::plugin::message;
require lib::plugin::broker;

use strict;

# Constructors

sub new {
  my($class, %init) = @_;

  my $self = bless {
    'basedir' => 'plugins/',
    'broker' => undef,
    'version' => lib::plugin::Version
  }, $class;

  foreach (keys %init) {
    if(defined $self->{$_}) {
      $self->{$_}=$init{$_};
    }
  }

return $self;
}

# Load our plugins and register them

sub load {
  my ($self, $opt_ref) = @_;
  my ($plugin, @plugin_files, $plugin_file);

  my %options=%{$opt_ref};

  lib::debug("NL: $options{'noise'} - IN: $options{'intrusive'}");

  if(! ref $self->{'broker'}) {
    $self->{'broker'} = new lib::plugin::broker(('noise' => $options{'noise'}, 'intrusive' => $options{'intrusive'}, 'plugin_obj' => $self));
    $self->{'broker'}->start();
  }

  return 1;
}

sub print_select {
  my ($self) = @_;
  my ($k, $data, $select);

foreach $k (keys %{$self->{'broker'}->{'list'}}) {
  if($self->{'broker'}{'list'}{$k}{description}) {
    $data=$self->{'broker'}->{'list'}{$k}{description};
    } else {
    $data=$self->{'broker'}->{'list'}{$k}{exec};
    }

  if($data && $self->{'broker'}->{'list'}{$k}{events}{action})
    {
    $select=$select."<OPTION VALUE=\"$k\">$data\n";
    }
  }
return $select;
}

sub run {
my ($self, $file_id, $el, $event, $request_uri, @data)=@_;
my ($ret, $plugin_data);

#if(! $HTTPUSH_OPTIONS{'xml'}) {
#  return;
#}

my $message = new lib::plugin::message('method' => $event, 'version' => $self->{'version'});

my $el_id=$file_id."/".$el->att('id');

lib::debug("Received event \"$event\" for element $el_id, sending data to PluginBroker...");

$message->add_header('id', $el_id);
$message->add_header('uri', $request_uri);

# Prepare data to send to plugins

if($event eq "sent") {
  $message->add_header('content', $self->decode($data[0]));
} elsif($event eq "received") {
  $message->add_header('content', $self->decode($data[0]));
} elsif($event eq "request") {

  my $sent=$data[2];
  my $received=$data[3];

  $sent=~s/[\n\r]//g;
  $received=~s/[\n\r]//g;

  $message->add_header('sent',$self->decode($sent));
  $message->add_header('received',$self->decode($received));
  $message->add_header('who', $data[0].":".$data[1]); # XXXXXXXXXXX decode or not?

} elsif($event eq "fqdn") {
  my $fqdn=$el->att('name');

  $message->add_header('content',$fqdn);

} elsif($event eq "port") {
  my $port=$el->att('number');

  $message->add_header('content',$port);
} elsif($event eq "protocol") {
  my $protocol=$el->att('name');

  $message->add_header('content',$protocol);
} elsif($event eq "directory") {
  my $directory=$el->att('path');

  $message->add_header('content',$directory);
} elsif($event eq "page") {
  my $page=$el->att('name');

  $message->add_header('content',$page);
} else {
  lib::debug("XXXXXXXX Event type not implemented! XXXXXXXX");
  return;
}

$self->{'broker'}->{'master'}->send_message($message);

return;
}


sub PluginParseRequest {
  my $r = shift;
  *RDR=$r;

  my $line=undef
  my %req=undef;

  while($line=<RDR>) {

    chomp($line);

    if(! $line) {
      return(\%req);
    }

    if(! $req{'opcode'}) {
      if($line=~/(\w+)\s+(\d+)\.(\d+)/) {
        $req{'opcode'}=$1;
        $req{'version'}="$2.$3";
      }
    } else {
      my ($key, $val) = split(":",$line,2);
      $val=MIME::Base64::decode_base64($val);

      if(defined $key && defined $val) {
        my %kv;
        $kv{'k'}=$key;
        $kv{'v'}=$val;

        push (@{$req{kv}}, \%kv);
      }
    }
  }
}

sub decode {
  my ($self, $data) = @_;

  if(! defined $data) {
    $data=$self;
  }

  $data=MIME::Base64::decode_base64($data);
  return($data);
}

sub encode {
  my ($self, $data) = @_;

  if(! defined $data) {
    $data=$self;
  }

  $data=MIME::Base64::encode_base64($data);

  $data=~s/[\n\r]//g;
  return($data);
}

return 1;
