package httpush;

use Data::Dumper;

require Exporter;
@ISA = qw(Exporter);

@EXPORT = qw(base api);           # symbols to export by default
%EXPORT_TAGS = (api => [qw(req)], base => [qw(encode decode)]);

use MIME::Base64;

sub req {
  my($method, $uri, $protocol, $id, $record, $h)=@_;

  my %headers=%{$h};

  print STDERR Dumper(%headers);


  my $record=encode($record);
  my $method=encode($method);
  my $uri=encode($uri);
  my $protocol=encode($protocol);
  my $id=encode("$id $uri");

  print "req 1.0\n";
  print "method:$method\n";
  print "uri:$uri\n";
  print "protocol:$protocol\n";
  print "id:$id\n";
  print "record:$record\n";

  foreach $key (keys %headers) {
    my $value = $headers{$key};
    my $hv=encode("$key:$value");
    print "header:$hv\n";

    print STDERR "setting header:$hv ($key:$value)\n";

  }

  print "\n";
}

sub retrieve {
  my($id, $section)=@_;

  $id=encode($id);
  $section=encode($section);

  print "retrieve 1.0\n";
  print "id:$id\n";
  print "section:$section\n";
  print "\n";

}

sub encode {
  my $data = shift;
  $data=MIME::Base64::encode_base64($data);
  $data=~s/[\n\r]//g;
  return($data);
}

sub decode {
  my $data = shift;
  MIME::Base64::decode_base64($data);
}

return 1;
