# -*- coding: UTF8 -*-

# Python module hurestore.py
# Autogenerated from hurestore.glade
# Generated on Mon Apr 24 01:25:55 2006

# Warning: Do not modify any context comment such as #--
# They are required to keep user's code

import os
import sys

sys.path.append("../")

import gtk
import gnome

from SimpleGladeApp import SimpleGladeApp
from SimpleGladeApp import bindtextdomain

from gettext import gettext as _

import HUBackup.backend.fsMisc
from HUBackup.backend.fsMisc import fsMiscMountError, fsMiscUnMountError # import fsMisc exception
import gobject
from HUBackup.backend import fsInfo
from HUBackup.backend import BackupEngine
from HUBackup.backend.BackupEngine import NoCatalogError, NoArchiveError
import time
import pango
from HUBackup.backend.DeviceInfo import *
from hubackup import MainBackup # we shall base this class on the backup's one

DEBUG_PRINT = True

app_name = "hubackup" # our gettext translation domain
app_version = "0.0.1"

glade_dir = ""
locale_dir = "/usr/share/locale"

bindtextdomain(app_name, locale_dir)


class MainRestore(MainBackup):

    def __init__(self, path="hurestore.glade",
                 root="main_restore",
                 domain=app_name, **kwargs):
        MainBackup.__init__(self, path,root,domain, **kwargs)

    #-- MainRestore.new {
    def new(self):
        self.button_abort_discon_id = None
        self.progress_window_discon_id = None
        self.restoreWhat = "lost" # by default restore only lost files
        self.aborted = False
        self.checkForDbus()
        self.checkForHal()
        self.userinfo = fsInfo.UserInfo()
        self.restoreTo = self.userinfo.homedir()
        self.filechooserbutton3.set_current_folder(self.restoreTo)
        self.updateDeviceLists()
        self.hide_please_wait_probing_devices()
    #-- MainRestore.new }

    #-- MainRestore custom methods {
    def updateDeviceLists(self):
        # source  media device list
        self.prob_progress.set_fraction(0.5)
        self.prob_progress.set_text("50%")        
        while gtk.events_pending():
            gtk.main_iteration()
        self.populateDeviceList("treeview2", False, True, [_('Type'),_('Name')], 1, 1)
        self.prob_progress.set_fraction(1.0)
        self.prob_progress.set_text("100%")
        while gtk.events_pending():
            gtk.main_iteration()

    def stopRestore(self, widget, data=None):
        print "Abort restore requested. Stopping!"
        self.progress_window.destroy()
        self.bkpEngine.abort()
        self.aborted = True        
        self.main_restore.show()

    def finishResotre(self, widget, data=None):
        self.progress_window.destroy()
        self.main_restore.show()

    def stopBackup(self, widget, data=None):
        print "Abort restore requested. Stopping!"
        self.bkpEngine.abort()
        self.aborted = True
        self.finishResotre(None,None)

    def GUIFinish(self):
        self.progress_window.disconnect(self.progress_window_discon_id)
        self.button_abort.disconnect(self.button_abort_discon_id)
        self.button_abort.set_label("Done")
        self.button_abort.connect("clicked", self.finishResotre)        

    def GUIResotrePrepare(self):
        if DEBUG_PRINT: print "* Entering GUIResotrePrepare method."
        self.stages = ['GUIFinish']
        self.stages.reverse() # so we'll get the firs item we inserted when popping
        self.aborted = False

        # load the progess dialog glade xml
        xml = gtk.glade.XML("/usr/share/hubackup/restore-progress.glade",domain=app_name)

        # get a reference to the GtkWidgets we've created in the glade file
        self.progress_window = xml.get_widget("restore_progress_dialog")
        self.button_abort = xml.get_widget("button_abort")
        self.progressbar_restore = xml.get_widget("progressbar_restore")

        # get the current reporting output widgets
        self.pbar = self.progressbar_restore
        self.reportLabel = xml.get_widget("report_label")

        # more setup of the needed widgets
        self.progress_window.set_modal(True)
        self.progress_window.set_resizable(False)
        self.progress_window_discon_id = self.progress_window.connect("destroy", self.stopRestore)
        self.button_abort_discon_id =  self.button_abort.connect("clicked", self.stopRestore)

        # settings up the label for the detailed line outputs
        self.reportLabel.set_markup(_("<b> Starting restore operation....Please wait. </b>"))
        self.reportLabel.set_width_chars(60)
        self.reportLabel.set_max_width_chars(60)
        self.reportLabel.set_ellipsize(pango.ELLIPSIZE_END)


        try:
            bkpSourceMountPoint = fsMisc.mount(self.restore_reference_device)
        except fsMiscMountError:
            print "* Cannot mount source device. Aboring."
            dialog = gtk.MessageDialog(self.main_restore, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                       gtk.MESSAGE_WARNING,
                                       gtk.BUTTONS_OK,
                                       _("Unable to mount storage device, aborting.\n"))
            dialog.show()
            res = dialog.run()
            dialog.destroy()
            return


        self.bkpEngine = BackupEngine.Backup(referencePath=bkpSourceMountPoint+"/")


        # hide main program window.
        self.main_restore.hide()

        # show the progress window
        self.progress_window.show()        
        
        try:
            self.running = True
            self.spawnedProcOBJ =  self.bkpEngine.pre_restore_kick(restoreTarget=self.restoreTo,
                                                                   restoreArchiveType="diff",
                                                                   restoreWhat=self.restoreWhat)
        except NoArchiveError:
            if DEBUG_PRINT: print "* Diff archive not found, trying master."
            try:
                self.running = True
                self.spawnedProcOBJ =  self.bkpEngine.pre_restore_kick(restoreTarget=self.restoreTo,
                                                                       restoreArchiveType="master",
                                                                       restoreWhat=self.restoreWhat)
            except NoArchiveError:
                self.running = False
                if DEBUG_PRINT: print "* Master archive not found. aborting. Can't continue"
                dialog = gtk.MessageDialog(self.main_restore, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, 
                                           gtk.MESSAGE_WARNING,
                                           gtk.BUTTONS_OK,
                                           _("The media does not seem to contain valid HUBackup data.\n" 
                                             "Please choose another device or replace the media and try again."))
                dialog.show()
                res = dialog.run()
                dialog.destroy()
                return

        self.curBkp = self.bkpEngine.restore()
        self.cur_line = _("<b> Starting Backup Process...</b>")
               
    #-- MainRestore custom methods }

    #-- MainRestore.on_radiobutton11_toggled {
    def on_radiobutton11_toggled(self, widget, *args):
        if widget.get_active():
            self.restoreWhat = "lost"
            print "* Will restore only lost files."
        
    #-- MainRestore.on_radiobutton11_toggled }

    #-- MainRestore.on_radiobutton12_toggled {
    def on_radiobutton12_toggled(self, widget, *args):
        if widget.get_active():
            self.restoreWhat = "lost-changed"
            print "* Will restore changed and lost files."
    #-- MainRestore.on_radiobutton12_toggled }

    #-- MainRestore.on_radiobutton13_toggled {
    def on_radiobutton13_toggled(self, widget, *args):
        if widget.get_active():
            self.restoreWhat = "all-files"
            print "* Will restore all files."
    #-- MainRestore.on_radiobutton13_toggled }

    #-- MainRestore.on_media_include_toggled {
    def on_media_include_toggled(self, widget, *args):
        MainBackup.on_media_include_toggled(self, widget, *args) 
                
    #-- MainRestore.on_media_include_toggled }

    #-- MainRestore.on_button7_clicked {
    def on_button7_clicked(self, widget, *args):
        print "on_button7_clicked called with self.%s" % widget.get_name()
        print "Starting restore sequence..."
        selection = self.treeview2.get_selection()
        (model, iter) = selection.get_selected()
        print "Chosen device for source archives:"
        if iter!=None:
            self.restore_reference_device = model.get_value(iter, 4)
            print self.restore_reference_device
        else:
            self.restore_reference_device = None
            print "no device chosen for reading backup data"
            dialog = gtk.MessageDialog(self.main_restore, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, 
                                       gtk.MESSAGE_WARNING,
                                       gtk.BUTTONS_OK,
                                       _("You didn't choose a device where to find backup data on!\n" 
                                       "Please choose a device where to read backup data from and retry."))
            dialog.show()
            res = dialog.run()
            dialog.destroy()
            return

        print "run summary:"
        print "------------"
        print "* Resotre media files : %s" % self.media_include_flag
        print "* Do a differential / a reference backup location has been choosen : %s " % self.restore_reference_device
        self.restoreTo = self.filechooserbutton3.get_filename()
        print "* Will restore to : %s " % self.restoreTo
        print "* Restore type : %s " % self.restoreWhat
        self.GUIResotrePrepare()
        print "self.spawnedProcOBJ = %s" % self.spawnedProcOBJ
        print "self.spawnedProcOBJ.fileno() = %s" % self.spawnedProcOBJ.fileno()
        self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIBackup)
        gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_Backup_pty_callback)


            
        
    #-- MainRestore.on_button7_clicked }

    #-- MainRestore.on_button8_clicked {
    def on_button8_clicked(self, widget, *args):
        self.GUIVerifyPrepare(standalone=True)
    #-- MainRestore.on_button8_clicked }


#-- main {

def main():
    gnome.program_init("hurestore", "0.0.1")
    main_restore = MainRestore()

    main_restore.run()

if __name__ == "__main__":
    main()

#-- main }
