#!/usr/bin/env python
# Copyright (C) 2005-2006 Sivan Greenberg. <sivan@ubuntu.com>
# 
# This software is distributed under the terms and conditions of the GNU General
# Public License. See http://www.gnu.org/copyleft/gpl.html for details.
import os
import sys
from subprocess import *
from fsInfo import getSizeSpecifier
from DeviceInfo import *

DEBUG_MODE = False

FREE_BLOCKS_CMD = "stat --file-system --format=%a "
BLOCK_SIZE_CMD = "stat --file-system --format=%S "


class fsMiscMountError(Exception):
    pass

class fsMiscUnMountError(Exception):
    pass

class fsMiscEjectError(Exception):
    pass

def ensure_path(create, path):
    comps = path.split("/")
    comps = [i for i in comps if i!='']
    filepart = None
    root = ""
    if os.path.isfile(path):
            filepart = comps[-1]
            comps.remove(filepart)
    for part in comps:
        cur = root + "/" + part
        if not os.path.exists(cur): 
            if create: 
                os.mkdir(cur)
            print "creating directory %s" % (cur)
        root = root + "/" + part


def free_space(path):
    global FREE_BLOCKS_CMD
    global BLOCK_SIZE_CMD
    free_blocks_cmd = FREE_BLOCKS_CMD + path
    block_size = BLOCK_SIZE_CMD + path
    proc = Popen(free_blocks_cmd.split(),stderr=PIPE,stdout=PIPE)
    tmpFreeBlocks = proc.stdout.readline()
    proc = Popen(block_size.split(),stderr=PIPE,stdout=PIPE)
    tmpBlockSize = proc.stdout.readline()
    proc.stdout.flush()
    if DEBUG_MODE: print "DEBUG: %s response = [%s] " % (FREE_BLOCKS_CMD, tmpFreeBlocks)
    if DEBUG_MODE: print "DEBUG: %s response = [%s] " % (BLOCK_SIZE_CMD, tmpBlockSize)
    if DEBUG_MODE: print "DEBUG: path = %s" % path
    if DEBUG_MODE: print "DEBUG: tmpBlockSize = %s" % tmpBlockSize
    if DEBUG_MODE: print "DEBUG: tmpFreeBlocks = %s" % tmpFreeBlocks
    if tmpBlockSize != "" and tmpFreeBlocks != "":
        tmpBlockSize = int(tmpBlockSize)
        tmpFreeBlocks = int(tmpFreeBlocks)
    else:
        return -1
    return (tmpFreeBlocks * tmpBlockSize)


def mount(devnode):
    """
    Smart mount - Uses HAL to validate the devnode to an existing device,
    also returns the mount point on a successful mount.
    Fires appropriate exceptions in case of errors.

    """
    isMounted = False
    if DEBUG_MODE:
        print "* Attempting to mound %s" % devnode
    try:
        devlist = HUBDeviceDict()
    except NoHaldError:
        raise fsMiscMountError
    properties = devlist[devnode]
    try:
        isMounted = properties['Volumes'][devnode]['VolumeIsMounted']
    except KeyError:
        isMounted = False
    if isMounted:
        return properties['Volumes'][devnode]['VolumeMountPoint']
    retcode = call(["pmount",devnode])
    if retcode!=0:
        raise fsMiscMountError
    try:
        devlist = HUBDeviceDict()
    except NoHaldError:
        raise fsMiscMountError
    properties = devlist[devnode]    
    return properties['Volumes'][devnode]['VolumeMountPoint']

def dumb_mount(devnode):
    """
     Mount a device without trying to validate it through HAL.
     True - returned on success, Fail otherwise.
    """
    retcode = call(["pmount",devnode])
    if retcode!=0:
        return False
    else:
        return True
    

def unmount(devnode):
    if DEBUG_MODE:
        print "* Attempting to unmount %s" % devnode
    retcode = call(["pumount",devnode])
    if retcode!=0:
        raise fsMiscUnMountError


def eject(devnode):
    if DEBUG_MODE:
        print "* Attempting to eject %s" % devnode
    retcode = call(["eject",devnode])
    if retcode!=0:
        raise fsMiscEjectError
    
if __name__ == "__main__":
    if sys.argv[1]=="-c":
        create = True
        path = sys.argv[2]
    else:
        create = False
        path = sys.argv[1]
    ensure_path(create,path)
    print "Free space on deivce:%s%s" %( getSizeSpecifier(free_space(path)))
