/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>

#include <openssl/ssl.h>
#include <openssl/err.h>

#include <msgapi.h>
#include <nmap.h>

#include "modwebp.h"

unsigned char	*ModWebRVersion = "$Revision: 1.2 $";

int
MWStreamFromMemory(StreamStruct *Codec, StreamStruct *NextCodec)
{
	NextCodec->Start=(unsigned char *)Codec->StreamData;
	NextCodec->End=(unsigned char *)Codec->StreamData+Codec->StreamLength;
	NextCodec->Len=Codec->StreamLength;
	NextCodec->EOS=TRUE;
	return(NextCodec->Codec(NextCodec, NextCodec->Next));
}

int
MWStreamFromChunkedMemory(StreamStruct *Codec, StreamStruct *NextCodec)
{
#define	CHUNK_SIZE		20
	unsigned long	Len=0;
	unsigned char	*Out;

	while (Len<Codec->StreamLength) {
		memcpy(NextCodec->Start+NextCodec->Len, (unsigned char *)Codec->StreamData+Len, CHUNK_SIZE);
		NextCodec->Len+=CHUNK_SIZE;
		NextCodec->End=NextCodec->Start+NextCodec->Len;
		Len+=CHUNK_SIZE;
		if (Len>=Codec->StreamLength) {
			NextCodec->EOS=TRUE;
		}
		
		Out=NextCodec->Start+NextCodec->Len;
		NextCodec->Len-=NextCodec->Codec(NextCodec, NextCodec->Next);
		memmove(NextCodec->Start, Out, NextCodec->End-Out);
	}

	return(Codec->StreamLength);
}

int
MWStreamToMemory(StreamStruct *Codec, StreamStruct *NextCodec)
{
	Codec->StreamData=(void *)MemRealloc(Codec->StreamData, Codec->Len+Codec->StreamLength+1);
	if (Codec->StreamData) {
		memcpy((unsigned char *)Codec->StreamData+Codec->StreamLength, Codec->Start, Codec->Len);
		Codec->StreamLength+=Codec->Len;
	}
	return(Codec->Len);
}

int
MWStreamFromFile(StreamStruct *Codec, StreamStruct *NextCodec)
{
	unsigned long   Count=0;
	unsigned long   Read;
	unsigned char   *Out;

	while (!feof(((FILE *)(Codec->StreamData))) && !ferror(((FILE *)(Codec->StreamData)))) {
		Read=fread(NextCodec->Start+NextCodec->Len, sizeof(unsigned char), NextCodec->End-NextCodec->Start-NextCodec->Len, (FILE *)Codec->StreamData);
		if (Read>0) {
			//NextCodec->Start[NextCodec->Len+Read]='\0';
			Out=NextCodec->Start+NextCodec->Len+Read;
			Count+=Read;
			NextCodec->Len+=Read;
			NextCodec->Len-=NextCodec->Codec(NextCodec, NextCodec->Next);
			memmove(NextCodec->Start, Out-NextCodec->Len, NextCodec->Len);
		}
	}
	NextCodec->EOS=TRUE;
	NextCodec->Len-=NextCodec->Codec(NextCodec, NextCodec->Next);
	return(Count);
}

int
MWStreamToFile(StreamStruct *Codec, StreamStruct *NextCodec)
{

	if (Codec->StreamData) {
		fwrite(Codec->Start, Codec->Len, 1, (FILE *)Codec->StreamData);
	}
	return(Codec->Len);
}

int
MWStreamFromMWNMAP(StreamStruct *Codec, StreamStruct *NextCodec)
{
	long				len;
	long				Count=Codec->StreamLength;
	unsigned long	BufferSize;
	SessionStruct	*Session=(SessionStruct *)Codec->StreamData;
	unsigned char	*Out;

	while ((Session->NBufferPtr>0) && (Count>0)) {
		BufferSize=NextCodec->End-NextCodec->Start-NextCodec->Len;
		Out=NextCodec->Start+NextCodec->Len;

		if (Session->NBufferPtr>Count) {
			if (BufferSize>Count) {
				/* Can read the whole thing */
				memcpy(Out, Session->NBuffer, Count);
				memmove(Session->NBuffer, Session->NBuffer+Count, Session->NBufferPtr-Count+1);
				NextCodec->Len+=Count;
				Session->NBufferPtr-=Count;
				Count=0;
			} else {
				/* Only read a chunk */
				memcpy(Out, Session->NBuffer, BufferSize);
				memmove(Session->NBuffer, Session->NBuffer+BufferSize, Session->NBufferPtr-BufferSize+1);
				NextCodec->Len+=BufferSize;
				Session->NBufferPtr-=BufferSize;
				Count-=BufferSize;
			}
		} else {
			/* Not enough data in buffer, will have to get more from network */
			if (Session->NBufferPtr>BufferSize) {
				/* Stream buffer too small for all data */
				memcpy(Out, Session->NBuffer, BufferSize);
				memmove(Session->NBuffer, Session->NBuffer+BufferSize, Session->NBufferPtr-BufferSize+1);
				NextCodec->Len+=BufferSize;
				Session->NBufferPtr-=BufferSize;
				Count-=BufferSize;
			} else {
				/* Read the whole thing */
				memcpy(Out, Session->NBuffer, Session->NBufferPtr);
				NextCodec->Len+=Session->NBufferPtr;
				Count-=Session->NBufferPtr;
				Session->NBufferPtr=0;
			}
		}
		Out=NextCodec->Start+NextCodec->Len;
		if (Count<=0) {
			NextCodec->EOS=TRUE;
		}
		NextCodec->Len-=NextCodec->Codec(NextCodec, NextCodec->Next);
		memmove(NextCodec->Start, Out-NextCodec->Len, NextCodec->Len);
	}

	while (Count>0) {
		Out=NextCodec->Start+NextCodec->Len;
		BufferSize=NextCodec->End-Out;
		if (Count<BufferSize) {
			len=MWDirectNMAPRead(Session, Out, Count);
		} else {
			len=MWDirectNMAPRead(Session, Out, BufferSize);
		}
		if (len>0) {
			Count-=len;
			NextCodec->Len+=len;
			len=NextCodec->Len;
			if (Count<=0) {
				NextCodec->EOS=TRUE;
			}
			Out=NextCodec->Start+NextCodec->Len;
			NextCodec->Len-=NextCodec->Codec(NextCodec, NextCodec->Next);
			memmove(NextCodec->Start, Out-NextCodec->Len, NextCodec->Len);
		} else {
			break;
		}
	}
	return(Codec->StreamLength);
}

int
MWStreamToMWClient(StreamStruct *Codec, StreamStruct *NextCodec)
{
	if (Codec->StreamData) {
		MWSendClient((ConnectionStruct *)Codec->StreamData, Codec->Start, Codec->Len);
	}
	return(Codec->Len);
}


StreamStruct
*MWGetStream(StreamStruct *PrevCodec, unsigned char *Charset, BOOL Encoder)
{
	StreamDescStruct        *StreamListPtr=MWStreamList;
	StreamStruct            *Stream;
	unsigned long           i=0;

	Stream=(StreamStruct *)MemMalloc(sizeof(StreamStruct)+sizeof(unsigned char)*BUFSIZE);
	if (!Stream) {
		return(FALSE);
	}

	memset(Stream, 0, sizeof(StreamStruct));
	Stream->Start=(unsigned char *)Stream+sizeof(StreamStruct);
	Stream->End=Stream->Start+BUFSIZE;

	if (Charset) {
		while (StreamListPtr[i].Charset!=NULL) {
			if (MWQuickCmp(Charset, StreamListPtr[i].Charset)) {
				if (Encoder) {
					Stream->Codec=StreamListPtr[i].Encoder;
				} else {
					Stream->Codec=StreamListPtr[i].Decoder;
				}
				if (!Stream->Codec) {
					MemFree(Stream);
					return(NULL);
				}
				if (PrevCodec) {
					PrevCodec->Next=Stream;
				}
				return(Stream);
			}
			i++;
		}
	} else {
		if (PrevCodec) {
			PrevCodec->Next=Stream;
		}
		return(Stream);
	}

	MemFree(Stream);
	return(NULL);
}

BOOL
MWReleaseStream(StreamStruct *Stream)
{
	if (!Stream) {
		return(FALSE);
	}

	MemFree(Stream);
	return(TRUE);
}

BOOL
MWReleaseStreamData(void *Data)
{
	MemFree(Data);
	return(TRUE);
}

StreamCodecFunc
MWFindCodec(unsigned char *Charset, BOOL Encoder)
{
	StreamDescStruct        *StreamListPtr=MWStreamList;
	unsigned long           i=0;

	while (StreamListPtr[i].Charset!=NULL) {
		if (MWQuickCmp(Charset, StreamListPtr[i].Charset)) {
			if (Encoder) {
				return(StreamListPtr[i].Encoder);
			} else {
				return(StreamListPtr[i].Decoder);
			}
		}
		i++;
	}

	return(NULL);
}

BOOL
MWAddStreamTemplateHandler(unsigned char *Charset, TemplateHandlerFunc Handler)
{
	StreamDescStruct        *StreamListPtr=MWStreamList;
	unsigned long           i=0;

	while (StreamListPtr[i].Charset!=NULL) {
		if (MWQuickCmp(Charset, StreamListPtr[i].Charset)) {
			StreamListPtr[i].TemplateHandler=Handler;
			return(TRUE);
		}
		i++;
	}
	return(FALSE);
}


BOOL
MWResetStreamChain(StreamStruct *Stream) 
{
	while (Stream) {
		Stream->EOS=FALSE;
		Stream->Len=0;
		Stream->State=0;
		Stream=Stream->Next;
	}
	return(TRUE);
}

StreamDescStruct
*MWGetStreamTable(void)
{
	return(MWStreamList);
}
