/****************************************************************************
 *
 * Copyright (c) 1997-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>

#include "nmapdp.h"

/* fixme - we should no longer be using file based locks. */
BOOL
SCMSWaitforAndLockMessage(unsigned long id)
{
    int timeout = MAILBOX_TIMEOUT;
    unsigned long offset;
    unsigned char path[XPL_MAX_PATH + 1];
    BOOL done = FALSE;
    XplSemaphore mbSemaphore;
    struct stat sb;
    FILE *handle;

    offset = id & MBOX_LOCK_ARRAY_SIZE;
    mbSemaphore = NMAP.lock.mailbox.sems[offset & 0x7F];

    sprintf(path,"%s/%x/%lx.lck", NMAP.path.scms, (unsigned int)(id % 16), id);

    do {
        /* This block acquires the memory lock */
        while (!done && timeout!=0) {
            timeout--;
            XplWaitOnLocalSemaphore(mbSemaphore);
            if (NMAP.lock.mailbox.array[offset]==0) {
                NMAP.lock.mailbox.array[offset]=1;
                XplSignalLocalSemaphore(mbSemaphore);
                done=TRUE;
            } else {
                XplSignalLocalSemaphore(mbSemaphore);
                XplDelay(111);
            }
        }

        /* Did we time out? */
        if (!done) {
            return(FALSE);
        }
        
        /* This checks for a disk lock and loops back if an existing lock is found */
        if (stat(path, &sb)==0 && (sb.st_mtime>=NMAP.time.startup)) {

            XplWaitOnLocalSemaphore(mbSemaphore);
            NMAP.lock.mailbox.array[offset]=0;
            XplSignalLocalSemaphore(mbSemaphore);

            done = FALSE;
            XplDelay(333);
        }
    } while (!done);

    /* We can create our lock now */
    handle=fopen(path,"w+b");
    if (handle) {
        fclose(handle);
    } 

    /* Open the slot */
    XplWaitOnLocalSemaphore(mbSemaphore);
    NMAP.lock.mailbox.array[offset]=0;
    XplSignalLocalSemaphore(mbSemaphore);

    return(TRUE);
}

/* fixme - we should no longer be using file based locks. */
void
SCMSUnlockMessage(unsigned long id)
{
    unsigned char path[XPL_MAX_PATH+1];

    sprintf(path,"%s/%x/%lx.lck",NMAP.path.scms, (unsigned int)(id % 16), id);

    unlink(path);

    return;
}

unsigned long
SCMSStoreMessage(FILE *data, unsigned long size, unsigned char *sender, unsigned char *authSender)
{
    size_t count;
    unsigned long id;
    unsigned char answer[CONN_BUFSIZE + 1];
    FILE *scmcFH;

    /*  A scmcFH entry consists of a single 6 digit number (the usage count), leading 0's, terminated by CR/LF,
        the size of the message (10 digits, leading 0's), terminated by CR/LF
        and the message itself

        Find a unique queue name */
    do {
        id = NMAP.queue.id++;
        sprintf(answer, "%s/%x/%lx",NMAP.path.scms, (unsigned int)(id % 16), id);
    } while (!access(answer, 0));

    scmcFH = fopen(answer, "wb");
    if (!scmcFH) {
        return(0);
    }

    if (authSender && authSender[0]!='-') {
        size += fprintf(scmcFH, "X-Auth+OK: %s\r\n", authSender);
    } else {
        size += fprintf(scmcFH, "X-Auth-No: \r\n");
    }

    size += fprintf(scmcFH, "Return-Path: <%s>\r\n", sender);

    while(!feof(data) && !ferror(data)) {
        count = fread(answer, sizeof(unsigned char), sizeof(answer), data);
        if (count > 0)
            if (fwrite(answer, sizeof(unsigned char), count, scmcFH) < count) {
                fclose(scmcFH);
                rewind(data);

                /* fixme - check for diskspace upfront */
                return(0);
            }
    }

    if (!(NMAP.flushFlags & FLUSH_BOX_ON_STORE)) {
        fclose(scmcFH);
    } else {
        XplFlushWrites(scmcFH);
        fclose(scmcFH);
    }

    sprintf(answer, "%s/%x/%lx.cnt",NMAP.path.scms, (unsigned int)(id % 16), id);
    scmcFH = fopen(answer, "wb");
    fprintf(scmcFH,"%06d\r\n",0);
    fprintf(scmcFH,"%010ld\r\n",size);

    if (!(NMAP.flushFlags & FLUSH_BOX_ON_STORE)) {
        fclose(scmcFH);
    } else {
        XplFlushWrites(scmcFH);
        fclose(scmcFH);
    }

    XplSafeAdd(NMAP.stats.storedLocal.bytes, (size + 1023) / 1024);
    XplSafeIncrement(NMAP.stats.storedLocal.count);

    rewind(data);

    return(id);
}

unsigned long
SCMSGetMessageSize(unsigned long id)
{
    unsigned long size;
    unsigned char answer[CONN_BUFSIZE+1];
    FILE *scmsFH;

    sprintf(answer, "%s/%x/%lx.cnt", NMAP.path.scms, (unsigned int)(id % 16), id);
    if (!SCMSWaitforAndLockMessage(id)) {
        return(0);
    }

    scmsFH = fopen(answer, "rb");
    if (!scmsFH) {
        SCMSUnlockMessage(id);
        return(0);
    }

    fgets(answer, sizeof(answer), scmsFH);
    fgets(answer, sizeof(answer), scmsFH);

    size = atol(answer);

    fclose(scmsFH);

    SCMSUnlockMessage(id);

    return(size);
}

BOOL
SCMSStoreMessageReference(unsigned long id)
{
    long referenceCount;
    long len;
    unsigned char answer[CONN_BUFSIZE+1];
    FILE *scmsFH;

    sprintf(answer,"%s/%x/%lx.cnt",NMAP.path.scms, (unsigned int)(id % 16), id);
    if (!SCMSWaitforAndLockMessage(id)) {
        return(FALSE);
    }

    scmsFH = fopen(answer, "r+b");
    if (!scmsFH) {
        SCMSUnlockMessage(id);
        return(FALSE);
    }

    fgets(answer, sizeof(answer), scmsFH);

    referenceCount = atol(answer);
    referenceCount++;

    fseek(scmsFH, 0, SEEK_SET);
    len = sprintf(answer, "%06ld\r\n", referenceCount);

    fwrite(answer, len, 1, scmsFH);

    fclose(scmsFH);

    SCMSUnlockMessage(id);

    return(TRUE);
}

BOOL
SCMSDeleteMessage(unsigned long id)
{
    long referenceCount;
    long len;
    unsigned char answer[CONN_BUFSIZE + 1];
    FILE *scmsFH;

    sprintf(answer,"%s/%x/%lx.cnt",NMAP.path.scms, (unsigned int)(id % 16), id);
    if (!SCMSWaitforAndLockMessage(id)) {
        return(FALSE);
    }

    scmsFH = fopen(answer, "r+b");
    if (!scmsFH) {
        SCMSUnlockMessage(id);
        return(FALSE);
    }

    fgets(answer, sizeof(answer), scmsFH);

    referenceCount = atol(answer);
    referenceCount--;

    if (referenceCount > 0) {
        /* Still someone using this one */
        len = sprintf(answer, "%06ld\r\n", referenceCount);

        fseek(scmsFH, 0, SEEK_SET);
        fwrite(answer, len, 1, scmsFH);
        fclose(scmsFH);
    } else {
        sprintf(answer,"%s/%x/%lx.cnt", NMAP.path.scms, (unsigned int)(id % 16), id);

        fclose(scmsFH);
        unlink(answer);

        sprintf(answer,"%s/%x/%lx", NMAP.path.scms, (unsigned int)(id % 16), id);
        unlink(answer);
    }

    SCMSUnlockMessage(id);

    return(TRUE);
}
