/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>

#include <openssl/ssl.h>
#include <openssl/err.h>

#include <mdb.h>

#include "webadminp.h"

BOOL
HandlePublicImage(ConnectionStruct *Client, unsigned long Language, unsigned long ImageID)
{
	unsigned char	*Image;
	unsigned long	Length;

	Client->KeepAlive=TRUE;
	if (ImageID>=PublicTemplate->ImageCount || Language>=PublicTemplate->LanguageCount) {
		Client->KeepAlive=FALSE;
		return(FALSE);
	}

	Image=PublicTemplateImages[Language][ImageID];

	Length=*(unsigned long *)Image;
	Image+=sizeof(unsigned long);

	if (Image[0]=='G') {
		WASendHTTPHeader(Client, "image/gif", Length, NULL, TRUE);
	} else {
		WASendHTTPHeader(Client, "image/jpeg", Length, NULL, TRUE);
	}
	WASendClient(Client, Image, Length);

	return(TRUE);
}


BOOL
WAHandlePublicTemplate(ConnectionStruct *Client, SessionStruct *Session, unsigned long TemplateID)
{
    TemplateObjectOverlay *localObject;
	unsigned char				URL[256];
	unsigned long				ReplyInt;
	unsigned char				*nextTokenAddress;
	TokenOverlayStruct		*Token;
	register unsigned char	*ptr;

	if (!Session->Pages) {
		Client->KeepAlive=FALSE;
		return(FALSE);
	}

	localObject = Session->Pages[TemplateID];
	nextTokenAddress = localObject->Object;
	Token = (TokenOverlayStruct *)nextTokenAddress;

	SendHTTPHeaderDynamic(Client, localObject->ContentType, localObject->ContentTypeLen);

NextToken:
	while (Token->TokenID!=0) {
		switch(Token->TokenID) {
			case T_TEXT: {
				WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				break;
			}

			case T_QSTRING:
			case T_STRING: {
				ptr=Session->Strings[Token->ArgumentOffsetOrID[0]];
				WASendClient(Client, ptr, strlen(ptr));
				break;
			}

			case T_IMAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_PUBLIC, DISPLAY_IMAGE, Session->Language, Token->ArgumentOffsetOrID[0], 0, 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_PAGEID:
			case T_PAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_PUBLIC, DISPLAY_TEMPLATE, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_APP_TITLE: {
				if (DefaultTitle) {
					WASendClient(Client, DefaultTitle, strlen(DefaultTitle));
				} else {
					WASendClient(Client, PublicTemplate->Name, strlen(Templates[Session->TemplateID]->Name));
				}
				break;
			}

			case T_COLOR: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_PAGEFG: {
						WASendClient(Client, Session->Colors[COLOR_PAGE_FG], 6);
						break;
					}

					case AA_PAGEBG: {
						WASendClient(Client, Session->Colors[COLOR_PAGE_BG], 6);
						break;
					}

					case AA_BORDERFG: {
						WASendClient(Client, Session->Colors[COLOR_BORDER_FG], 6);
						break;
					}

					case AA_BORDERBG: {
						WASendClient(Client, Session->Colors[COLOR_BORDER_BG], 6);
						break;
					}

					case AA_SECTIONFG: {
						WASendClient(Client, Session->Colors[COLOR_SECTION_FG], 6);
						break;
					}

					case AA_SECTIONBG: {
						WASendClient(Client, Session->Colors[COLOR_SECTION_BG], 6);
						break;
					}

					case AA_FIELDNAMEFG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDNAME_FG], 6);
						break;
					}

					case AA_FIELDNAMEBG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDNAME_BG], 6);
						break;
					}

					case AA_FIELDBODYFG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDBODY_FG], 6);
						break;
					}

					case AA_FIELDBODYBG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDBODY_BG], 6);
						break;
					}
				}
				break;
			}


			default: {
				unsigned long	i;
				unsigned long	GotoToken;

				for (i=0; i<TModuleCount; i++) {
					if (TModules[i].TokenRangeStart<=Token->TokenID && Token->TokenID<=TModules[i].TokenRangeEnd) {
						ReplyInt=TModules[i].HandleTemplate(Client, Session, TemplateID, Token, &GotoToken, NULL);

						if (ReplyInt==TOKEN_DONE) {
							nextTokenAddress+=Token->Length;
							Token=(TokenOverlayStruct *)nextTokenAddress;
							goto NextToken;
						} else if (ReplyInt==TOKEN_MOVE_FORWARD) {
							while (Token->TokenID!=GotoToken && Token->TokenID!=0) {
								nextTokenAddress+=Token->Length;
								Token=(TokenOverlayStruct *)nextTokenAddress;
							}
							goto NextToken;
						} else if (ReplyInt==TOKEN_MOVE_BACKWARD) {
							while (Token->TokenID != GotoToken && (unsigned char *)Token != localObject->Object) {
								nextTokenAddress-=Token->PrevSize;
								Token=(TokenOverlayStruct *)nextTokenAddress;
							}
							goto NextToken;
						}
					}
				}

				break;
			}
		}
		nextTokenAddress+=Token->Length;
		Token=(TokenOverlayStruct *)nextTokenAddress;
	} 
	return(TRUE);
}

BOOL
HandlePublicURL(ConnectionStruct *Client, URLStruct *URL)
{
	SessionStruct	Session;

	memset(&Session, 0, sizeof(Session));
	SetPublicSessionTemplate(Client, &Session);

	switch(URL->Request) {
		case DISPLAY_TEMPLATE: {
			Client->KeepAlive=FALSE;
			WAHandlePublicTemplate(Client, &Session, URL->Argument[0]);
			return(TRUE);
		}

		case DISPLAY_IMAGE: {
			HandlePublicImage(Client, URL->Argument[0], URL->Argument[1]);
			return(TRUE);
		}

		case DISPLAY_LOGO: {
			HandleLogo(Client, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_LOGIN: {
			WADebug("Have logout request\n");
			Client->KeepAlive=FALSE;
			WAHandleTemplate(Client, &Session, URL->Argument[0], TRUE);
			Client->Session=NULL;
			return(TRUE);
		}

		default: {
			unsigned long	i;

			Client->KeepAlive=FALSE;
			for (i=0; i<TModuleCount; i++) {
				if (TModules[i].TokenRangeStart<=URL->Request && URL->Request<=TModules[i].TokenRangeEnd) {
					if (TModules[i].HandleURL(Client, &Session, URL, NULL)) {
						break;
					}
				}
			}
			break;
		}
	}

	return(TRUE);
}
