/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <mwtempl.h>

#include <webadmin.tok>
#include <webadmin.ary>

/* Generic */
#define  BUFSIZE						1023  
#define  MTU							(1480*3)
#define	SERVER_NAME					"Novell-NetMail-WebAdmin-Server/1.0"
#define	MAX_SESSION_ENTRIES		500
#define	MAX_TSESSION_ENTRIES		50
#define	MAX_LANGUAGES				100
#define	CONNECTION_CACHE_SIZE	100
#define	POST_ALLOC_BLOCK			20
#define	TEMPLATE_EXTENSION		".wat"
#define	MODULE_EXTENSION			XPL_DLL_EXTENSION
#define	PUBLIC_TEMPLATE_NAME		"public"
#define	SELECT_TEMPLATE_NAME		"select"

#define	MODWEB_STACK_SPACE	48*1024

#define	ChopNL(String)		{ char *pTr; pTr=strrchr((String), 0x0a);	if (pTr)	*pTr='\0'; pTr=strrchr((String), 0x0d); if (pTr) *pTr='\0'; }

/** Request definitions (submitted via URL) **/

/* Request type */
#define	DISPLAY_LOGO				6
#define	REQUEST_RELOGIN			7
#define	REQUEST_CREATE_PAGE		9
#define	REQUEST_DELETE				11
#define	REQUEST_RENAME				12
#define	DISPLAY_STATIC_PAGE		14
#define	REQUEST_DEFINE_FILTER	15
#define	REQUEST_CLEAR_FILTER		16
#define	REQUEST_BROWSE				17
#define	REQUEST_CREATE_OBJECT	18
#define	REQUEST_MODIFY_OBJECT	19
#define	REQUEST_FLAG				20
#define	SWITCH_TEMPLATE			21
#define	REQUEST_SELECT_OBJECT	22

/* Device type */
#define	DEVICE_HTML		0
#define	DEVICE_WML		1

/* Directory error codes */
#define DSERR_NO_DELETE_PRIVILEGE					0xFFFFFF76
#define ERR_NO_SUCH_ENTRY								0xFFFFFDA7
#define ERR_NO_SUCH_VALUE								0xFFFFFDA6
#define ERR_NO_SUCH_ATTRIBUTE							0xFFFFFDA5
#define ERR_NO_SUCH_CLASS								0xFFFFFDA4
#define ERR_NO_SUCH_PARTITION							0xFFFFFDA3
#define ERR_ENTRY_ALREADY_EXISTS						0xFFFFFDA2
#define ERR_NOT_EFFECTIVE_CLASS 						0xFFFFFDA1
#define ERR_ILLEGAL_ATTRIBUTE							0xFFFFFDA0
#define ERR_MISSING_MANDATORY							0xFFFFFD9F
#define ERR_ILLEGAL_DS_NAME 							0xFFFFFD9E
#define ERR_ILLEGAL_CONTAINMENT 						0xFFFFFD9D
#define ERR_CANT_HAVE_MULTIPLE_VALUES				0xFFFFFD9C
#define ERR_SYNTAX_VIOLATION							0xFFFFFD9B
#define ERR_DUPLICATE_VALUE 							0xFFFFFD9A
#define ERR_ATTRIBUTE_ALREADY_EXISTS				0xFFFFFD99
#define ERR_MAXIMUM_ENTRIES_EXIST					0xFFFFFD98
#define ERR_DATABASE_FORMAT 							0xFFFFFD97
#define ERR_INCONSISTENT_DATABASE					0xFFFFFD96
#define ERR_INVALID_COMPARISON						0xFFFFFD95
#define ERR_COMPARISON_FAILED							0xFFFFFD94
#define ERR_TRANSACTIONS_DISABLED					0xFFFFFD93
#define ERR_INVALID_TRANSPORT							0xFFFFFD92
#define ERR_SYNTAX_INVALID_IN_NAME					0xFFFFFD91
#define ERR_TRANSPORT_FAILURE							0xFFFFFD8F
#define ERR_ALL_REFERRALS_FAILED						0xFFFFFD8E
#define ERR_CANT_REMOVE_NAMING_VALUE				0xFFFFFD8D
#define ERR_OBJECT_CLASS_VIOLATION					0xFFFFFD8C
#define ERR_ENTRY_IS_NOT_LEAF							0xFFFFFD8B
#define ERR_DIFFERENT_TREE								0xFFFFFD8A
#define ERR_SYSTEM_FAILURE								0xFFFFFD88
#define ERR_INVALID_ENTRY_FOR_ROOT					0xFFFFFD87
#define ERR_NO_REFERRALS								0xFFFFFD86
#define ERR_REMOTE_FAILURE								0xFFFFFD85
#define ERR_UNREACHABLE_SERVER						0XFFFFFD84
#define ERR_NO_CHARACTER_MAPPING						0XFFFFFD82
#define ERR_INCOMPLETE_AUTHENTICATION				0XFFFFFD81
#define ERR_INVALID_CERTIFICATE 						0xFFFFFD80
#define ERR_INVALID_REQUEST 							0xFFFFFD7F
#define ERR_INVALID_ITERATION							0xFFFFFD7E
#define ERR_SCHEMA_IS_NONREMOVABLE					0xFFFFFD7D
#define ERR_SCHEMA_IS_IN_USE							0xFFFFFD7C
#define ERR_CLASS_ALREADY_EXISTS						0xFFFFFD7B
#define ERR_BAD_NAMING_ATTRIBUTES					0xFFFFFD7A
#define ERR_INSUFFICIENT_STACK						0xFFFFFD78
#define ERR_INSUFFICIENT_BUFFER 						0xFFFFFD77
#define ERR_AMBIGUOUS_CONTAINMENT					0xFFFFFD76
#define ERR_AMBIGUOUS_NAMING							0xFFFFFD75
#define ERR_DUPLICATE_MANDATORY 						0xFFFFFD74
#define ERR_DUPLICATE_OPTIONAL						0xFFFFFD73
#define ERR_RECORD_IN_USE								0xFFFFFD6C
#define ERR_ENTRY_NOT_CONTAINER 						0xFFFFFD64
#define ERR_FAILED_AUTHENTICATION					0xFFFFFD63
#define ERR_INVALID_CONTEXT 							0xFFFFFD62
#define ERR_NO_SUCH_PARENT								0xFFFFFD61
#define ERR_NO_ACCESS									0xFFFFFD60
#define ERR_INVALID_NAME_SERVICE						0xFFFFFD5E
#define ERR_INVALID_TASK								0xFFFFFD5D
#define ERR_INVALID_CONN_HANDLE 						0xFFFFFD5C
#define ERR_INVALID_IDENTITY							0xFFFFFD5B
#define ERR_DUPLICATE_ACL								0xFFFFFD5A
#define ERR_ALIAS_OF_AN_ALIAS							0xFFFFFD57
#define ERR_INVALID_RDN 								0xFFFFFD4E
#define ERR_INCORRECT_BASE_CLASS						0xFFFFFD4C
#define ERR_MISSING_REFERENCE							0xFFFFFD4B
#define ERR_LOST_ENTRY									0xFFFFFD4A
#define ERR_FATAL											0xFFFFFD45

/* Global Struct */
typedef struct {
    /* options */
    BOOL CheckDiskForTemplateUpdates;
} WebAdminGlobals;

extern WebAdminGlobals WebAdmin;

/* Class information set in the template */
typedef struct {
	unsigned char	*Class;
	unsigned long	Image;
	unsigned long	TemplateID;
	unsigned	char	*Description;
} ClassInfoStruct;

/* To remember form data for timed-out sessions */
typedef struct _TSessionStruct {
	/* A unique session identifier */
	unsigned long	SessionID;
	unsigned long	SessionUID;
	time_t			Timestamp;
} TSessionStruct;

typedef struct _ObjectListStruct {
	struct _ObjectListStruct	*Next;								/* Next container at the same level */
	struct _ObjectListStruct	*Parent;								/* Parent container */
	struct _ObjectListStruct	*Child;								/* First child container */
	unsigned char					Name[MDB_MAX_OBJECT_CHARS+1];	/* Full DN */
	BOOL								Expanded;							/* Display children of this container? */
	BOOL								Displayed;							/* Has this already been displayed once */
} ObjectListStruct;

typedef struct _TaskStruct {
	unsigned char		*Pages;
	unsigned long		Count;
	unsigned long		ResultPage;

	unsigned long		Template;
	unsigned char		Name[MDB_MAX_OBJECT_CHARS+1];
} TaskStruct;

typedef struct _SessionStruct {
	/* MDB Rights */
	MDBHandle			AuthHandle;

	/* User data, public */
	unsigned char		*User;
	unsigned char		*UserDN;
	unsigned long		Language;
	unsigned char		Colors[10][7];
	unsigned char		*Charset;
	unsigned char		*EMailAddress;
	unsigned char		*OfficialDomain;

	/* User preferences */
	unsigned long		ItemsPerPage;

	/* Mailstore address */
	struct in_addr		NMAPAddress;

	/* Template data */
	long					TemplateID;
	unsigned char		**Strings;
	unsigned char		**Images;
	TemplateObjectOverlay **Pages;
	TemplateObjectOverlay **StaticPages;
	MDBValueStruct		*AllowedTemplates;

	/* NMAP Connection */
	int					NMAPs;					/* NMAP Socket					*/
	int					NBufferPtr;				/* Current NMAP pointer		*/
	unsigned char		NBuffer[BUFSIZE+1];	/* NMAP Input buffer			*/

	MDBValueStruct		*V;

	/* Error Handling */
	unsigned long		LastError;
	MDBValueStruct		*ErrorNames;
	MDBValueStruct		*ErrorStrings;

	/* Form Handling */
	MDBValueStruct		*LastFormNames;
	MDBValueStruct		*LastFormValues;

	/* The current object */
	unsigned char		CurrentObject[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		CurrentTree[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		CurrentClass[MDB_MAX_OBJECT_CHARS+1];

	/* A unique session identifier */
	unsigned long		SessionID;
	/** 
		Here starts the private part of the structure
		Do not alter the order of above entries without
		simultaneously updating the published webadm.h
		header file
	**/

	/* NMAP Connection; private part */
	SSL					*NSSL;					/* SSL connection info		*/
	unsigned char		NMAPSSL;

	/* User data, private */
	unsigned long		LogoID;
	unsigned long		ConnectionTimeout;
	unsigned char		*Title;

	/* Session internals */
	time_t				Timestamp;
	unsigned long		SessionUID;
	BOOL					MailboxChanged;
	void					**ModuleData;
	MDBValueStruct		*CachedValues;
	unsigned long		Flags;
	unsigned char		Key[32 + 1];

	/* Context */
	unsigned char		CurrentCreateClass[MDB_MAX_OBJECT_CHARS+1];

	BOOL					FilterContainers;
	unsigned char		CurrentFilterClass[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		CurrentFilterName[MDB_MAX_OBJECT_CHARS+1];

	BOOL					BrowseContainers;
	unsigned char		BrowseFilterClass[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		BrowseFilterName[MDB_MAX_OBJECT_CHARS+1];

	unsigned char		ObjectBuffer[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		TemplateBuffer[MDB_MAX_OBJECT_CHARS+1];


	/* Class management */
	unsigned long		ClassListAlloc;
	unsigned long		ClassListCount;
	ClassInfoStruct	*ClassList;
	unsigned long		UnknownImage;
	unsigned long		UnknownImageTemplate;

	/* Enumeration of objects */
	ObjectListStruct	*ObjectListCache;
	ObjectListStruct	*ObjectListCurrent;
	MDBEnumStruct		*ObjectListEnum;
	MDBValueStruct		*ObjectListV;
	unsigned long		ObjectListCount;
	unsigned long		ObjectListIndention;
	unsigned char		*ObjectListElement;
	BOOL					CurrentElementIsContainer;
	unsigned char		ObjectListClass[MDB_MAX_OBJECT_CHARS+1];
	unsigned char		*ObjectListCurrentClass;

	/* Browse */
	ObjectListStruct	*BrowseListCache;
	unsigned char		BrowseLocation[MDB_MAX_OBJECT_CHARS];

	/* Tasks */
	TaskStruct			Task;
	unsigned long		InitialTemplate;
	unsigned char		returnURL[256];
} SessionStruct;


typedef struct _ConnectionStruct {
	int						s;							/* Socket						*/
	SessionStruct			*Session;				/* Current session			*/
	unsigned char			Temp[BUFSIZE+1];		/* Temp work buffer			*/
	struct sockaddr_in	cs;						/* Client info					*/
	BOOL						KeepAlive;				/* Keep connection?			*/
	unsigned char			Command[BUFSIZE+1];	/* Current command			*/
	unsigned char			*URLExtra;				/* Addtl. URL info			*/
	BOOL						NMAPProtected;			/* NMAP Transaction active	*/
	unsigned char			ClientSSL;				/* Doing SSL?					*/
	unsigned long			DeviceType;				/* Current Device Type		*/

	/** 
		Here starts the private part of the structure
		Do not alter the order of above entries without
		simultaneously updating the published webadm.h
		header file
	**/

	BOOL						State;					/* State							*/
	SSL						*CSSL;					/* SSL connection info		*/
	int						BufferPtr;				/* Current input pointer	*/
	unsigned char			Buffer[BUFSIZE+1];	/* Input buffer				*/
	int						SBufferPtr;				/* Send Buffer Pointer		*/
	unsigned char			SBuffer[MTU+1];		/* Send Buffer [speedup]	*/
	unsigned char			Credentials[256 * 2 + 1];	/* HTTP Auth*/
	unsigned long			ContentLength;			/* Length of form data		*/
	int						FormState;				/* Formprocessing state		*/
	int						EncodingType;			/* How is formdata encoded?*/
	unsigned char			*FormSeparator;		/* Separation character		*/
	BOOL						SentHeader;				/* Sent HTTP header alrdy?	*/
	unsigned long			SessionUID;				/* Cookie Session UID		*/
	unsigned char			Language[20];			/* Primary browser language*/
	unsigned char			*URL;						/* To remember our URL		*/
	TSessionStruct			*TSession;				/* Hand	*/
	FILE						*PostData;				/* Handle to fake postdata	*/
	unsigned long			Cookie;					/* Non-zero to send cookie	*/
	unsigned char			*ContentType;			/* Force non-html content types */
} ConnectionStruct;


typedef struct _URLStruct {
	unsigned long	Request;
	unsigned long	Argument[5];

	/** 
		Here starts the private part of the structure
		Do not alter the order of above entries without
		simultaneously updating the published webadm.h
		header file
	**/

	unsigned long	Checksum;
	unsigned long	ReloginOK;
	unsigned long	SessionID;
	unsigned long	SessionUID;
	unsigned long	Template;
	unsigned long	Language;
} URLStruct;

#include <webadmin.h>

/* the other two are defined in the public webadm.h */
#define	FORMFIELD_NAME			FORMFIELD_NEXT

#define	FORM_URL_ENCODED		1
#define	FORM_DATA_ENCODED		2

typedef struct {
	char				*Name;
	char				*Value;
} FormDataStruct;

/* webadm.c */
extern SessionStruct		*SessionDB[MAX_SESSION_ENTRIES];
extern XplSemaphore		SessionMutex[MAX_SESSION_ENTRIES];
extern XplSemaphore		TSessionMutex[MAX_TSESSION_ENTRIES];
extern XplSemaphore		ExitSemaphore;
extern XplSemaphore		SessionDBSemaphore;
extern XplSemaphore		TSessionDBSemaphore;
extern ConnectionStruct	*ConnectionCache[CONNECTION_CACHE_SIZE];
extern unsigned char		WorkDir[];
extern unsigned char		LogoDir[];
extern BOOL					*WAExiting;
extern BOOL					Exiting;
extern unsigned char		*DefaultTitle;
extern unsigned char		OfficialDomain[256 + 1];
extern unsigned char		FormLogoutRedirectURL[];
extern BOOL					UseFormLogoutRedirectURL;
extern BOOL					IgnoreConfig;
extern BOOL					IgnoreRoles;
extern unsigned char		ConfigDN[MDB_MAX_OBJECT_CHARS+1];
extern unsigned char		DefaultContext[MDB_MAX_OBJECT_CHARS+1];
extern unsigned char		LocalTree[MDB_MAX_OBJECT_CHARS+1];

/* webadmu.c */
extern unsigned long		CCTop;
extern XplSemaphore		CacheSemaphore;

/* webadms.c */
extern unsigned long		DefaultConnectionTimeout;
extern unsigned long		DefaultLogoID;
extern unsigned long		DefaultLanguage;
extern unsigned long		DefaultTemplate;
extern long					DefaultTimezoneOffset;
extern unsigned long		DefaultTimezoneID;
extern unsigned char		*DefaultMonthShort[12];
extern unsigned char		*DefaultMonthLong[12];
extern unsigned char		*DefaultWDayShort[7];
extern unsigned char		*DefaultWDayLong[7];
extern unsigned char		*DefaultAMPM[2];

/* webadmt.c */
extern TemplateStruct	*PublicTemplate;
extern unsigned char		***PublicTemplateImages;
extern TemplateStruct	**Templates;
extern int					TemplateCount;
extern unsigned char		***TemplateImages;
extern int					TemplateMaxLanguages;

/* webadmm.c */
extern TemplateModuleStruct	*TModules;
extern ObjectModuleStruct		*OModules;
extern SaveModuleStruct			*SModules;
extern DeleteModuleStruct		*DModules;
extern RenameModuleStruct		*RModules;
extern unsigned long				TModuleCount;
extern unsigned long				OModuleCount;
extern unsigned long				SModuleCount;
extern unsigned long				DModuleCount;
extern unsigned long				RModuleCount;

/* Internal stuff */
#define	STATE_FRESH		0
#define	STATE_ENDING	1

#define	MSGERRBADREQUEST		"HTTP/1.1 400 Bad request\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Document doesn't exist</H1>"
#define	MSGERRBADREQUEST_LEN	103

#define	MSGERRNOMEMORY			"HTTP/1.1 500 Server out of memory\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Server out of memory</H1>"
#define	MSGERRNOMEMORY_LEN	70

#define	MSGERRBADFORM			"HTTP/1.1 500 Server too many form fields\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Too many form fields</H1>"
#define	MSGERRBADFORM_LEN	77

#define	Send404()																																																					\
{																																																											\
	WASendClient(Client, "HTTP/1.1 404 Document does not exist\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nContent-type: text/html\r\nConnection: close\r\n\r\n", 127);		\
	Client->KeepAlive = FALSE;																																																		\
	WASendClient(Client, "<H1>404 Document not found</H1>", 31);																																						\
}



/** Prototypes **/
/* Debugging */
#if defined(DEBUG)
extern int	WAScreen;
extern int	SessionScreen;
extern int	TemplateScreen;
extern int	WAModuleScreen;
#define	WADebugInit()		WAScreen=XplCreateScreen("WA General Debug Screen", 0)
#define	WADebug				XplSetCurrentScreen(WAScreen); printf("[%d] ", __LINE__); printf
#define	SessionDebug		XplSetCurrentScreen(SessionScreen); printf("[%d] ", __LINE__); printf
#define	TemplateDebug		XplSetCurrentScreen(TemplateScreen); printf("[%d] ", __LINE__); printf
#define	ModuleDebug			XplSetCurrentScreen(WAModuleScreen); printf("[%d] ", __LINE__); printf
#else
#define	WADebugInit()
#define	WADebug				if (0) printf
#define	SessionDebug		if (0) printf
#define	TemplateDebug		if (0) printf
#define	ModuleDebug			if (0) printf
#endif

typedef	int 													(*SessionFunc)(SessionStruct *Session, const unsigned char *Buf, int Len);
typedef	int 													(*ConnectionFunc)(ConnectionStruct *Connection, const unsigned char *Buf, int Len);
extern	ConnectionFunc										ConnectionFuncTbl[];
extern	SessionFunc											SessionFuncTbl[];
#define	DoNMAPWrite(Session, Buf, Len)				SessionFuncTbl[0+Session->NMAPSSL](Session, Buf, Len)
#define	DoNMAPRead(Session, Buf, Len)					SessionFuncTbl[2+Session->NMAPSSL](Session, Buf, Len)
#define	DoClientWrite(Client, Buf, Len)				ConnectionFuncTbl[0+Client->ClientSSL](Client, Buf, Len)
#define	DoClientRead(Client, Buf, Len)				ConnectionFuncTbl[2+Client->ClientSSL](Client, Buf, Len)

/* webadmin.c - main & basic functions; private */
BOOL					HandleLogo(ConnectionStruct *Client, unsigned long LogoID);
BOOL					EndClientConnection(ConnectionStruct *Client);

/* webadminu.c - utilities; private */
int					WADecodeBase64(unsigned char *Data, int Size, int *Remainder);
ConnectionStruct	*GetCachedConnection(void);
BOOL					ReleaseCachedConnection(ConnectionStruct *Client);
BOOL					RedirectAfterLogin(ConnectionStruct *Client, unsigned char *URL);
BOOL					ClearConnectionCache(void);
BOOL					SendTimeoutPage(ConnectionStruct *Client, URLStruct *URLData);
BOOL					SendReloginPage(ConnectionStruct *Client, URLStruct *URLData);
BOOL					DecodeURL(unsigned char *URL, URLStruct *URLData);
unsigned char		*GetURLFormName(unsigned char *URL, unsigned char *Name, unsigned long NameSize);
unsigned char		*GetURLFormValue(unsigned char *URL, unsigned char *Value, unsigned long *ValueSize);
BOOL					AddClass(SessionStruct *Session, const unsigned char *Class, unsigned long Description, unsigned long Image);
BOOL					FreeClassList(SessionStruct *Session);
unsigned long		FindClassTemplate(SessionStruct *Session, unsigned char *Class, unsigned long Default);


/* webadmind.c - display handling; private */
BOOL					SendHTTPHeaderDynamic(ConnectionStruct *Client, unsigned char *contentType, unsigned long contentTypeLen);
BOOL					FreeObjectList(ObjectListStruct *ObjectList);

/* webadmins.c - session management; private */
void					SessionMonitor(void);
BOOL					DestroyAllSessions(void);
BOOL					CreateSession(ConnectionStruct *Client, unsigned char *Username, unsigned char *Password, BOOL *Disabled);
SessionStruct		*RetrieveSession(unsigned long SessionID, unsigned long SessionUID);
SessionStruct		*RetrieveSessionByKey(unsigned char *Key, unsigned char *UserDN, unsigned char *Pass);
BOOL					SetSessionKey(SessionStruct *Session, unsigned char *Key);


#define				ReleaseSession(Session) {																						\
		if (Session){																														\
			Session->Timestamp = time(NULL);																							\
																																				\
			SessionDebug("Releasing session %p mutex\n", Session);															\
			XplSignalLocalSemaphore(SessionMutex[Session->SessionID]);														\
		}																																		\
	}

BOOL					DestroyTSession(TSessionStruct *TSession);
#define				ReleaseTSession(TSession)		if (TSession) {	XplSignalLocalSemaphore(TSessionMutex[TSession->SessionID]); }
TSessionStruct		*RetrieveTSession(unsigned long SessionID, unsigned long SessionUID);
TSessionStruct		*CreateTSession(void);
BOOL					SessionDBInit(void);
BOOL					SessionDBShutdown(void);


/* webadmint.c - template & preference management; private */
BOOL					SetPublicSessionTemplate(ConnectionStruct *Client, SessionStruct *Session);
unsigned long		FindLanguage(unsigned long LanguageID, long Tempate);
long					FindTemplate(unsigned char *TemplateName);
void					FreeTemplates(void);
BOOL					LoadTemplates(unsigned char *TemplatePath);
long					WAFindTaskPageEx(unsigned char *Name, unsigned long Length, TaskStruct *Task);

/* webadminp.c - page display and processing; private */
BOOL					HandleURL(ConnectionStruct *Client, SessionStruct *Session, URLStruct *URL);


/* webadminm.c - module management; private */
void					AddModule(unsigned char *Name, XplPluginHandle Handle, WAModuleShutdownFunc Shutdown);
void					FreeModules(void);
BOOL					LoadModules(unsigned char *ModulePath, BOOL ScanDir);

/* webadminp.c - portal display; private */
BOOL					HandlePublicURL(ConnectionStruct *Client, URLStruct *URL);


/* Browser Language Detection */

#define WAFindLanguage(ClientLanguage, Result)																						\
{																																					\
	signed long			Language = -1;																										\
	unsigned char		*LanguageString = (ClientLanguage);																			\
																																					\
	while (LanguageString && *LanguageString && Language == -1) {																\
		switch (LanguageString[0]) {																										\
			case 'a': {																															\
				if (LanguageString[1] == 'r') {																							\
					Language = 61;						/* ar - Arabic		*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'c': {																															\
				if (LanguageString[1] == 's') {																							\
					Language = 21;						/* cs - Czech		*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'd': {																															\
				if (LanguageString[1] == 'a') {																							\
					Language = 2;						/* da - Danish		*/																\
				} else if (LanguageString[1] == 'e') {																					\
					Language = 7;						/* de - German		*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'e': {																															\
				if (LanguageString[1] == 'n') {																							\
					Language = 4;						/* en - English	*/																\
				} else if (LanguageString[1] == 'l') {																					\
					Language = 26;						/* el - Greek		*/																\
				} else if (LanguageString[1] == 's') {																					\
					Language = 14;						/* es - Spanish	*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'f': {																															\
				if (LanguageString[1] == 'i') {																							\
					Language = 5;						/* fi - Fininish	*/																\
				} else if (LanguageString[1] == 'r') {																					\
					if (LanguageString[2] == '-' && LanguageString[3] == 'c' && LanguageString[4] == 'a') {			\
						Language = 0;					/* fr-ca - French-Canadian */													\
					} else {																														\
						Language = 6;					/* fr - French		*/																\
					}																																\
				}																																	\
				break;																															\
			}																																		\
			case 'h': {																															\
				if (LanguageString[1] == 'u') {																							\
					Language = 20;						/* hu - Hungarian	*/																\
				} else if (LanguageString[1] == 'e') {																					\
					Language = 60;						/* he - Hebrew		*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'i': {																															\
				if (LanguageString[1] == 't') {																							\
					Language = 8;						/* it - Italian	*/																\
				} else if (LanguageString[1] == 'w') {																					\
					Language = 60;						/* iw - Hebrew		*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'j': {																															\
				if (LanguageString[1] == 'a') {																							\
					Language = 9;						/* ja - Japanese	*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'k': {																															\
				if (LanguageString[1] == 'o') {																							\
					Language = 10;						/* ko - Korean		*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'n': {																															\
				if (LanguageString[1] == 'l') {																							\
					Language = 3;						/* nl - Dutch		*/																\
				} else if (LanguageString[1] == 'o') {																					\
					Language = 11;						/* no - Norwegian	*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'p': {																															\
				if (LanguageString[1] == 'l') {																							\
					Language = 17;						/* pl - Polish		*/																\
				} else if (LanguageString[1] == 't') {																					\
					Language = 12;						/* pt - Portuguese*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'r': {																															\
				if (LanguageString[1] == 'u') {																							\
					Language = 13;						/* ru - Russian	*/																\
				}																																	\
				break;																															\
			}																																		\
			case 's': {																															\
				if (LanguageString[1] == 'v') {																							\
					Language = 15;						/* sv - Swedish	*/																\
				}																																	\
				break;																															\
			}																																		\
			case 't': {																															\
				if (LanguageString[1] == 'h') {																							\
					Language = 22;						/* th - Thai		*/																\
				} else if (LanguageString[1] == 'r') {																					\
					Language = 41;						/* tr - Turkish	*/																\
				}																																	\
				break;																															\
			}																																		\
			case 'z': {																															\
				if (LanguageString[1] == 'h') {																							\
					Language = 1;						/* zh - Chinese	*/																\
				}																																	\
				break;																															\
			}																																		\
		}																																			\
																																					\
		if (Language == -1) {																												\
			LanguageString = strchr(LanguageString, ',');																			\
			if (LanguageString) {																												\
				LanguageString++;																												\
			}																																		\
		} else {																																	\
			(Result) = Language;																												\
		}																																			\
	}																																				\
}
