/****************************************************************************
 *
 * Copyright (c) 2005 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _HULA_STATISTICS
#define _HULA_STATISTICS

typedef enum _HulaStatsStates {
    HULASTATS_STATE_STARTING = 0, 
    HULASTATS_STATE_INITIALIZING, 
    HULASTATS_STATE_LOADING, 
    HULASTATS_STATE_RUNNING, 
    HULASTATS_STATE_RELOADING, 
    HULASTATS_STATE_UNLOADING, 
    HULASTATS_STATE_STOPPING, 
    HULASTATS_STATE_DONE, 

    HULASTATS_STATE_MAX_STATES
} HSStates;

typedef struct _HulaStatsGlobals {
    HSStates state;

    unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char serverDN[MDB_MAX_OBJECT_CHARS + 1];

    time_t start;

    MDBHandle directory;

    struct {
        XplThreadID main;
        XplThreadID group;
    } id;

    struct {
        Connection *conn;

        unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char rdn[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char line[CONN_BUFSIZE + 1];
    } selected;

    struct {
        XplSemaphore main;
        XplSemaphore shutdown;
    } sem;

    struct {
        StatisticsStruct cleared;
        StatisticsStruct current;
    } server;

    struct {
        BOOL enable;

        ConnSSLConfiguration config;

        SSL_CTX *context;

        Connection *conn;
    } ssl;

    struct {
        AntispamStatisticsStruct cleared;
        AntispamStatisticsStruct current;
    } spam;
} HSGlobals;

/* hulastats.c */
extern HSGlobals HulaStats;

int HulaStatsInitialize(int argc, char *argv[]);

void StatPrintNumber(unsigned long number, unsigned char *buffer);
void StatPrintFloat(unsigned long number, unsigned long divideBy, unsigned char *buffer);
void StatPrintTime(unsigned long seconds, unsigned char *buffer);

int ReleaseMessagingServer(void);
int ConnectToMessagingServer(unsigned char *dn);
int LoadStatistics(StatisticsStruct *stats);
int LoadSpamStatistics(AntispamStatisticsStruct *spamStats);

/* platform specific */
int HulaStatsUIStart(void);
int HulaStatsUIRun(void);
void HulaStatsUIStop(void);

#endif /* _HULA_STATISTICS */
